/*
 * Decompiled with CFR 0.152.
 */
package net.cyberflame.viewmodel.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import net.cyberflame.viewmodel.Viewmodel;
import net.cyberflame.viewmodel.util.Stopwatch;

public class SaveConfig {
    private static Stopwatch saveTimer;
    static final String folderName = "Viewmodel/";

    public SaveConfig() throws IOException {
        this.saveConfig();
        SaveConfig.saveAllSettings();
        saveTimer = new Stopwatch();
        SaveConfig.timedSave();
    }

    private void saveConfig() throws IOException {
        Path dir = Paths.get(folderName, new String[0]);
        if (!Files.exists(dir, new LinkOption[0])) {
            Files.createDirectories(dir, new FileAttribute[0]);
        }
    }

    public static void saveAllSettings() {
        try {
            SaveConfig.makeFile(null, "Viewmodel");
            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            OutputStreamWriter fileOutStreamWriter = new OutputStreamWriter((OutputStream)new FileOutputStream("Viewmodel/Viewmodel.json"), StandardCharsets.UTF_8);
            JsonObject viewmodelObj = new JsonObject();
            Viewmodel.getSettings().forEach(value -> viewmodelObj.add(value.getName(), value.toJson()));
            String jsonString = gson.toJson(JsonParser.parseString((String)viewmodelObj.toString()));
            fileOutStreamWriter.write(jsonString);
            fileOutStreamWriter.close();
        }
        catch (FileNotFoundException e) {
            throw new IllegalStateException("Could not find Viewmodel.json", e);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void makeFile(String location, String name) throws IOException {
        if (null != location) {
            Path path = Paths.get(folderName + location + name + ".json", new String[0]);
            if (Files.exists(path, new LinkOption[0])) {
                File file = new File(folderName + location + name + ".json");
                if (file.delete()) {
                    Files.createFile(path, new FileAttribute[0]);
                }
            } else {
                Files.createFile(path, new FileAttribute[0]);
            }
        } else {
            Path path = Paths.get(folderName + name + ".json", new String[0]);
            if (Files.exists(path, new LinkOption[0])) {
                File file = new File(folderName + name + ".json");
                file.delete();
            }
            Files.createFile(path, new FileAttribute[0]);
        }
    }

    private static void timedSave() {
        if (saveTimer.passed(5000.0)) {
            SaveConfig.saveAllSettings();
            saveTimer.reset();
        }
    }
}

