/*
 * Decompiled with CFR 0.152.
 */
package net.cyberflame.viewmodel.gui;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Objects;
import net.cyberflame.viewmodel.gui.ViewmodelGuiObj;
import net.cyberflame.viewmodel.gui.ViewmodelScreen;
import net.cyberflame.viewmodel.settings.FloatSetting;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class Slider
implements ViewmodelGuiObj {
    private final FloatSetting setting;
    private final int x;
    private final int y;
    private final int width;
    private final int height;
    private final float min;
    private final float max;

    public Slider(@NotNull FloatSetting setting, int x, int y, int width, int height) {
        this.setting = setting;
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        this.min = setting.getMin();
        this.max = setting.getMax();
    }

    private static float round(float value) {
        BigDecimal bd = new BigDecimal(value);
        bd = bd.setScale(1, RoundingMode.HALF_UP);
        return bd.floatValue();
    }

    @Override
    public final void mouseScrolled(double mx, double my, float incx, float incy) {
        float delta;
        float f = delta = Math.abs(incx) >= Math.abs(incy) ? incx : incy;
        if (delta == 0.0f) {
            return;
        }
        this.setting.setValue(Float.valueOf(class_3532.method_15363((float)(this.setting.getValue().floatValue() + delta * 0.1f), (float)this.min, (float)this.max)));
    }

    @Override
    public final void mouseClicked(double mx, double my) {
        this.setting.setValue(Float.valueOf(this.min + (float)((double)((this.max - this.min) / (float)this.width) * (mx - (double)this.x))));
    }

    @Override
    public final void render(@NotNull class_332 context, int mouseX, int mouseY) {
        FloatSetting floatSetting = this.setting;
        String settingName = floatSetting.getName();
        float settingValue = floatSetting.getValue().floatValue();
        float minValue = floatSetting.getMin();
        float maxValue = floatSetting.getMax();
        class_327 class_3272 = ViewmodelScreen.mc.field_1772;
        int n = this.x - ViewmodelScreen.mc.field_1772.method_1727(settingName) - 1;
        float f = (float)this.y + (float)this.height / 2.0f;
        Objects.requireNonNull(ViewmodelScreen.mc.field_1772);
        context.method_25303(class_3272, settingName, n, (int)(f - 9.0f / 2.0f), -1);
        int filledWidth = (int)((float)this.x + (settingValue - minValue) / (maxValue - minValue) * (float)this.width);
        context.method_25294(this.x, this.y, filledWidth, this.y + this.height, -1);
        class_327 class_3273 = ViewmodelScreen.mc.field_1772;
        String string = String.valueOf(Slider.round(settingValue));
        float f2 = (float)this.y + (float)this.height / 2.0f;
        Objects.requireNonNull(ViewmodelScreen.mc.field_1772);
        context.method_25303(class_3273, string, this.x + this.width + 1, (int)(f2 - 9.0f / 2.0f), -1);
    }

    @Override
    @Contract(pure=true)
    public final boolean isWithin(double mouseX, double mouseY) {
        return mouseX > (double)this.x && mouseY > (double)this.y && mouseX < (double)(this.x + this.width) && mouseY < (double)(this.y + this.height);
    }
}

