/*
 * Decompiled with CFR 0.152.
 */
package net.cyberflame.viewmodel.settings;

import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import java.util.Collection;
import net.cyberflame.viewmodel.gui.Slider;
import net.cyberflame.viewmodel.gui.ViewmodelGuiObj;
import net.cyberflame.viewmodel.settings.Setting;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class FloatSetting
implements Setting<Float> {
    private Float value;
    private final String name;
    private final float min;
    private final float max;

    @Contract(pure=true)
    FloatSetting(String name, float defaultValue, float minVal, float maxVal) {
        this.name = name;
        this.value = Float.valueOf(defaultValue);
        this.min = minVal;
        this.max = maxVal;
    }

    @Override
    @Contract(pure=true)
    public final String getName() {
        return this.name;
    }

    @Override
    @Contract(mutates="this")
    public final void setValue(Float val) {
        this.value = val;
    }

    @Override
    public final void setValue(@NotNull JsonElement element) {
        if (element.isJsonPrimitive() && element.getAsJsonPrimitive().isNumber()) {
            this.value = Float.valueOf(element.getAsFloat());
        }
    }

    @Override
    @Contract(value=" -> new", pure=true)
    @NotNull
    public final JsonElement toJson() {
        return new JsonPrimitive((Number)this.value);
    }

    @Override
    @Contract(pure=true)
    public final Float getValue() {
        return this.value;
    }

    @Override
    public final void createUIElement(@NotNull Collection<? super ViewmodelGuiObj> objs, int settingCount) {
        objs.add(new Slider(this, 80, 50 + (settingCount << 4), 80, 12));
    }

    @Contract(pure=true)
    public final float getMin() {
        return this.min;
    }

    @Contract(pure=true)
    public final float getMax() {
        return this.max;
    }
}

