/*
 * Decompiled with CFR 0.152.
 */
package net.cyberflame.viewmodel.settings;

import net.cyberflame.viewmodel.settings.BooleanSetting;
import net.cyberflame.viewmodel.settings.FloatSetting;
import net.cyberflame.viewmodel.settings.Setting;
import org.jetbrains.annotations.Contract;

public enum SettingType {
    CHANGE_SWING("Change Swing", false),
    POS("Position", false),
    POS_X("Position X", 0.0f, -2.0f, 2.0f),
    POS_Y("Position Y", 0.0f, -2.0f, 2.0f),
    POS_Z("Position Z", 0.0f, -2.0f, 2.0f),
    ROTATION("Rotation", false),
    ROTATION_X("Rotation X", 0.0f, -180.0f, 180.0f),
    ROTATION_Y("Rotation Y", 0.0f, -180.0f, 180.0f),
    ROTATION_Z("Rotation Z", 0.0f, -180.0f, 180.0f),
    SCALE("Scale", false),
    SCALE_X("Scale X", 1.0f, 0.0f, 3.0f),
    SCALE_Y("Scale Y", 1.0f, 0.0f, 3.0f),
    SCALE_Z("Scale Z", 1.0f, 0.0f, 3.0f);

    private final String name;
    private final Setting<?> setting;

    @Contract(pure=true)
    private SettingType(String name, boolean defaultValue) {
        this.name = name;
        this.setting = new BooleanSetting(name, defaultValue);
    }

    @Contract(pure=true)
    private SettingType(String name, float defaultValue, float minValue, float maxValue) {
        this.name = name;
        this.setting = new FloatSetting(name, defaultValue, minValue, maxValue);
    }

    @Contract(pure=true)
    public String getName() {
        return this.name;
    }

    @Contract(pure=true)
    public Setting<?> getSetting() {
        return this.setting;
    }

    public boolean isTrue() {
        if (this.setting instanceof BooleanSetting) {
            return ((BooleanSetting)this.setting).getValue();
        }
        throw new IllegalStateException("Setting is not a BooleanSetting.");
    }

    public float getFloatValue() {
        if (this.setting instanceof FloatSetting) {
            return ((FloatSetting)this.setting).getValue().floatValue();
        }
        throw new IllegalStateException("Setting is not a FloatSetting.");
    }
}

