/*
 * Decompiled with CFR 0.152.
 */
package net.cyberflame.viewmodel.config;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import net.cyberflame.viewmodel.Viewmodel;
import net.cyberflame.viewmodel.settings.Setting;

public class LoadConfig {
    public LoadConfig() throws IOException {
        this.loadAllSettings();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadAllSettings() throws IOException {
        InputStreamReader inputStreamReader = null;
        try {
            String folderName = "Viewmodel/";
            Path path = Paths.get(folderName + "Viewmodel.json", new String[0]);
            if (!Files.exists(path, new LinkOption[0])) {
                return;
            }
            InputStream inputStream = Files.newInputStream(path, new OpenOption[0]);
            inputStreamReader = new InputStreamReader(inputStream, StandardCharsets.UTF_8);
            JsonObject viewmodelObj = JsonParser.parseReader((Reader)inputStreamReader).getAsJsonObject();
            for (Setting<?> value : Viewmodel.getSettings()) {
                JsonElement valueElement = viewmodelObj.get(value.getName());
                if (null == valueElement) continue;
                value.setValue(valueElement);
            }
            inputStream.close();
        }
        catch (IOException iOException) {
        }
        finally {
            if (null != inputStreamReader) {
                inputStreamReader.close();
            }
        }
    }
}

