/*
 * Decompiled with CFR 0.152.
 */
package net.cyberflame.viewmodel.settings;

import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import java.util.Collection;
import net.cyberflame.viewmodel.gui.Switch;
import net.cyberflame.viewmodel.gui.ViewmodelGuiObj;
import net.cyberflame.viewmodel.settings.Setting;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class BooleanSetting
implements Setting<Boolean> {
    private Boolean value;
    private final String name;

    @Contract(pure=true)
    BooleanSetting(String settingName, boolean defaultValue) {
        this.name = settingName;
        this.value = defaultValue;
    }

    @Override
    @Contract(value=" -> new", pure=true)
    @NotNull
    public final JsonElement toJson() {
        return new JsonPrimitive(this.value);
    }

    @Override
    @Contract(pure=true)
    public final String getName() {
        return this.name;
    }

    @Override
    public final void setValue(@NotNull JsonElement element) {
        if (element.isJsonPrimitive() && element.getAsJsonPrimitive().isBoolean()) {
            this.value = element.getAsBoolean();
        }
    }

    @Override
    @Contract(mutates="this")
    public final void setValue(Boolean value) {
        this.value = value;
    }

    @Override
    @Contract(pure=true)
    public final Boolean getValue() {
        return this.value;
    }

    @Override
    public final void createUIElement(@NotNull Collection<? super ViewmodelGuiObj> objs, int settingCount) {
        objs.add(new Switch(this, 80, 50 + (settingCount << 4), 12));
    }
}

