/*
 * Decompiled with CFR 0.152.
 */
package com.coflnet.mixin;

import com.coflnet.config.AngryCoopProtectionManager;
import java.util.Locale;
import java.util.Optional;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_11909;
import net.minecraft.class_1661;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_465;
import net.minecraft.class_9290;
import net.minecraft.class_9334;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.glfw.GLFW;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Environment(value=EnvType.CLIENT)
@Mixin(value={class_465.class})
public abstract class AuctionProtectionMixin {
    @Shadow
    @Nullable
    protected class_1735 field_2787;

    @Shadow
    @Nullable
    public abstract class_1735 method_64240(double var1, double var3);

    @Inject(method={"mouseClicked"}, at={@At(value="HEAD")}, cancellable=true)
    private void onAngryCoopMouseClicked(class_11909 click, boolean doubleClick, CallbackInfoReturnable<Boolean> cir) {
        try {
            double mouseY;
            if (!AngryCoopProtectionManager.isEnabled()) {
                return;
            }
            int button = click.method_74245();
            if (button != 0 && button != 1) {
                return;
            }
            class_310 client = class_310.method_1551();
            if (client.field_1724 == null) {
                return;
            }
            class_465 screen = (class_465)this;
            String screenTitle = this.stripFormatting(screen.method_25440().getString());
            ScreenMode mode = this.determineScreenMode(screenTitle);
            if (mode == null) {
                return;
            }
            double mouseX = click.comp_4798();
            class_1735 clickedSlot = this.method_64240(mouseX, mouseY = click.comp_4799());
            if (clickedSlot == null || !clickedSlot.method_7681()) {
                return;
            }
            class_1799 clickedStack = clickedSlot.method_7677();
            if (clickedStack.method_7960()) {
                return;
            }
            boolean ctrlPressed = GLFW.glfwGetKey((long)client.method_22683().method_4490(), (int)341) == 1 || GLFW.glfwGetKey((long)client.method_22683().method_4490(), (int)345) == 1;
            String playerNameLower = client.field_1724.method_7334().name().toLowerCase(Locale.ROOT);
            String clickedName = this.stripFormatting(clickedStack.method_7964().getString()).trim();
            if (this.isClaimAll(clickedName)) {
                if (!ctrlPressed && this.hasForeignEntry(screen, playerNameLower, client.field_1724.method_31548(), mode)) {
                    client.field_1724.method_7353((class_2561)class_2561.method_43470((String)this.getClaimAllMessage(mode)), false);
                    cir.setReturnValue((Object)true);
                }
                return;
            }
            Optional<String> foreignActor = this.getForeignActor(clickedStack, playerNameLower, mode);
            if (foreignActor.isEmpty()) {
                return;
            }
            if (ctrlPressed) {
                return;
            }
            client.field_1724.method_7353((class_2561)class_2561.method_43470((String)this.getBlockedClickMessage(mode, foreignActor.get())), false);
            cir.setReturnValue((Object)true);
        }
        catch (Exception e) {
            System.out.println("[AuctionProtectionMixin] mouseClicked failed: " + e.getMessage());
        }
    }

    private boolean isClaimAll(String name) {
        return name.trim().equalsIgnoreCase("Claim All");
    }

    private ScreenMode determineScreenMode(String title) {
        String lower = title.toLowerCase(Locale.ROOT);
        if (lower.contains("manage auctions")) {
            return ScreenMode.SELLER;
        }
        if (lower.contains("your bids")) {
            return ScreenMode.BIDDER;
        }
        return null;
    }

    private Optional<String> getForeignActor(class_1799 stack, String playerNameLower, ScreenMode mode) {
        class_9290 loreComponent = (class_9290)stack.method_58694(class_9334.field_49632);
        if (loreComponent == null) {
            return Optional.empty();
        }
        for (class_2561 line : loreComponent.comp_2400()) {
            String raw = this.stripFormatting(line.getString());
            String lower = raw.toLowerCase(Locale.ROOT);
            if (mode == ScreenMode.SELLER) {
                if (lower.contains("this is your own auction")) {
                    return Optional.empty();
                }
                if (!lower.startsWith("seller:")) continue;
                if (!lower.contains(playerNameLower)) {
                    String seller = raw.substring("Seller:".length()).trim();
                    return Optional.of(seller.isEmpty() ? "Unknown" : seller);
                }
                return Optional.empty();
            }
            if (lower.startsWith("bidder:")) {
                if (lower.startsWith("bidder: you")) {
                    return Optional.empty();
                }
                if (!lower.contains(playerNameLower)) {
                    String bidder = raw.substring("Bidder:".length()).trim();
                    return Optional.of(bidder.isEmpty() ? "Unknown" : bidder);
                }
                return Optional.empty();
            }
            if (!lower.contains("you are the highest bidder")) continue;
            return Optional.empty();
        }
        return Optional.empty();
    }

    private boolean hasForeignEntry(class_465<?> screen, String playerNameLower, class_1661 playerInventory, ScreenMode mode) {
        for (class_1735 slot : screen.method_17577().field_7761) {
            if (slot.field_7871 == playerInventory || !slot.method_7681() || !this.getForeignActor(slot.method_7677(), playerNameLower, mode).isPresent()) continue;
            return true;
        }
        return false;
    }

    private String getClaimAllMessage(ScreenMode mode) {
        String reason = mode == ScreenMode.SELLER ? "auctions listed by co-op members" : "bids placed by co-op members";
        return "\u00a7c[SkyCofl Angry Coop] \u00a7fBlocked Claim All because " + reason + " were detected. Hold \u00a7bCtrl\u00a7f to override.";
    }

    private String getBlockedClickMessage(ScreenMode mode, String foreignName) {
        String action = mode == ScreenMode.SELLER ? "listed by" : "bid on by";
        return "\u00a7c[SkyCofl Angry Coop] \u00a7fBlocked claiming auction " + action + " \u00a7e" + foreignName + "\u00a7f. Hold \u00a7bCtrl\u00a7f to override.";
    }

    private String stripFormatting(String text) {
        if (text == null) {
            return "";
        }
        StringBuilder builder = new StringBuilder(text.length());
        boolean skip = false;
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (c == '\u00a7') {
                skip = true;
                continue;
            }
            if (skip) {
                skip = false;
                continue;
            }
            builder.append(c);
        }
        return builder.toString();
    }

    @Environment(value=EnvType.CLIENT)
    public static enum ScreenMode {
        SELLER,
        BIDDER;

    }
}

