/*
 * Decompiled with CFR 0.152.
 */
package com.coflnet.mixin;

import CoflCore.handlers.DescriptionHandler;
import com.coflnet.CoflModClient;
import com.coflnet.config.TextWidgetPositionConfig;
import com.coflnet.models.TextElement;
import com.google.gson.Gson;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_11909;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_465;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_7940;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Environment(value=EnvType.CLIENT)
@Mixin(value={class_465.class})
public abstract class HandledScreenMixin {
    private static final Gson gson = new Gson();
    @Shadow
    protected int field_2776;
    @Shadow
    protected int field_2800;
    @Shadow
    protected int field_2792;
    @Shadow
    protected int field_2779;
    protected class_7940 sideTextWidget;
    protected volatile List<class_5250> interactiveTextLines = new ArrayList<class_5250>();
    private boolean isDragging = false;
    private double dragStartX;
    private double dragStartY;
    private double widgetStartX;
    private double widgetStartY;
    private TextWidgetPositionConfig positionConfig;
    private int currentMaxWidth = 100;

    @Inject(at={@At(value="TAIL")}, method={"init"})
    public void init(CallbackInfo ci) {
        try {
            this.positionConfig = TextWidgetPositionConfig.load();
            DescriptionHandler.DescModification[] extraSlotDesc = CoflModClient.getExtraSlotDescMod();
            this.updateText(extraSlotDesc);
            String currentTitle = ((class_465)this).method_25440().getString();
            if (this.sideTextWidget != null && !currentTitle.equals("Crafting")) {
                this.sideTextWidget.method_25350(0.3f);
            }
            DescriptionHandler.setRefreshCallback((lines, title) -> {
                try {
                    class_310.method_1551().execute(() -> {
                        try {
                            this.updateText(CoflModClient.getExtraSlotDescMod());
                        }
                        catch (Exception ex) {
                            System.out.println("[HandledScreenMixin] refresh callback (on client) failed: " + ex.getMessage());
                        }
                    });
                }
                catch (Exception e) {
                    System.out.println("[HandledScreenMixin] refresh callback failed: " + e.getMessage());
                }
            });
        }
        catch (Exception e) {
            System.out.println("[HandledScreenMixin] init failed: " + e.getMessage());
        }
    }

    protected void updateText(DescriptionHandler.DescModification[] lines) {
        if (lines == null || lines.length == 0) {
            this.sideTextWidget = null;
            this.interactiveTextLines = Collections.emptyList();
            return;
        }
        this.updateTextWithJson(lines);
    }

    protected void updateTextWithJson(DescriptionHandler.DescModification[] lines) {
        this.interactiveTextLines = new ArrayList<class_5250>();
        int maxWidth = 0;
        for (DescriptionHandler.DescModification descModification : lines) {
            int width;
            if (!descModification.type.equals("APPEND") || descModification.value == null) {
                if (!descModification.type.equals("SUGGEST")) continue;
                class_5250 suggestText = class_2561.method_43470((String)("\u00a77Will suggest: \u00a7r" + descModification.value.split(": ")[1].trim()));
                this.interactiveTextLines.add(suggestText);
                int width2 = class_310.method_1551().field_1772.method_27525((class_5348)suggestText);
                if (width2 <= maxWidth) continue;
                maxWidth = width2;
                continue;
            }
            String jsonText = descModification.value.trim();
            if (!jsonText.startsWith("[") || !jsonText.endsWith("]")) {
                class_5250 regularText = class_2561.method_43470((String)descModification.value);
                this.interactiveTextLines.add(regularText);
                int width3 = class_310.method_1551().field_1772.method_27525((class_5348)regularText);
                if (width3 <= maxWidth) continue;
                maxWidth = width3;
                continue;
            }
            try {
                TextElement[] textElements = (TextElement[])gson.fromJson(jsonText, TextElement[].class);
                if (textElements == null || textElements.length == 0) {
                    class_5250 fallbackText = class_2561.method_43470((String)descModification.value);
                    this.interactiveTextLines.add(fallbackText);
                    width = class_310.method_1551().field_1772.method_27525((class_5348)fallbackText);
                    if (width <= maxWidth) continue;
                    maxWidth = width;
                    continue;
                }
                class_5250 lineText = class_2561.method_43473();
                for (int i = 0; i < textElements.length; ++i) {
                    TextElement element = textElements[i];
                    class_5250 elementText = class_2561.method_43470((String)element.text);
                    if (element.onClick != null && !element.onClick.isEmpty()) {
                        if (element.onClick.startsWith("http")) {
                            elementText.method_27694(style -> {
                                try {
                                    return style.method_10958((class_2558)new class_2558.class_10608(URI.create(element.onClick)));
                                }
                                catch (Exception e) {
                                    return style.method_10958((class_2558)new class_2558.class_10609(element.onClick));
                                }
                            });
                        } else if (element.onClick.startsWith("suggest:")) {
                            String suggestion = element.onClick.substring("suggest:".length());
                            elementText.method_27694(style -> style.method_10958((class_2558)new class_2558.class_10610(suggestion)));
                        } else if (element.onClick.startsWith("copy:")) {
                            String copyText = element.onClick.substring("copy:".length());
                            elementText.method_27694(style -> style.method_10958((class_2558)new class_2558.class_10606(copyText)));
                        } else {
                            elementText.method_27694(style -> style.method_10958((class_2558)new class_2558.class_10609(element.onClick)));
                        }
                    }
                    if (element.hover != null && !element.hover.isEmpty()) {
                        elementText.method_27694(style -> {
                            String[] hoverLines = element.hover.split("\\\\n|\\n");
                            if (hoverLines.length == 1) {
                                class_2568.class_10613 hoverEvent = new class_2568.class_10613((class_2561)class_2561.method_43470((String)element.hover));
                                return style.method_10949((class_2568)hoverEvent);
                            }
                            ArrayList<class_5250> multiLineList = new ArrayList<class_5250>();
                            for (String line : hoverLines) {
                                multiLineList.add(class_2561.method_43470((String)line));
                            }
                            class_5250 multiLineText = class_2561.method_43470((String)hoverLines[0]);
                            for (int j = 1; j < hoverLines.length; ++j) {
                                multiLineText.method_27693("\n").method_10852((class_2561)class_2561.method_43470((String)hoverLines[j]));
                            }
                            class_2568.class_10613 hoverEvent = new class_2568.class_10613((class_2561)multiLineText);
                            return style.method_10949((class_2568)hoverEvent);
                        });
                    }
                    lineText.method_10852((class_2561)elementText);
                }
                this.interactiveTextLines.add(lineText);
                width = class_310.method_1551().field_1772.method_27525((class_5348)lineText);
                if (width <= maxWidth) continue;
                maxWidth = width;
            }
            catch (Exception e) {
                class_5250 fallbackText = class_2561.method_43470((String)descModification.value);
                this.interactiveTextLines.add(fallbackText);
                width = class_310.method_1551().field_1772.method_27525((class_5348)fallbackText);
                if (width <= maxWidth) continue;
                maxWidth = width;
            }
        }
        if (this.interactiveTextLines == null || this.interactiveTextLines.isEmpty()) {
            return;
        }
        class_5250 combinedText = class_2561.method_43473();
        List<class_5250> linesSnapshot = this.interactiveTextLines;
        for (int i = 0; i < linesSnapshot.size(); ++i) {
            if (i > 0) {
                combinedText.method_27693("\n");
            }
            combinedText.method_10852((class_2561)linesSnapshot.get(i));
        }
        int widgetX = this.field_2776 + this.positionConfig.offsetX;
        if (this.positionConfig.offsetX < 0) {
            widgetX -= maxWidth;
        }
        this.currentMaxWidth = maxWidth;
        int widgetY = this.field_2800 + this.positionConfig.offsetY;
        this.sideTextWidget = new class_7940(widgetX, widgetY, (class_2561)combinedText, class_310.method_1551().field_1772);
        int n = linesSnapshot.size();
        Objects.requireNonNull(class_310.method_1551().field_1772);
        this.sideTextWidget.method_55445(maxWidth + 10, n * 9);
        this.sideTextWidget.method_25350(0.9f);
    }

    @Inject(at={@At(value="TAIL")}, method={"render"})
    public void renderMain(class_332 context, int mouseX, int mouseY, float deltaTicks, CallbackInfo ci) {
        try {
            if (this.sideTextWidget == null) {
                return;
            }
            List<class_5250> linesSnapshot = this.interactiveTextLines;
            if (linesSnapshot == null || linesSnapshot.isEmpty()) {
                this.sideTextWidget.method_25394(context, mouseX, mouseY, deltaTicks);
                return;
            }
            int startX = this.sideTextWidget.method_46426();
            int startY = this.sideTextWidget.method_46427();
            Objects.requireNonNull(class_310.method_1551().field_1772);
            int lineHeight = 9;
            for (int i = 0; i < linesSnapshot.size(); ++i) {
                class_2561 sibling2;
                class_5250 line = linesSnapshot.get(i);
                int lineY = startY + i * lineHeight;
                context.method_27535(class_310.method_1551().field_1772, (class_2561)line, startX, lineY, 0xFFFFFF);
                int textWidth = class_310.method_1551().field_1772.method_27525((class_5348)line);
                if (mouseX < startX || mouseX > startX + textWidth || mouseY < lineY || mouseY > lineY + lineHeight) continue;
                int currentX = startX;
                boolean foundHover = false;
                for (class_2561 sibling2 : line.method_10855()) {
                    class_2568 class_25682;
                    if (!(sibling2 instanceof class_5250)) continue;
                    class_5250 mutableSibling = (class_5250)sibling2;
                    int siblingWidth = class_310.method_1551().field_1772.method_27525((class_5348)mutableSibling);
                    if (mouseX >= currentX && mouseX <= currentX + siblingWidth && mutableSibling.method_10866().method_10969() != null && (class_25682 = mutableSibling.method_10866().method_10969()) instanceof class_2568.class_10613) {
                        class_2568.class_10613 showTextEvent = (class_2568.class_10613)class_25682;
                        String hoverText = showTextEvent.comp_3510().getString();
                        if (hoverText.contains("\n")) {
                            String[] lines = hoverText.split("\n");
                            ArrayList<class_5250> tooltipLines = new ArrayList<class_5250>();
                            for (String hoverline : lines) {
                                tooltipLines.add(class_2561.method_43470((String)hoverline));
                            }
                            context.method_51434(class_310.method_1551().field_1772, tooltipLines, mouseX, mouseY);
                        } else {
                            context.method_51438(class_310.method_1551().field_1772, showTextEvent.comp_3510(), mouseX, mouseY);
                        }
                        foundHover = true;
                        break;
                    }
                    currentX += siblingWidth;
                }
                if (foundHover || line.method_10866().method_10969() == null || !((sibling2 = line.method_10866().method_10969()) instanceof class_2568.class_10613)) continue;
                class_2568.class_10613 showTextEvent = (class_2568.class_10613)sibling2;
                String hoverText = showTextEvent.comp_3510().getString();
                if (hoverText.contains("\n")) {
                    String[] lines = hoverText.split("\n");
                    ArrayList<class_5250> tooltipLines = new ArrayList<class_5250>();
                    for (String tooltipLine : lines) {
                        tooltipLines.add(class_2561.method_43470((String)tooltipLine));
                    }
                    context.method_51434(class_310.method_1551().field_1772, tooltipLines, mouseX, mouseY);
                    continue;
                }
                context.method_51438(class_310.method_1551().field_1772, showTextEvent.comp_3510(), mouseX, mouseY);
            }
            this.sideTextWidget.method_25394(context, mouseX, mouseY, deltaTicks);
        }
        catch (Exception e) {
            System.out.println("[HandledScreenMixin] renderMain failed: " + e.getMessage());
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"mouseDragged"}, cancellable=true)
    public void onMouseDragged(class_11909 click, double deltaX, double deltaY, CallbackInfoReturnable<Boolean> cir) {
        try {
            int button = click.method_74245();
            double mouseX = click.comp_4798();
            double mouseY = click.comp_4799();
            if (this.isDragging && button == 1) {
                double newX = this.widgetStartX + (mouseX - this.dragStartX);
                double newY = this.widgetStartY + (mouseY - this.dragStartY);
                System.out.println("Dragging to: " + newX + ", " + newY);
                this.positionConfig.offsetX = (int)(newX - (double)this.field_2776);
                if (this.positionConfig.offsetX < -5) {
                    this.positionConfig.offsetX += this.currentMaxWidth;
                }
                this.positionConfig.offsetY = (int)(newY - (double)this.field_2800);
                if (this.sideTextWidget != null) {
                    this.updateWidgetPosition();
                }
                cir.setReturnValue((Object)true);
            }
        }
        catch (Exception e) {
            System.out.println("[HandledScreenMixin] mouseDragged failed: " + e.getMessage());
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"mouseReleased"}, cancellable=true)
    public void onMouseReleased(class_11909 click, CallbackInfoReturnable<Boolean> cir) {
        try {
            int button = click.method_74245();
            if (this.isDragging && button == 1) {
                this.isDragging = false;
                this.positionConfig.save();
                cir.setReturnValue((Object)true);
            }
        }
        catch (Exception e) {
            System.out.println("[HandledScreenMixin] mouseReleased failed: " + e.getMessage());
        }
    }

    private void updateWidgetPosition() {
        if (this.sideTextWidget != null) {
            class_5250 currentText = class_2561.method_43473();
            List<class_5250> linesSnapshot = this.interactiveTextLines;
            if (linesSnapshot != null && !linesSnapshot.isEmpty()) {
                for (int i = 0; i < linesSnapshot.size(); ++i) {
                    if (i > 0) {
                        currentText.method_27693("\n");
                    }
                    currentText.method_10852((class_2561)linesSnapshot.get(i));
                }
            } else {
                return;
            }
            int newX = this.field_2776 + this.positionConfig.offsetX;
            if (this.positionConfig.offsetX < 0) {
                newX -= this.currentMaxWidth;
            }
            int newY = this.field_2800 + this.positionConfig.offsetY;
            this.sideTextWidget = new class_7940(newX, newY, (class_2561)currentText, class_310.method_1551().field_1772);
            this.sideTextWidget.method_55445(this.sideTextWidget.method_25368(), this.sideTextWidget.method_25364());
            this.sideTextWidget.method_25350(0.9f);
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"mouseClicked"}, cancellable=true)
    public void onMouseClicked(class_11909 click, boolean doubleClick, CallbackInfoReturnable<Boolean> cir) {
        try {
            double mouseX = click.comp_4798();
            double mouseY = click.comp_4799();
            int button = click.method_74245();
            List<class_5250> linesSnapshot = this.interactiveTextLines;
            if (linesSnapshot == null || linesSnapshot.isEmpty() || this.sideTextWidget == null) {
                return;
            }
            int startX = this.sideTextWidget.method_46426();
            int startY = this.sideTextWidget.method_46427();
            Objects.requireNonNull(class_310.method_1551().field_1772);
            int lineHeight = 9;
            boolean overWidget = false;
            int widgetWidth = 0;
            int widgetHeight = linesSnapshot.size() * lineHeight;
            for (class_5250 line : linesSnapshot) {
                int lineWidth = class_310.method_1551().field_1772.method_27525((class_5348)line);
                if (lineWidth <= widgetWidth) continue;
                widgetWidth = lineWidth;
            }
            if (mouseX >= (double)startX && mouseX <= (double)(startX + widgetWidth) && mouseY >= (double)startY && mouseY <= (double)(startY + widgetHeight)) {
                overWidget = true;
            }
            if (button == 1 && overWidget) {
                this.isDragging = true;
                this.dragStartX = mouseX;
                this.dragStartY = mouseY;
                this.widgetStartX = startX;
                this.widgetStartY = startY;
                cir.setReturnValue((Object)true);
                return;
            }
            if (button == 0) {
                for (int i = 0; i < linesSnapshot.size(); ++i) {
                    class_5250 line;
                    line = linesSnapshot.get(i);
                    int lineY = startY + i * lineHeight;
                    int textWidth = class_310.method_1551().field_1772.method_27525((class_5348)line);
                    if (mouseX < (double)startX || mouseX > (double)(startX + textWidth) || mouseY < (double)lineY || mouseY > (double)(lineY + lineHeight)) continue;
                    int currentX = startX;
                    for (class_2561 sibling : line.method_10855()) {
                        boolean handled;
                        if (!(sibling instanceof class_5250)) continue;
                        class_5250 mutableSibling = (class_5250)sibling;
                        int siblingWidth = class_310.method_1551().field_1772.method_27525((class_5348)mutableSibling);
                        if (mouseX >= (double)currentX && mouseX <= (double)(currentX + siblingWidth) && (handled = ((class_465)this).method_25430(mutableSibling.method_10866()))) {
                            cir.setReturnValue((Object)true);
                            return;
                        }
                        currentX += siblingWidth;
                    }
                    boolean handled = ((class_465)this).method_25430(line.method_10866());
                    if (!handled) continue;
                    cir.setReturnValue((Object)true);
                    return;
                }
            }
        }
        catch (Exception e) {
            System.out.println("[HandledScreenMixin] mouseClicked failed: " + e.getMessage());
        }
    }
}

