/*
 * Decompiled with CFR 0.152.
 */
package com.coflnet;

import CoflCore.CoflCore;
import CoflCore.CoflSkyCommand;
import CoflCore.classes.Position;
import CoflCore.classes.Settings;
import CoflCore.commands.Command;
import CoflCore.commands.CommandType;
import CoflCore.commands.RawCommand;
import CoflCore.commands.models.FlipData;
import CoflCore.commands.models.HotkeyRegister;
import CoflCore.configuration.GUIType;
import CoflCore.handlers.DescriptionHandler;
import CoflCore.handlers.EventRegistry;
import com.coflnet.EventSubscribers;
import com.coflnet.config.AngryCoopProtectionManager;
import com.coflnet.config.CoflModConfig;
import com.coflnet.config.SellProtectionManager;
import com.coflnet.gui.BinGUI;
import com.coflnet.gui.RenderUtils;
import com.coflnet.gui.cofl.CoflBinGUI;
import com.coflnet.gui.tfm.TfmBinGUI;
import com.coflnet.utils.SellAmountParser;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.serialization.DynamicOps;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandRegistrationCallback;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientLifecycleEvents;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.item.v1.ItemTooltipCallback;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.fabricmc.fabric.api.client.message.v1.ClientReceiveMessageEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.fabricmc.fabric.api.client.rendering.v1.HudRenderCallback;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderEvents;
import net.fabricmc.fabric.api.client.screen.v1.ScreenEvents;
import net.fabricmc.fabric.api.event.player.UseBlockCallback;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_124;
import net.minecraft.class_1263;
import net.minecraft.class_1269;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1707;
import net.minecraft.class_1713;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2507;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2586;
import net.minecraft.class_2621;
import net.minecraft.class_2625;
import net.minecraft.class_266;
import net.minecraft.class_268;
import net.minecraft.class_269;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3545;
import net.minecraft.class_3675;
import net.minecraft.class_3797;
import net.minecraft.class_408;
import net.minecraft.class_437;
import net.minecraft.class_442;
import net.minecraft.class_465;
import net.minecraft.class_476;
import net.minecraft.class_634;
import net.minecraft.class_640;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import net.minecraft.class_746;
import net.minecraft.class_8646;
import net.minecraft.class_8816;
import net.minecraft.class_9015;
import net.minecraft.class_9290;
import net.minecraft.class_9331;
import net.minecraft.class_9334;
import org.lwjgl.glfw.GLFW;

@Environment(value=EnvType.CLIENT)
public class CoflModClient
implements ClientModInitializer {
    public static final String targetVersion = "1.21.8";
    public static final int InventorysizeWithOffHand = 46;
    public static Gson gson = new GsonBuilder().excludeFieldsWithoutExposeAnnotation().create();
    private static boolean keyPressed = false;
    private static int counter = 0;
    public static class_304 bestflipsKeyBinding;
    public static class_304 uploadItemKeyBinding;
    public static List<class_304> additionalKeyBindings;
    public static Map<class_304, HotkeyRegister> keybindingsToHotkeys;
    public static ArrayList<String> knownIds;
    public static class_3545<String, String> lastScoreboardUploaded;
    private String username = "";
    private static String lastNbtRequest;
    private boolean uploadedScoreboard = false;
    private static boolean popupShown;
    public static Position posToUpload;
    public static CoflModClient instance;
    public static class_2625 sign;
    public static String pendingBazaarSearch;

    public void onInitializeClient() {
        instance = this;
        this.username = class_310.method_1551().method_1548().method_1676();
        Path configDir = FabricLoader.getInstance().getConfigDir();
        CoflCore cofl = new CoflCore();
        cofl.init(configDir);
        cofl.registerEventFile((Object)new EventSubscribers());
        ClientLifecycleEvents.CLIENT_STARTED.register(mc -> RenderUtils.init());
        bestflipsKeyBinding = KeyBindingHelper.registerKeyBinding((class_304)new class_304("keybinding.coflmod.bestflips", class_3675.class_307.field_1668, 66, "SkyCofl"));
        uploadItemKeyBinding = KeyBindingHelper.registerKeyBinding((class_304)new class_304("keybinding.coflmod.uploaditem", class_3675.class_307.field_1668, 73, "SkyCofl"));
        ClientTickEvents.END_CLIENT_TICK.register(client -> {
            if (bestflipsKeyBinding.method_1434()) {
                if (counter == 0) {
                    EventRegistry.onOpenBestFlip((String)this.username, (boolean)true);
                }
                if (counter < 2) {
                    ++counter;
                }
            } else {
                counter = 0;
            }
            if (uploadItemKeyBinding.method_1436()) {
                this.handleGetHoveredItem(client);
            }
            if (additionalKeyBindings == null) {
                return;
            }
            try {
                for (class_304 additionalKeyBinding : additionalKeyBindings) {
                    if (!additionalKeyBinding.method_1436()) continue;
                    String keyName = CoflModClient.keybindingsToHotkeys.get((Object)additionalKeyBinding).Name;
                    String toAppend = CoflModClient.getContextToAppend(client.field_1724.method_31548().method_5438(client.field_1724.method_31548().method_67532()));
                    System.out.println("Exec hotkey " + keyName + toAppend);
                    CoflSkyCommand.processCommand((String[])new String[]{"hotkey", keyName + toAppend}, (String)class_310.method_1551().method_1548().method_1676());
                }
            }
            catch (ConcurrentModificationException e) {
                System.out.println("Additional Keybindings currently in use somewhere else, retrying...");
            }
        });
        ClientPlayConnectionEvents.JOIN.register((handler, sender, server) -> {
            if (class_310.method_1551() != null && class_310.method_1551().method_1558() != null && class_310.method_1551().method_1558().field_3761.contains("hypixel.net")) {
                System.out.println("Connected to Hypixel");
                this.username = class_310.method_1551().method_1548().method_1676();
                if (!CoflCore.Wrapper.isRunning && CoflCore.config.autoStart) {
                    CoflSkyCommand.start((String)this.username);
                }
                Thread.startVirtualThread(() -> {
                    try {
                        Thread.sleep(5000L);
                        if (!CoflCore.Wrapper.isRunning) {
                            return;
                        }
                        CoflModClient.uploadScoreboard();
                        CoflModClient.uploadTabList();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                });
            }
            DescriptionHandler.emptyTooltipData();
            this.uploadedScoreboard = false;
            EventSubscribers.positions = null;
        });
        ClientPlayConnectionEvents.DISCONNECT.register((handler, server) -> {
            if (CoflCore.Wrapper.isRunning) {
                System.out.println("Disconnected from server");
                CoflCore.Wrapper.stop();
            }
        });
        ClientCommandRegistrationCallback.EVENT.register((dispatcher, registryAccess) -> {
            this.registerDefaultCommands((CommandDispatcher<FabricClientCommandSource>)dispatcher, "cofl");
            this.registerDefaultCommands((CommandDispatcher<FabricClientCommandSource>)dispatcher, "cl");
            dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)"fc").executes(context -> {
                CoflSkyCommand.processCommand((String[])new String[]{"chat"}, (String)this.username);
                return 1;
            })).then(ClientCommandManager.argument((String)"args", (ArgumentType)StringArgumentType.greedyString()).suggests((context, builder) -> {
                String[] suggestions = new String[]{":tableflip:", ":sad:", ":smile:", ":grin:", ":heart:", ":skull:", ":airplane:", ":check:", "<3", ":star:", ":yes:", ":no:", ":java:", ":arrow", ":shrug:", "o/", ":123:", ":totem:", ":typing:", ":maths:", ":snail:", ":thinking:", ":gimme:", ":wizard:", ":pvp:", ":peace:", ":oof:", ":puffer:", ":yey:", ":cat:", ":dab:", ":dj:", ":snow:", ":^_^:", ":^-^:", ":sloth:", ":cute:", ":dog:", ":fyou:", ":angwyflip:", ":snipe:", ":preapi:", ":tm:", ":r:", ":c:", ":crown:", ":fire:", ":sword:", ":shield:", ":cross:", ":star1:", ":star2:", ":star3:", ":star4:", ":rich:", ":boop:", ":yay:", ":gg:"};
                String input = context.getInput();
                String[] inputParts = input.split(" ");
                String currentWord = inputParts.length > 0 ? inputParts[inputParts.length - 1] : "";
                for (String suggestion : suggestions) {
                    if (!suggestion.toLowerCase().startsWith(currentWord.toLowerCase())) continue;
                    builder.suggest(suggestion, (Message)new TooltipMessage(this, "Will be replaced with the emoji"));
                }
                return builder.buildFuture();
            }).executes(context -> {
                String[] args = ((String)context.getArgument("args", String.class)).split(" ");
                String[] newArgs = new String[args.length + 1];
                System.arraycopy(args, 0, newArgs, 1, args.length);
                newArgs[0] = "chat";
                CoflSkyCommand.processCommand((String[])newArgs, (String)this.username);
                return 1;
            })));
        });
        ScreenEvents.AFTER_INIT.register((client, screen, scaledWidth, scaledHeight) -> {
            if (screen instanceof class_476) {
                class_476 gcs = (class_476)screen;
                if (CoflCore.config.purchaseOverlay != null && gcs.method_25440() != null && !(client.field_1755 instanceof BinGUI) && CoflModClient.isBINAuction(gcs)) {
                    if (CoflCore.config.purchaseOverlay == GUIType.COFL) {
                        client.method_1507((class_437)new CoflBinGUI(gcs));
                    }
                    if (CoflCore.config.purchaseOverlay == GUIType.TFM) {
                        client.method_1507((class_437)new TfmBinGUI(gcs));
                    }
                }
            }
        });
        ScreenEvents.AFTER_INIT.register((client, screen, scaledWidth, scaledHeight) -> {
            if (screen instanceof class_465) {
                class_465 hs = (class_465)screen;
                knownIds.clear();
                this.loadDescriptionsForInv(hs);
                if (!this.uploadedScoreboard) {
                    CoflModClient.uploadScoreboard();
                    CoflModClient.uploadTabList();
                    this.uploadedScoreboard = true;
                }
            }
        });
        ItemTooltipCallback.EVENT.register((stack, tooltipContext, tooltipType, lines) -> {
            class_437 patt0$temp;
            String stackId = CoflModClient.getIdFromStack(stack);
            if (!knownIds.contains(stackId) && (patt0$temp = class_310.method_1551().field_1755) instanceof class_465) {
                class_465 hs = (class_465)patt0$temp;
                if (!stack.method_7960() && !stackId.equals("Go Back;1")) {
                    this.loadDescriptionsForInv(hs);
                }
                knownIds.add(stackId);
                System.out.println("Missing descriptions for " + stackId);
                return;
            }
            DescriptionHandler.DescModification[] tooltips = DescriptionHandler.getTooltipData((String)stackId);
            if (tooltips == null) {
                return;
            }
            class_9290 text = (class_9290)stack.method_58694(class_9334.field_49632);
            List ogLoreLines = text == null ? new ArrayList() : text.comp_2400();
            block14: for (DescriptionHandler.DescModification tooltip : tooltips) {
                switch (tooltip.type) {
                    case "APPEND": {
                        lines.add(class_2561.method_30163((String)(tooltip.value + " ")));
                        continue block14;
                    }
                    case "REPLACE": {
                        if (tooltip.line < 0 || tooltip.line >= lines.size() || tooltip.line >= ogLoreLines.size()) {
                            System.out.println("Invalid line index: " + tooltip.line + " for tooltip: " + tooltip.value);
                            continue block14;
                        }
                        int targetLine = tooltip.line;
                        if (targetLine != 0 && class_124.method_539((String)((class_2561)ogLoreLines.get(targetLine)).toString()).equals(class_124.method_539((String)((class_2561)lines.get(targetLine)).toString()))) {
                            System.out.println("lines differ `" + class_124.method_539((String)((class_2561)ogLoreLines.get(targetLine + 1)).toString()) + "` to `" + class_124.method_539((String)((class_2561)lines.get(targetLine)).toString()) + "`");
                            ++targetLine;
                        }
                        lines.remove(targetLine);
                        lines.add(targetLine, class_2561.method_30163((String)tooltip.value));
                        continue block14;
                    }
                    case "INSERT": {
                        lines.add(tooltip.line, class_2561.method_30163((String)tooltip.value));
                        continue block14;
                    }
                    case "DELETE": {
                        lines.remove(tooltip.line);
                        continue block14;
                    }
                    case "HIGHLIGHT": {
                        continue block14;
                    }
                    default: {
                        System.out.println("Unknown type: " + tooltip.type);
                    }
                }
            }
            CoflModClient.addSellProtectionTooltip(stack, lines);
        });
        HudRenderCallback.EVENT.register((drawContext, tickCounter) -> {
            if (EventSubscribers.showCountdown && EventSubscribers.countdownData != null && (class_310.method_1551().field_1755 == null || class_310.method_1551().field_1755 instanceof class_408)) {
                int heightPercentage = EventSubscribers.countdownData.getHeightPercentage();
                int widthPercentage = EventSubscribers.countdownData.getWidthPercentage();
                int screenWidth = drawContext.method_51421();
                int screenHeight = drawContext.method_51443();
                int x = screenWidth * widthPercentage / 100;
                int y = screenHeight * heightPercentage / 100;
                RenderUtils.drawStringWithShadow(drawContext, EventSubscribers.countdownData.getPrefix() + CoflModClient.getStringFromDouble(EventSubscribers.countdown, EventSubscribers.countdownData.getMaxPrecision()), x, y, -1, EventSubscribers.countdownData.getScale());
            }
        });
        ClientReceiveMessageEvents.ALLOW_GAME.register((message, overlay) -> {
            EventRegistry.onChatMessage((String)message.getString());
            String previousHover = null;
            for (class_2561 component : message.method_10855()) {
                class_2568.class_10613 hest;
                String text;
                class_2568 patt0$temp;
                if (component.method_10866().method_10969() == null || !((patt0$temp = component.method_10866().method_10969()) instanceof class_2568.class_10613) || (text = (hest = (class_2568.class_10613)patt0$temp).comp_3510().getString()).equals(previousHover)) continue;
                previousHover = text;
                EventRegistry.onChatMessage((String)hest.comp_3510().getString());
            }
            return true;
        });
        ScreenEvents.AFTER_INIT.register((minecraftClient, screen, i, i1) -> {
            if (!(class_310.method_1551().field_1755 instanceof class_442)) {
                return;
            }
            if (!popupShown && !this.checkVersionCompability()) {
                popupShown = true;
                class_437 currentScreen = class_310.method_1551().field_1755;
                class_310.method_1551().method_1507((class_437)new class_8816.class_8817(currentScreen, class_2561.method_30163((String)"Warning")).method_54130((class_2561)class_2561.method_43470((String)"Modrinth"), popupScreen -> class_156.method_668().method_670("https://modrinth.com/mod/skycofl/versions")).method_54130(class_2561.method_30163((String)"GitHub"), popupScreen -> class_156.method_668().method_670("https://github.com/Coflnet/SkyblockModFabric/releases")).method_54130(class_2561.method_30163((String)"dismiss"), popupScreen -> popupScreen.method_25419()).method_54129(class_2561.method_30163((String)"This version of the SkyCofl mod is meant for use in Minecraft 1.21.8 and likely won't work on this version.\nYou can find other versions of SkyCofl here:")).method_54125());
            }
        });
        ClientReceiveMessageEvents.GAME.register((text, b) -> {
            String[] scores = CoflModClient.getScoreboard().toArray(new String[0]);
            if (scores == null || scores.length < 9) {
                return;
            }
            class_3545<String, String> newData = CoflModClient.getRelevantLinesFromScoreboard(scores);
            if (((String)newData.method_15442()).equals(lastScoreboardUploaded.method_15442()) && ((String)newData.method_15441()).equals(lastScoreboardUploaded.method_15441())) {
                return;
            }
            System.out.println("Uploading Scoreboard...");
            CoflModClient.uploadScoreboard();
        });
        UseBlockCallback.EVENT.register((playerEntity, world, hand, blockHitResult) -> {
            class_2586 patt0$temp = world.method_8321(blockHitResult.method_17777());
            if (patt0$temp instanceof class_2621) {
                class_2621 lcbe = (class_2621)patt0$temp;
                System.out.println("Lootable opened, saving position of lootable Block...");
                class_2338 pos = blockHitResult.method_17777();
                posToUpload = new Position(Integer.valueOf(pos.method_10263()), Integer.valueOf(pos.method_10264()), Integer.valueOf(pos.method_10260()));
            }
            return class_1269.field_5811;
        });
        WorldRenderEvents.LAST.register(worldRenderContext -> {
            if (EventSubscribers.positions == null || EventSubscribers.positions.size() == 0) {
                return;
            }
            for (Position position : EventSubscribers.positions) {
                RenderUtils.renderHighlightBox(worldRenderContext, new double[]{position.getX().intValue(), (double)position.getY().intValue() + 1.0, position.getZ() + 1}, new double[]{position.getX() + 1, position.getY().intValue(), position.getZ().intValue()}, new float[]{0.3f, 1.0f, 0.1f, 0.5f});
            }
        });
        ScreenEvents.AFTER_INIT.register((minecraftClient, screen, i, i1) -> {});
    }

    private static String getStringFromDouble(double seconds, int currentPrecision) {
        String render;
        if (seconds > 100.0) {
            render = String.valueOf((int)seconds);
        } else {
            render = String.format(Locale.US, "%.3f", seconds).substring(0, currentPrecision);
            if (render.charAt(render.length() - 1) == '.') {
                render = render.substring(0, currentPrecision - 1);
            }
        }
        return render + "s";
    }

    private void registerDefaultCommands(CommandDispatcher<FabricClientCommandSource> dispatcher, String name) {
        dispatcher.register((LiteralArgumentBuilder)ClientCommandManager.literal((String)name).then(ClientCommandManager.argument((String)"args", (ArgumentType)StringArgumentType.greedyString()).suggests((context, builder) -> {
            String currentWord;
            String input = context.getInput();
            String[] inputArgs = input.split(" ");
            String string = currentWord = inputArgs.length > 0 ? inputArgs[inputArgs.length - 1] : "";
            if (inputArgs.length == 2 && (input.contains("set ") || input.equals("s ")) || inputArgs.length == 3 && (inputArgs[1].equals("s") || inputArgs[1].equals("set"))) {
                if ("sellprotectionenabled".contains(currentWord.toLowerCase()) || currentWord.equals("set")) {
                    builder.suggest("set sellProtectionEnabled", new Message(this){

                        public String getString() {
                            return "Enable or disable sell protection (true/false)";
                        }
                    });
                }
                if ("sellprotectionthreshold".contains(currentWord.toLowerCase()) || currentWord.equals("set")) {
                    builder.suggest("set sellProtectionThreshold", new Message(this){

                        public String getString() {
                            return "Set max coin amount before sell protection blocks sells (e.g. 1000, 2k, 3m)";
                        }
                    });
                }
                if ("angrycoopprotectionenabled".contains(currentWord.toLowerCase()) || currentWord.equals("set")) {
                    builder.suggest("set angryCoopProtectionEnabled", new Message(this){

                        public String getString() {
                            return "Enable or disable angry co-op protection (true/false)";
                        }
                    });
                }
                for (Settings suggestion : CoflCore.config.knownSettings) {
                    if (!suggestion.getSettingKey().toLowerCase().contains(currentWord.toLowerCase()) && !currentWord.equals("set") && !currentWord.equals("s")) continue;
                    final String settingInfo = suggestion.getSettingInfo();
                    if (settingInfo == null) {
                        builder.suggest("set " + suggestion.getSettingKey());
                        continue;
                    }
                    builder.suggest("set " + suggestion.getSettingKey(), new Message(){

                        public String getString() {
                            return settingInfo;
                        }
                    });
                }
            } else {
                if (inputArgs.length > 3) {
                    return builder.buildFuture();
                }
                if (CoflCore.config.knownCommands == null) {
                    System.out.println("No known commands loaded yet, cannot suggest");
                    return builder.buildFuture();
                }
                for (String suggestion : CoflCore.config.knownCommands.keySet()) {
                    if (!suggestion.toLowerCase().startsWith(currentWord.toLowerCase()) && inputArgs.length != 1) continue;
                    final String messageText = (String)CoflCore.config.knownCommands.get(suggestion);
                    if (messageText == null) {
                        builder.suggest(suggestion);
                        continue;
                    }
                    builder.suggest(suggestion, new Message(){

                        public String getString() {
                            String[] parts = messageText.split("\n");
                            return parts.length > 0 ? parts[0] : "";
                        }
                    });
                }
            }
            return builder.buildFuture();
        }).executes(context -> {
            String[] args = ((String)context.getArgument("args", String.class)).split(" ");
            if (args.length >= 2 && args[0].equals("set")) {
                if (args[1].equals("sellProtectionEnabled")) {
                    if (args.length >= 3) {
                        boolean enabled = args[2].equalsIgnoreCase("true") || args[2].equals("1");
                        SellProtectionManager.setEnabled(enabled);
                        CoflModClient.sendChatMessage("\u00a7aSell Protection " + (enabled ? "enabled" : "disabled"));
                        return 1;
                    }
                    CoflModClient.sendChatMessage("\u00a7cUsage: /cofl set sellProtectionEnabled <true/false>");
                    return 1;
                }
                if (args[1].equals("sellProtectionThreshold")) {
                    if (args.length >= 3) {
                        try {
                            long amount = CoflModClient.parseAmountString(args[2]);
                            SellProtectionManager.setMaxAmount(amount);
                            CoflModClient.sendChatMessage("\u00a7aSell Protection max amount set to " + CoflModClient.formatCoins(amount) + " coins");
                            return 1;
                        }
                        catch (NumberFormatException e) {
                            CoflModClient.sendChatMessage("\u00a7cInvalid number: " + args[2] + ". Use formats like: 1000, 2k, 3m, 1.5b");
                            return 1;
                        }
                    }
                    CoflModClient.sendChatMessage("\u00a7cUsage: /cofl set sellProtectionThreshold <amount>");
                    CoflModClient.sendChatMessage("\u00a77Examples: 1000, 2k, 3m, 1.5b");
                    return 1;
                }
                if (args[1].equals("angryCoopProtectionEnabled")) {
                    if (args.length >= 3) {
                        boolean enabled = args[2].equalsIgnoreCase("true") || args[2].equals("1");
                        AngryCoopProtectionManager.setEnabled(enabled);
                        CoflModClient.sendChatMessage("\u00a7aAngry Co-op Protection " + (enabled ? "enabled" : "disabled"));
                        return 1;
                    }
                    CoflModClient.sendChatMessage("\u00a7cUsage: /cofl set angryCoopProtectionEnabled <true/false>");
                    return 1;
                }
            } else if (args.length >= 1 && args[0].equals("sellprotection")) {
                if (args.length == 1) {
                    CoflModConfig config = SellProtectionManager.getConfig();
                    CoflModClient.sendChatMessage("\u00a76=== Sell Protection Settings ===");
                    CoflModClient.sendChatMessage("\u00a77Enabled: " + (config.sellProtectionEnabled ? "\u00a7aYes" : "\u00a7cNo"));
                    CoflModClient.sendChatMessage("\u00a77Max Amount: \u00a76" + CoflModClient.formatCoins(config.sellProtectionThreshold) + " coins");
                    CoflModClient.sendChatMessage("\u00a77Usage: \u00a7e/cofl set sellProtectionEnabled <true/false>");
                    CoflModClient.sendChatMessage("\u00a77Usage: \u00a7e/cofl set sellProtectionThreshold <amount>");
                    CoflModClient.sendChatMessage("\u00a77Examples: \u00a7e1000\u00a77, \u00a7e2k\u00a77, \u00a7e3m\u00a77, \u00a7e1.5b");
                    return 1;
                }
            } else if (args.length >= 1 && args[0].equals("angrycoop") && args.length == 1) {
                CoflModConfig config = AngryCoopProtectionManager.getConfig();
                CoflModClient.sendChatMessage("\u00a76=== Angry Co-op Protection Settings ===");
                CoflModClient.sendChatMessage("\u00a77Enabled: " + (config.angryCoopProtectionEnabled ? "\u00a7aYes" : "\u00a7cNo"));
                CoflModClient.sendChatMessage("\u00a77Usage: \u00a7e/cofl set angryCoopProtectionEnabled <true/false>");
                return 1;
            }
            if (args.length >= 1 && args[0].equalsIgnoreCase("bazaarsearch")) {
                if (args.length >= 2) {
                    CharSequence[] part = new String[args.length - 1];
                    System.arraycopy(args, 1, part, 0, part.length);
                    String searchTerm = String.join((CharSequence)" ", part);
                    CoflModClient.searchInBazaarSmart(searchTerm);
                    return 1;
                }
                CoflModClient.sendChatMessage("\u00a7cUsage: /cofl bazaarsearch <item>");
                return 1;
            }
            CoflSkyCommand.processCommand((String[])args, (String)this.username);
            return 1;
        })));
    }

    private void handleGetHoveredItem(class_310 client) {
        CoflModClient.uploadItem(client.field_1724.method_31548().method_5438(client.field_1724.method_31548().method_67532()));
    }

    public static void uploadItem(class_1799 hoveredStack) {
        class_310 client = class_310.method_1551();
        if (client.field_1724 == null || hoveredStack == null) {
            return;
        }
        RawCommand data = new RawCommand("hotkey", gson.toJson((Object)("upload_item" + CoflModClient.getContextToAppend(hoveredStack))));
        CoflCore.Wrapper.SendMessage(data);
    }

    private static String getContextToAppend(class_1799 hoveredStack) {
        String toAppend = "";
        class_310 client = class_310.method_1551();
        if (client.field_1724 == null) {
            return "";
        }
        class_2371 mockList = class_2371.method_10211();
        mockList.add((Object)hoveredStack);
        return "|" + CoflModClient.inventoryToNBT((class_2371<class_1799>)mockList);
    }

    private static void uploadTabList() {
        Command data = new Command(CommandType.uploadTab, (Object)CoflModClient.getTabList().toArray(new String[0]));
        if (CoflCore.Wrapper != null) {
            CoflCore.Wrapper.SendMessage(data);
        }
    }

    private static void uploadScoreboard() {
        String[] scores = CoflModClient.getScoreboard().toArray(new String[0]);
        lastScoreboardUploaded = CoflModClient.getRelevantLinesFromScoreboard(scores);
        Command data = new Command(CommandType.uploadScoreboard, (Object)scores);
        if (CoflCore.Wrapper != null) {
            CoflCore.Wrapper.SendMessage(data);
        }
    }

    public static FlipData popFlipData() {
        FlipData fd = EventSubscribers.flipData;
        EventSubscribers.flipData = null;
        return fd;
    }

    public static class_3414 findByName(String name) {
        class_3414 result = (class_3414)class_3417.field_14793.comp_349();
        for (Field f : class_3417.class.getDeclaredFields()) {
            if (!f.getName().equalsIgnoreCase(name)) continue;
            try {
                try {
                    result = (class_3414)f.get(class_3414.class);
                }
                catch (ClassCastException e) {
                    result = (class_3414)((class_6880.class_6883)f.get(class_6880.class_6883.class)).comp_349();
                }
            }
            catch (IllegalAccessException e) {
                System.out.println("SoundEvent inaccessible. This shouldn't happen");
            }
            break;
        }
        return result;
    }

    public static class_2371<class_1799> inventoryToItemStacks(class_1263 inventory) {
        class_2371 itemStacks = class_2371.method_10211();
        for (int i = 0; i < inventory.method_5439(); ++i) {
            itemStacks.add((Object)inventory.method_5438(i));
        }
        return itemStacks;
    }

    public static String inventoryToNBT(class_1263 inventory) {
        return CoflModClient.inventoryToNBT(CoflModClient.inventoryToItemStacks(inventory));
    }

    public static String[] getItemIdsFromInventory(class_1263 inventory) {
        return CoflModClient.getItemIdsFromInventory(CoflModClient.inventoryToItemStacks(inventory));
    }

    public static String inventoryToNBT(class_2371<class_1799> itemStacks) {
        class_2487 nbtCompound = new class_2487();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        class_746 player = class_310.method_1551().field_1724;
        try {
            nbtCompound = CoflModClient.writeNbt(nbtCompound, itemStacks, (class_7225.class_7874)player.method_56673());
            class_2507.method_10634((class_2487)nbtCompound, (OutputStream)baos);
            return Base64.getEncoder().encodeToString(baos.toByteArray());
        }
        catch (IOException e) {
            e.printStackTrace();
            return "";
        }
    }

    public static class_2487 writeNbt(class_2487 nbt, class_2371<class_1799> stacks, class_7225.class_7874 registries) {
        class_2499 nbtList = new class_2499();
        for (int i = 0; i < stacks.size(); ++i) {
            class_2487 nbtCompound;
            class_1799 itemStack = (class_1799)stacks.get(i);
            if (!itemStack.method_7960()) {
                nbtCompound = new class_2487();
                nbtCompound.method_10567("Slot", (byte)i);
                nbtList.add((Object)((class_2520)class_1799.field_24671.encode((Object)itemStack, (DynamicOps)registries.method_57093((DynamicOps)class_2509.field_11560), (Object)nbtCompound).getOrThrow()));
                continue;
            }
            nbtCompound = new class_2487();
            nbtList.add((Object)nbtCompound);
        }
        if (!nbtList.isEmpty()) {
            nbt.method_10566("i", (class_2520)nbtList);
        }
        return nbt;
    }

    public static String[] getItemIdsFromInventory(class_2371<class_1799> itemStacks) {
        ArrayList<Object> res = new ArrayList<Object>();
        for (int i = 0; i < itemStacks.size(); ++i) {
            class_1799 stack = (class_1799)itemStacks.get(i);
            if (stack.method_7909() != class_1802.field_8162) {
                String id = CoflModClient.getIdFromStack(stack);
                knownIds.add(id);
                res.add(id);
                continue;
            }
            res.add("EMPTY_SLOT_" + i);
        }
        return (String[])res.toArray(String[]::new);
    }

    public static String getIdFromStack(class_1799 stack) {
        String itemName;
        JsonObject stackJson = null;
        for (Object type : stack.method_57353().method_57831()) {
            if (!type.toString().contains("minecraft:custom_data")) continue;
            stackJson = (JsonObject)gson.fromJson(stack.method_58694((class_9331)type).toString(), JsonObject.class);
        }
        String string = itemName = stack.method_65130() == null ? stack.method_7909().method_63680().getString() : stack.method_65130().getString();
        if (itemName.contains("BUY") || itemName.contains("SELL")) {
            for (class_2561 line : ((class_9290)stack.method_58694(class_9334.field_49632)).comp_2400()) {
                if (!line.getString().contains("Price per unit")) continue;
                return itemName + line.getString();
            }
        }
        if (stackJson == null) {
            return itemName + ";" + stack.method_7947();
        }
        JsonElement uuid = stackJson.get("uuid");
        if (uuid != null) {
            return uuid.getAsString();
        }
        return itemName + ";" + stack.method_7947();
    }

    public void loadDescriptionsForInv(class_465 screen) {
        String menuSlot = class_310.method_1551().field_1724.method_31548().method_5438(8).method_57353().toString();
        if (!(menuSlot.contains("minecraft:custom_data=>{id:\"SKYBLOCK_MENU\"}") || menuSlot.contains("Scaffolding") || menuSlot.contains("Quiver") || menuSlot.contains("Your Score Summary"))) {
            return;
        }
        Thread.startVirtualThread(() -> {
            class_2371 itemStacks = screen.method_17577().method_7602();
            String title = screen.method_25440().getString();
            try {
                Thread.sleep(100L);
                for (int i = 0; i < 20 && itemStacks.size() > 46 && ((class_1799)itemStacks.get(itemStacks.size() - 46)).method_7960(); ++i) {
                    Thread.sleep(50L);
                    System.out.println("Waiting for itemStacks to load, current size: " + CoflModClient.getIdFromStack((class_1799)itemStacks.get(itemStacks.size() - 46)));
                    itemStacks = screen.method_17577().method_7602();
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            try {
                class_465 currentScreen;
                class_465 class_4652 = currentScreen = class_310.method_1551().field_1755 instanceof class_465 ? (class_465)class_310.method_1551().field_1755 : null;
                if (currentScreen == null || currentScreen.method_17577() != screen.method_17577()) {
                    System.out.println("Inventory changed already, not refreshing descriptions");
                    return;
                }
                String[] visibleItems = CoflModClient.getItemIdsFromInventory((class_2371<class_1799>)itemStacks);
                CoflModClient.loadDescriptionsForItems(title, (class_2371<class_1799>)itemStacks);
                boolean refresh = false;
                if (title.contains("Auctions")) {
                    block5: for (class_1799 itemStack : itemStacks) {
                        if (itemStack.method_58694(class_9334.field_49632) == null) continue;
                        for (class_2561 line : ((class_9290)itemStack.method_58694(class_9334.field_49632)).comp_2400()) {
                            if (!line.getString().contains("Refreshing...")) continue;
                            refresh = true;
                            continue block5;
                        }
                    }
                    if (refresh) {
                        Thread.sleep(500L);
                    }
                }
                Thread.sleep(1000L);
                String[] itemIds = CoflModClient.getItemIdsFromInventory((class_2371<class_1799>)screen.method_17577().method_7602());
                List<String> visibleList = Arrays.asList(visibleItems);
                for (String itemId : itemIds) {
                    if (visibleList.contains(itemId) || itemId.startsWith("EMPTY_SLOT_")) continue;
                    refresh = true;
                    break;
                }
                if (refresh) {
                    class_465 class_4653 = currentScreen = class_310.method_1551().field_1755 instanceof class_465 ? (class_465)class_310.method_1551().field_1755 : null;
                    if (currentScreen == null || currentScreen.method_17577() != screen.method_17577()) {
                        System.out.println("Inventory changed, not refreshing descriptions");
                        return;
                    }
                    if (!title.equals(screen.method_25440().getString())) {
                        System.out.println("Title changed, not refreshing descriptions");
                        return;
                    }
                    System.out.println("Refreshing descriptions for inventory: " + title);
                    CoflModClient.loadDescriptionsForItems(title, (class_2371<class_1799>)itemStacks);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                System.out.println("Failed to load descriptions for inventory: " + String.valueOf(e) + " " + CoflModClient.inventoryToNBT((class_2371<class_1799>)itemStacks));
            }
        });
    }

    public static void loadDescriptionsForItems(String title, class_2371<class_1799> items) {
        String userName = class_310.method_1551().method_1548().method_1676();
        String nbtString = CoflModClient.inventoryToNBT(items);
        if (nbtString.equals(lastNbtRequest)) {
            return;
        }
        lastNbtRequest = nbtString;
        String[] visibleItems = CoflModClient.getItemIdsFromInventory(items);
        DescriptionHandler.loadDescriptionForInventory((String[])visibleItems, (String)title, (String)nbtString, (String)userName, (Position)posToUpload);
    }

    private static List<String> getScoreboard() {
        ObjectArrayList scoreboardAsText = new ObjectArrayList();
        if (class_310.method_1551() == null || class_310.method_1551().field_1687 == null) {
            System.out.println("MinecraftClient or world is null, cannot get scoreboard.");
            return scoreboardAsText;
        }
        class_746 player = class_310.method_1551().field_1724;
        if (player == null) {
            System.out.println("Player is null, cannot get scoreboard.");
            return scoreboardAsText;
        }
        class_269 scoreboard = player.method_7327();
        class_266 objective = scoreboard.method_1189((class_8646)class_8646.field_45176.apply(1));
        for (class_9015 scoreHolder : scoreboard.method_1178()) {
            String strLine;
            class_268 team;
            if (!scoreboard.method_1166(scoreHolder).containsKey((Object)objective) || (team = scoreboard.method_1164(scoreHolder.method_5820())) == null || (strLine = team.method_1144().getString() + team.method_1136().getString()).trim().isEmpty()) continue;
            String formatted = class_124.method_539((String)strLine);
            scoreboardAsText.add((Object)formatted);
        }
        if (objective != null) {
            scoreboardAsText.add((Object)objective.method_1114().getString());
            Collections.reverse(scoreboardAsText);
        }
        return scoreboardAsText;
    }

    private static List<String> getTabList() {
        ArrayList<String> tabList = new ArrayList<String>();
        if (class_310.method_1551() == null || class_310.method_1551().field_1687 == null) {
            System.out.println("MinecraftClient or world is null, cannot get tab list.");
            return tabList;
        }
        class_310 client = class_310.method_1551();
        class_634 networkHandler = client.method_1562();
        if (networkHandler != null) {
            ArrayList playerList = new ArrayList(networkHandler.method_2880());
            for (class_640 playerListEntry : playerList) {
                if (playerListEntry == null) continue;
                if (playerListEntry.method_2971() != null) {
                    String displayName = playerListEntry.method_2971().getString();
                    tabList.add(displayName);
                    continue;
                }
                String playerName = playerListEntry.method_2966().getName();
                tabList.add(playerName);
            }
        }
        return tabList;
    }

    public static boolean isBINAuction(class_476 gcs) {
        return BinGUI.isAuctionInit(gcs) || BinGUI.isAuctionConfirming(gcs);
    }

    public static boolean isOwnAuction(class_476 gcs) {
        class_1799 stack = ((class_1707)gcs.method_17577()).method_7629().method_5438(31);
        return BinGUI.isAuctionInit(gcs) && (stack.method_7909() == class_1802.field_8871 || stack.method_7909() == class_1802.field_8494);
    }

    public static boolean isBazaar(class_476 gcs) {
        String title = gcs.method_25440().getString();
        return title.contains("Bazaar") && ((class_1707)gcs.method_17577()).method_7629().method_5439() == 54;
    }

    public static void searchInBazaar(String searchTerm) {
        class_310 client = class_310.method_1551();
        class_437 class_4372 = client.field_1755;
        if (!(class_4372 instanceof class_476)) {
            System.out.println("Current screen is not a container screen");
            return;
        }
        class_476 gcs = (class_476)class_4372;
        if (!CoflModClient.isBazaar(gcs)) {
            System.out.println("Current screen is not the bazaar");
            return;
        }
        int searchSlot = CoflModClient.findSearchSlotInBazaar(gcs);
        if (searchSlot == -1) {
            System.out.println("Could not find Search item in bazaar");
            return;
        }
        System.out.println("Found Search item at slot: " + searchSlot + ", searching for: " + searchTerm);
        pendingBazaarSearch = searchTerm;
        CoflModClient.clickSlotInContainer(gcs, searchSlot);
    }

    public static void searchInBazaarSmart(String rawItemName) {
        String cleanedName = CoflModClient.cleanItemNameForSearch(rawItemName);
        CoflModClient.searchInBazaar(cleanedName);
    }

    private static String cleanItemNameForSearch(String rawName) {
        if (rawName == null) {
            return "";
        }
        String cleaned = rawName.replaceAll("\u00a7.", "");
        cleaned = cleaned.replaceAll("\\[.*?\\]", "");
        cleaned = cleaned.replaceAll("\\(.*?\\)", "");
        cleaned = cleaned.trim();
        return cleaned;
    }

    private static int findSearchSlotInBazaar(class_476 gcs) {
        String loreText;
        Object customName;
        class_1799 stack;
        int i;
        for (i = 0; i < ((class_1707)gcs.method_17577()).method_7629().method_5439(); ++i) {
            stack = ((class_1707)gcs.method_17577()).method_7629().method_5438(i);
            if (stack.method_7960() || stack.method_7909() != class_1802.field_8448 && stack.method_7909() != class_1802.field_8407 && stack.method_7909() != class_1802.field_8674 && stack.method_7909() != class_1802.field_8251) continue;
            if (stack.method_65130() != null && ((String)(customName = stack.method_65130().getString().toLowerCase())).contains("search")) {
                return i;
            }
            if (stack.method_58694(class_9334.field_49632) == null) continue;
            customName = ((class_9290)stack.method_58694(class_9334.field_49632)).comp_2400().iterator();
            while (customName.hasNext()) {
                class_2561 line = (class_2561)customName.next();
                loreText = line.getString().toLowerCase();
                if (!loreText.contains("search") && !loreText.contains("find") && !loreText.contains("look for")) continue;
                return i;
            }
        }
        for (i = 0; i < ((class_1707)gcs.method_17577()).method_7629().method_5439(); ++i) {
            stack = ((class_1707)gcs.method_17577()).method_7629().method_5438(i);
            if (stack.method_7960()) continue;
            if (stack.method_65130() != null && ((String)(customName = stack.method_65130().getString().toLowerCase())).contains("search")) {
                return i;
            }
            if (stack.method_58694(class_9334.field_49632) == null) continue;
            for (class_2561 line : ((class_9290)stack.method_58694(class_9334.field_49632)).comp_2400()) {
                loreText = line.getString().toLowerCase();
                if (!loreText.contains("search") || !loreText.contains("click") && !loreText.contains("use")) continue;
                return i;
            }
        }
        return -1;
    }

    private static void clickSlotInContainer(class_476 gcs, int slotId) {
        class_310 client = class_310.method_1551();
        class_746 player = client.field_1724;
        client.field_1761.method_2906(((class_1707)gcs.method_17577()).field_7763, slotId, 0, class_1713.field_7790, (class_1657)player);
    }

    private boolean checkVersionCompability() {
        try {
            String v = class_3797.field_25319.comp_4025();
            System.out.println("Detected Minecraft version:" + v);
            boolean b = v.compareTo(targetVersion) == 0;
            return b;
        }
        catch (NoSuchMethodError e) {
            return false;
        }
    }

    private static class_3545<String, String> getRelevantLinesFromScoreboard(String[] scores) {
        class_3545 ids = new class_3545((Object)"", (Object)"null");
        for (String score : scores) {
            if (score.startsWith("Purse: ") || score.startsWith("Piggy: ")) {
                ids.method_34964((Object)score);
            }
            if (!score.startsWith(" \u23e3 ")) continue;
            ids.method_34965((Object)score);
        }
        return ids;
    }

    public static String findPriceSuggestion() {
        for (DescriptionHandler.DescModification descMod : CoflModClient.getExtraSlotDescMod()) {
            System.out.println(descMod.type + "|" + descMod.value);
            if (descMod.type.compareTo("SUGGEST") != 0) continue;
            return descMod.value;
        }
        return "";
    }

    public static DescriptionHandler.DescModification[] getExtraSlotDescMod() {
        return DescriptionHandler.getInfoDisplay();
    }

    public static void setHotKeys(HotkeyRegister[] keys) {
        additionalKeyBindings.clear();
        keybindingsToHotkeys.clear();
        for (int i = 0; i < keys.length; ++i) {
            int keyIndex = CoflModClient.getKeyIndex(keys[i].DefaultKey.toUpperCase());
            HotkeyRegister hotkey = keys[i];
            class_304 keyBinding = new class_304(hotkey.Name, keyIndex, "SkyCofl (unchangeable)");
            additionalKeyBindings.add(keyBinding);
            keybindingsToHotkeys.put(keyBinding, hotkey);
            System.out.println("Registered Key: " + hotkey.Name + " with key " + hotkey.DefaultKey.toUpperCase() + " (" + keyIndex + ")");
        }
    }

    public static int getKeyIndex(String name) {
        int result = -1;
        String prefix = "GLFW_KEY_";
        for (Field f : GLFW.class.getDeclaredFields()) {
            if (!f.getName().startsWith(prefix) || !f.getName().substring(prefix.length()).equals(name)) continue;
            try {
                result = (Integer)f.get(Integer.TYPE);
            }
            catch (IllegalAccessException e) {
                System.out.println("Key inaccessible. This shouldn't happen");
            }
            break;
        }
        return result;
    }

    private static void addSellProtectionTooltip(class_1799 stack, List<class_2561> lines) {
        try {
            if (!SellProtectionManager.isEnabled()) {
                return;
            }
            class_310 client = class_310.method_1551();
            class_437 class_4372 = client.field_1755;
            if (class_4372 instanceof class_465) {
                class_465 screen = (class_465)class_4372;
                String screenTitle = screen.method_25440().getString();
                if (!screenTitle.contains("\u279c")) {
                    return;
                }
            } else {
                return;
            }
            String itemName = "";
            itemName = stack.method_65130() != null ? stack.method_65130().getString() : stack.method_7909().method_7854().method_7964().getString();
            long threshold = SellProtectionManager.getMaxAmount();
            String formattedThreshold = CoflModClient.formatCoins(threshold);
            long sellAmount = 0L;
            boolean shouldShowWarning = false;
            if (itemName.contains("Sell Instantly")) {
                sellAmount = SellAmountParser.extractSellInstantlyAmountFromTooltip(lines);
                boolean bl = shouldShowWarning = sellAmount > threshold && sellAmount != SellAmountParser.getDefaultProtectionAmount();
                if (shouldShowWarning) {
                    lines.add((class_2561)class_2561.method_43470((String)""));
                    lines.add((class_2561)class_2561.method_43470((String)"\u00a7c\u26a0 \u00a7lSell Protection \u00a7c\u26a0"));
                    lines.add((class_2561)class_2561.method_43470((String)("\u00a77Left clicks blocked if > \u00a76" + formattedThreshold + " coins")));
                    lines.add((class_2561)class_2561.method_43470((String)"\u00a7bHold Ctrl\u00a77 to override."));
                    lines.add((class_2561)class_2561.method_43470((String)"\u00a78/cofl set sellProtectionThreshold <amount>"));
                }
            } else if (itemName.contains("Sell Sacks Now") || itemName.contains("Sell Inventory Now")) {
                sellAmount = SellAmountParser.extractInventorySackAmountFromTooltip(lines);
                boolean bl = shouldShowWarning = sellAmount > threshold && sellAmount != SellAmountParser.getDefaultProtectionAmount();
                if (shouldShowWarning) {
                    lines.add((class_2561)class_2561.method_43470((String)""));
                    lines.add((class_2561)class_2561.method_43470((String)"\u00a7c\u26a0 \u00a7lSell Protection \u00a7c\u26a0"));
                    lines.add((class_2561)class_2561.method_43470((String)("\u00a77All clicks blocked if > \u00a76" + formattedThreshold + " coins")));
                    lines.add((class_2561)class_2561.method_43470((String)"\u00a7bHold Ctrl\u00a77 to override."));
                    lines.add((class_2561)class_2561.method_43470((String)"\u00a78/cofl set sellProtectionThreshold <amount>"));
                }
            }
        }
        catch (Exception e) {
            System.out.println("[CoflModClient] addSellProtectionTooltip failed: " + e.getMessage());
        }
    }

    private static long parseAmountString(String amountStr) throws NumberFormatException {
        if (amountStr == null || amountStr.trim().isEmpty()) {
            throw new NumberFormatException("Empty amount string");
        }
        String input = amountStr.trim().toLowerCase();
        if (input.matches("^[0-9]+$")) {
            return Long.parseLong(input);
        }
        if (input.matches("^[0-9]+\\.[0-9]+$")) {
            return (long)Double.parseDouble(input);
        }
        if (input.matches("^[0-9]+\\.?[0-9]*[kmb]$")) {
            double value;
            char suffix = input.charAt(input.length() - 1);
            String numberPart = input.substring(0, input.length() - 1);
            try {
                value = Double.parseDouble(numberPart);
            }
            catch (NumberFormatException e) {
                throw new NumberFormatException("Invalid number part: " + numberPart);
            }
            switch (suffix) {
                case 'k': {
                    return (long)(value * 1000.0);
                }
                case 'm': {
                    return (long)(value * 1000000.0);
                }
                case 'b': {
                    return (long)(value * 1.0E9);
                }
            }
            throw new NumberFormatException("Invalid suffix: " + suffix);
        }
        throw new NumberFormatException("Invalid format: " + amountStr + ". Use formats like: 1000, 2k, 3m, 1.5b");
    }

    private static String formatCoins(long coins) {
        if (coins >= 1000000000L) {
            return String.format(Locale.US, "%.1fB", (double)coins / 1.0E9);
        }
        if (coins >= 1000000L) {
            return String.format(Locale.US, "%.1fM", (double)coins / 1000000.0);
        }
        if (coins >= 1000L) {
            return String.format(Locale.US, "%.1fK", (double)coins / 1000.0);
        }
        return String.valueOf(coins);
    }

    private static void sendChatMessage(String message) {
        class_310 client = class_310.method_1551();
        if (client.field_1724 != null) {
            client.field_1724.method_7353((class_2561)class_2561.method_43470((String)message), false);
        }
    }

    static {
        additionalKeyBindings = new ArrayList<class_304>();
        keybindingsToHotkeys = new HashMap<class_304, HotkeyRegister>();
        knownIds = new ArrayList();
        lastScoreboardUploaded = new class_3545((Object)"", (Object)"0");
        lastNbtRequest = "";
        popupShown = false;
        posToUpload = null;
        sign = null;
        pendingBazaarSearch = null;
    }

    @Environment(value=EnvType.CLIENT)
    public class TooltipMessage
    implements Message {
        private final String text;

        public TooltipMessage(CoflModClient this$0, String text) {
            this.text = text != null ? text : "";
        }

        public String getString() {
            return this.text;
        }
    }
}

