/*
 * Decompiled with CFR 0.152.
 */
package com.coflnet.gui;

import com.mojang.blaze3d.pipeline.RenderPipeline;
import com.mojang.blaze3d.platform.DepthTestFunction;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.awt.Color;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_10799;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4668;
import net.minecraft.class_9974;
import org.jetbrains.annotations.NotNull;
import org.lwjgl.opengl.GL11;
import org.spongepowered.asm.mixin.injection.invoke.arg.ArgumentCountException;

@Environment(value=EnvType.CLIENT)
public class RenderUtils {
    private static class_289 tessellator = null;
    private static class_287 buffer = null;
    public static class_327 textRenderer = null;
    public static int z = 0;
    private static final class_1921.class_4687 THROUGH_WALLS_LAYER = class_1921.method_24049((String)"filled_through_walls", (int)1536, (boolean)false, (boolean)true, (RenderPipeline)class_10799.method_67887((RenderPipeline)RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{class_10799.field_56860}).withLocation(class_2960.method_60655((String)"coflmod", (String)"pipeline/debug_filled_box_through_walls")).withVertexFormat(class_290.field_1576, VertexFormat.class_5596.field_27380).withDepthTestFunction(DepthTestFunction.NO_DEPTH_TEST).build()), (class_1921.class_4688)class_1921.class_4688.method_23598().method_23607(class_4668.field_53123).method_23617(false));

    public static void init() {
        z = 0;
        tessellator = class_289.method_1348();
        textRenderer = class_310.method_1551().field_1772;
    }

    public static void drawRect(class_332 context, float x, float y, float width, float height, int color) {
        context.method_25294((int)x, (int)y, (int)(x + width), (int)(y + height), color);
    }

    public static void drawRectOutline(class_332 context, int x, int y, int width, int height, float lineWidth, int fillCol, int lineCol) {
        RenderUtils.drawRect(context, x, y, width, height, lineCol);
        RenderUtils.drawRect(context, (float)x + lineWidth, (float)y + lineWidth, (float)width - lineWidth * 2.0f, (float)height - lineWidth * 2.0f, fillCol);
    }

    public static void drawCircle(class_332 context, int x, int y, int radius, int color) {
        for (int i = 0; i <= 360; ++i) {
            context.method_25294((int)((double)x + Math.sin((double)i * Math.PI / 180.0) * (double)radius), (int)((double)y + Math.cos((double)i * Math.PI / 180.0) * (double)radius), x, y, color);
        }
    }

    public static void drawCircleOutline(class_332 context, int x, int y, int radius, int thickness, int fillCol, int lineCol) {
        RenderUtils.drawCircle(context, x, y, radius, lineCol);
        RenderUtils.drawCircle(context, x, y, radius + thickness * 2, fillCol);
    }

    public static void drawLine(float x1, float y1, float x2, float y2, float thickness, Color color) {
        GL11.glEnable((int)3042);
        GL11.glDisable((int)3553);
        GL11.glBlendFunc((int)770, (int)771);
        RenderUtils.setColor(color);
        GL11.glLineWidth((float)thickness);
        GL11.glBegin((int)1);
        GL11.glVertex2d((double)x1, (double)y1);
        GL11.glVertex2d((double)x2, (double)y2);
        GL11.glEnd();
        GL11.glEnable((int)3553);
        GL11.glDisable((int)3042);
    }

    public static void drawTriangle(int x, int y, int x2, int y2, int x3, int y3, Color color) {
        GL11.glEnable((int)3042);
        GL11.glDisable((int)3553);
        GL11.glBlendFunc((int)770, (int)771);
        RenderUtils.setColor(color);
        GL11.glBegin((int)4);
        GL11.glVertex2d((double)x, (double)y);
        GL11.glVertex2d((double)x2, (double)y2);
        GL11.glVertex2d((double)x3, (double)y3);
        GL11.glEnd();
        GL11.glEnable((int)3553);
        GL11.glDisable((int)3042);
    }

    public static void drawTriangleOutline(int x, int y, int x2, int y2, int x3, int y3, Color color) {
        GL11.glEnable((int)3042);
        GL11.glDisable((int)3553);
        GL11.glBlendFunc((int)770, (int)771);
        RenderUtils.setColor(color);
        GL11.glBegin((int)2);
        GL11.glVertex2d((double)x, (double)y);
        GL11.glVertex2d((double)x2, (double)y2);
        GL11.glVertex2d((double)x3, (double)y3);
        GL11.glEnd();
        GL11.glEnable((int)3553);
        GL11.glDisable((int)3042);
    }

    public static void drawArc(class_332 context, int x, int y, int radius, int startAngle, int endAngle, int color) {
    }

    public static void drawLoadingCircle(class_332 context, float x, float y, float radius, float thickness, float speed, int color) {
    }

    public static void drawRoundedRect(class_332 context, int x, int y, int width, int height, int radius, @NotNull int color) {
        RenderUtils.drawRect(context, x + radius, y, width - radius * 2, height, color);
        RenderUtils.drawRect(context, x, y + radius, radius, height - radius * 2, color);
        RenderUtils.drawRect(context, x + width - radius, y + radius, radius, height - radius * 2, color);
        RenderUtils.drawCircle(context, x + radius, y + radius, radius, color);
        RenderUtils.drawCircle(context, x + width - radius + 1, y + radius, radius, color);
        RenderUtils.drawCircle(context, x + radius, y + height - radius + 1, radius, color);
        RenderUtils.drawCircle(context, x + width - radius + 1, y + height - radius + 1, radius, color);
    }

    public static void drawGradientRect(int x, int y, int width, int height, Color color1, Color color2) {
        GL11.glEnable((int)3042);
        GL11.glDisable((int)3553);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glShadeModel((int)7425);
        GL11.glBegin((int)7);
        RenderUtils.setColor(color1);
        GL11.glVertex2d((double)x, (double)y);
        GL11.glVertex2d((double)(x + width), (double)y);
        RenderUtils.setColor(color2);
        GL11.glVertex2d((double)(x + width), (double)(y + height));
        GL11.glVertex2d((double)x, (double)(y + height));
        GL11.glEnd();
        GL11.glShadeModel((int)7424);
        GL11.glEnable((int)3553);
        GL11.glDisable((int)3042);
    }

    public static void drawString(class_332 context, String text, int x, int y, int color) {
        context.method_51433(textRenderer, text, x, y, color, false);
    }

    public static void drawStringWithShadow(class_332 context, String text, int x, int y, int color) {
        context.method_51433(textRenderer, text, x, y, color, true);
    }

    public static void drawCenteredString(class_332 context, String text, int x, int y, int color) {
        context.method_51433(textRenderer, text, x - textRenderer.method_1727(text) / 2, y, color, false);
    }

    public static void drawCenteredStringWithShadow(class_332 context, String text, int x, int y, int color) {
        context.method_51433(textRenderer, text, x - textRenderer.method_1727(text) / 2, y, color, true);
    }

    private static void drawString(class_332 context, String text, int x, int y, int color, int scale, boolean centered, boolean shadow) {
        class_4587 ms = new class_4587();
        ms.method_22903();
        ms.method_22905((float)scale, (float)scale, 0.0f);
        context.method_51433(textRenderer, text, centered ? x - textRenderer.method_1727(text) / 2 : x, y, color, shadow);
        ms.method_22909();
    }

    public static void drawString(class_332 context, String text, int x, int y, int color, int scale) {
        RenderUtils.drawString(context, text, x, y, color, scale, false, false);
    }

    public static void drawStringWithShadow(class_332 context, String text, int x, int y, int color, int scale) {
        RenderUtils.drawString(context, text, x, y, color, scale, false, true);
    }

    public static void drawCenteredString(class_332 context, String text, int x, int y, int color, int scale) {
        RenderUtils.drawString(context, text, x, y, color, scale, true, false);
    }

    public static void drawCenteredStringWithShadow(class_332 context, String text, int x, int y, int color, int scale) {
        RenderUtils.drawString(context, text, x, y, color, scale, true, true);
    }

    public static void drawItemStack(class_332 context, class_1799 itemStack, int x, int y, float scale) {
        context.method_51428(itemStack, x, y, 0);
    }

    public static Color setAlpha(Color color, int alpha) {
        return new Color(color.getRed(), color.getGreen(), color.getBlue(), alpha);
    }

    public static void setColor(int color) {
        float alpha = (float)(color >> 24 & 0xFF) / 255.0f;
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float green = (float)(color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        GL11.glColor4f((float)red, (float)green, (float)blue, (float)alpha);
    }

    public static void setColor(Color color) {
        RenderUtils.setColor(color.getRGB());
    }

    public static void rotate(float angle) {
        GL11.glRotatef((float)angle, (float)0.0f, (float)0.0f, (float)1.0f);
    }

    public static String lorem() {
        return "Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. +Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Duis autem vel eum iriure dolor in hendrerit in vulputate velit esse molestie consequat, vel illum dolore eu feugiat nulla facilisis at vero eros et accumsan et iusto odio dignissim qui blandit praesent luptatum zzril delenit augue duis dolore te feugait nulla facilisi. Lorem ipsum dolor sit amet,";
    }

    public static void renderHighlightBox(class_4587 matrices, class_4184 camera, double[] minXYZ, double[] maxXYZ, float[] rgba) {
        if (minXYZ.length != 3) {
            throw new ArgumentCountException(minXYZ.length, 3, "Expected 3 values (x/y/z coordinates) in array");
        }
        if (maxXYZ.length != 3) {
            throw new ArgumentCountException(maxXYZ.length, 3, "Expected 3 values (x/y/z coordinates) in array");
        }
        if (rgba.length != 4) {
            throw new ArgumentCountException(maxXYZ.length, 3, "Expected 4 values (r/g/b/a) in array");
        }
        matrices.method_22903();
        matrices.method_22904(-camera.method_19326().field_1352, -camera.method_19326().field_1351, -camera.method_19326().field_1350);
        class_4597.class_4598 consumers = class_310.method_1551().method_22940().method_23000();
        class_4588 buffer = consumers.method_73477((class_1921)THROUGH_WALLS_LAYER);
        class_9974.method_62300((class_4587)matrices, (class_4588)buffer, (double)minXYZ[0], (double)minXYZ[1], (double)minXYZ[2], (double)maxXYZ[0], (double)maxXYZ[1], (double)maxXYZ[2], (float)rgba[0], (float)rgba[1], (float)rgba[2], (float)rgba[3]);
        consumers.method_22994((class_1921)THROUGH_WALLS_LAYER);
        matrices.method_22909();
    }
}

