/*
 * Decompiled with CFR 0.152.
 */
package com.coflnet.config;

import com.coflnet.config.CoflModConfig;
import com.google.gson.Gson;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_310;

@Environment(value=EnvType.CLIENT)
public class TextWidgetPositionConfig {
    private static final Gson gson = new Gson();
    private static final File POSITION_CONFIG_FILE = new File(class_310.method_1551().field_1697, "config/CoflSky/coflsky_text_position.json");
    public int offsetX = -5;
    public int offsetY = 5;

    public static TextWidgetPositionConfig load() {
        CoflModConfig combinedConfig = CoflModConfig.load();
        TextWidgetPositionConfig config = new TextWidgetPositionConfig();
        config.offsetX = combinedConfig.textWidgetOffsetX;
        config.offsetY = combinedConfig.textWidgetOffsetY;
        try {
            if (POSITION_CONFIG_FILE.exists()) {
                FileReader reader = new FileReader(POSITION_CONFIG_FILE);
                TextWidgetPositionConfig oldConfig = (TextWidgetPositionConfig)gson.fromJson((Reader)reader, TextWidgetPositionConfig.class);
                reader.close();
                if (oldConfig != null) {
                    combinedConfig.textWidgetOffsetX = oldConfig.offsetX;
                    combinedConfig.textWidgetOffsetY = oldConfig.offsetY;
                    combinedConfig.save();
                    POSITION_CONFIG_FILE.delete();
                    config.offsetX = oldConfig.offsetX;
                    config.offsetY = oldConfig.offsetY;
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return config;
    }

    public void save() {
        CoflModConfig combinedConfig = CoflModConfig.load();
        combinedConfig.textWidgetOffsetX = this.offsetX;
        combinedConfig.textWidgetOffsetY = this.offsetY;
        combinedConfig.save();
    }
}

