/*
 * Decompiled with CFR 0.152.
 */
package CoflCore;

import CoflCore.FlipHandler;
import CoflCore.configuration.Config;
import CoflCore.configuration.LocalConfig;
import CoflCore.misc.SessionManager;
import CoflCore.network.WSClientWrapper;
import CoflCore.proxy.APIKeyManager;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import org.greenrobot.eventbus.EventBus;

public class CoflCore {
    public static final String MODID = "CoflSky";
    public static final String VERSION = "1.7.7";
    public static FlipHandler flipHandler = new FlipHandler();
    public static File configFile;
    private File coflDir;
    public static LocalConfig config;
    private static final long MAX_CONFIG_FILE_SIZE_BYTES = 0x500000L;
    private static final DateTimeFormatter BACKUP_FILE_SUFFIX_FORMATTER;
    public static final String[] webSocketURIPrefix;
    public static WSClientWrapper Wrapper;
    public static String CommandUri;
    private static final APIKeyManager apiKeyManager;

    public void registerEventFile(Object target) {
        EventBus.getDefault().register(target);
    }

    public void init(Path configPath) {
        Gson gson = new GsonBuilder().disableHtmlEscaping().create();
        this.coflDir = new File(configPath.toFile(), MODID);
        this.coflDir.mkdirs();
        SessionManager.setMainPath(Paths.get(this.coflDir.toString() + "/sessions", new String[0]));
        configFile = new File(this.coflDir, "config.json");
        if (configFile.isFile()) {
            config = this.loadConfig(gson);
        }
        if (config == null) {
            config = LocalConfig.createDefaultConfig();
        }
        try {
            apiKeyManager.loadIfExists(configPath);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            LocalConfig.saveConfig(configFile, config);
            try {
                apiKeyManager.saveKey(configPath);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }));
    }

    public static APIKeyManager getAPIKeyManager() {
        return apiKeyManager;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private LocalConfig loadConfig(Gson gson) {
        try {
            long fileSize = Files.size(configFile.toPath());
            if (fileSize > 0x500000L) {
                return this.handleInvalidConfig("Config file is larger than 5242880 bytes (" + fileSize + ")", null);
            }
            try (BufferedReader reader = Files.newBufferedReader(configFile.toPath(), StandardCharsets.UTF_8);){
                LocalConfig loadedConfig = gson.fromJson((Reader)reader, LocalConfig.class);
                if (loadedConfig != null) {
                    loadedConfig.initCommands();
                    loadedConfig.initSettings();
                    LocalConfig localConfig2 = loadedConfig;
                    return localConfig2;
                }
                LocalConfig localConfig = this.handleInvalidConfig("Config file could not be parsed (null result)", null);
                return localConfig;
            }
        }
        catch (OutOfMemoryError outOfMemoryError) {
            return this.handleInvalidConfig("Out of memory while loading config", outOfMemoryError);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return this.handleInvalidConfig("Exception while loading config: " + exception.getMessage(), exception);
        }
    }

    private LocalConfig handleInvalidConfig(String reason, Throwable cause) {
        System.err.println("[CoflCore] " + reason + " - resetting config to defaults.");
        if (cause != null) {
            cause.printStackTrace();
        }
        if (configFile != null && configFile.isFile()) {
            Path backupPath = configFile.toPath().resolveSibling("config.json." + BACKUP_FILE_SUFFIX_FORMATTER.format(LocalDateTime.now()) + ".bak");
            try {
                Files.move(configFile.toPath(), backupPath, StandardCopyOption.REPLACE_EXISTING);
                System.err.println("[CoflCore] Previous config backed up to " + backupPath.toAbsolutePath());
            }
            catch (IOException ioException) {
                System.err.println("[CoflCore] Failed to back up invalid config: " + ioException.getMessage());
            }
        }
        LocalConfig defaultConfig = LocalConfig.createDefaultConfig();
        LocalConfig.saveConfig(configFile, defaultConfig);
        return defaultConfig;
    }

    static {
        BACKUP_FILE_SUFFIX_FORMATTER = DateTimeFormatter.ofPattern("yyyyMMddHHmmss");
        webSocketURIPrefix = new String[]{"wss://sky.coflnet.com/modsocket", "ws://sky-mod.coflnet.com/modsocket"};
        Wrapper = new WSClientWrapper(webSocketURIPrefix);
        CommandUri = Config.BaseUrl + "/api/mod/commands";
        apiKeyManager = new APIKeyManager();
    }
}

