/*
 * Decompiled with CFR 0.152.
 */
package CoflCore.commands;

import com.google.gson.annotations.SerializedName;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;

public enum CommandType {
    WriteToChat,
    set,
    Ping,
    Execute,
    TokenLogin,
    Clicked,
    PlaySound,
    ChatMessage,
    PurchaseStart,
    PurchaseConfirm,
    Reset,
    Flip,
    PrivacySettings,
    Countdown,
    updatePurse,
    updateBits,
    updateServer,
    updateLocation,
    chatBatch,
    uploadTab,
    uploadScoreboard,
    GetMods,
    ProxyRequest,
    RegisterKeybind,
    OpenUrl,
    GetScoreboard,
    HighlightBlocks,
    CommandUpdate,
    Settings;

    public static Map<CommandType, String> data;

    public String ToJson() {
        return data.get((Object)this);
    }

    static {
        data = new HashMap<CommandType, String>();
        for (CommandType ct : CommandType.values()) {
            try {
                Field f = CommandType.class.getField(ct.name());
                if (!f.isAnnotationPresent(SerializedName.class)) {
                    throw new RuntimeException("Commandtype must have SerializeName Annotation!");
                }
                SerializedName sn = f.getAnnotation(SerializedName.class);
                data.put(ct, sn.value());
            }
            catch (NoSuchFieldException | SecurityException e) {
                System.err.println("This should never occur!");
                e.printStackTrace();
            }
        }
    }
}

