/*
 * Decompiled with CFR 0.152.
 */
package CoflCore.misc;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.lang.reflect.Type;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Duration;
import java.time.ZonedDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;

public class SessionManager {
    public static Path mainPath;
    public static Gson gson;

    public static void setMainPath(Path p) {
        mainPath = p;
    }

    public static void UpdateCoflSessions() throws IOException {
        Map<String, CoflSession> sessions = SessionManager.GetCoflSessions();
        for (String username : sessions.keySet()) {
            if (SessionManager.isValidSession(sessions.get(username))) continue;
            SessionManager.DeleteCoflSession(username);
        }
    }

    public static Path GetTempFileFolder() {
        Path dataPath = mainPath;
        dataPath.toFile().mkdirs();
        return dataPath;
    }

    public static Map<String, CoflSession> GetCoflSessions() throws IOException {
        File[] sessions = SessionManager.GetTempFileFolder().toFile().listFiles();
        HashMap<String, CoflSession> map = new HashMap<String, CoflSession>();
        for (int i = 0; i < sessions.length; ++i) {
            map.put(sessions[i].getName(), SessionManager.GetCoflSession(sessions[i].getName()));
        }
        return map;
    }

    public static boolean isValidSession(CoflSession session) {
        return session.timestampCreated.plus(Duration.ofDays(180L)).isAfter(ZonedDateTime.now());
    }

    private static Path GetUserPath(String username) {
        return Paths.get(SessionManager.GetTempFileFolder().toString() + "/" + username, new String[0]);
    }

    public static void DeleteCoflSession(String username) {
        Path path = SessionManager.GetUserPath(username);
        path.toFile().delete();
    }

    public static void DeleteAllCoflSessions() {
        File[] sessions;
        Path path = SessionManager.GetTempFileFolder();
        for (File f : sessions = path.toFile().listFiles()) {
            f.delete();
        }
    }

    public static CoflSession GetCoflSession(String username) throws IOException {
        CoflSession session;
        Path path = SessionManager.GetUserPath(username);
        File file = path.toFile();
        if (!file.exists() || file.length() == 0L) {
            CoflSession session2 = new CoflSession(UUID.randomUUID().toString(), ZonedDateTime.now());
            SessionManager.OverwriteCoflSession(username, session2);
            return session2;
        }
        BufferedReader reader = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
        String raw = reader.lines().collect(Collectors.joining("\n"));
        reader.close();
        try {
            session = gson.fromJson(raw, CoflSession.class);
        }
        catch (JsonSyntaxException e) {
            session = new CoflSession(UUID.randomUUID().toString(), ZonedDateTime.now());
            SessionManager.OverwriteCoflSession(username, session);
        }
        return session;
    }

    public static boolean OverwriteCoflSession(String username, CoflSession session) throws IOException {
        Path path = SessionManager.GetUserPath(username);
        File file = path.toFile();
        file.createNewFile();
        String data = gson.toJson(session);
        BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(file)));
        bw.append(data);
        bw.flush();
        bw.close();
        return true;
    }

    static {
        gson = new GsonBuilder().registerTypeAdapter((Type)((Object)ZonedDateTime.class), new TypeAdapter<ZonedDateTime>(){

            @Override
            public void write(JsonWriter out, ZonedDateTime value) throws IOException {
                out.value(value.toString());
            }

            @Override
            public ZonedDateTime read(JsonReader in) throws IOException {
                return ZonedDateTime.parse(in.nextString());
            }
        }).enableComplexMapKeySerialization().create();
    }

    public static class CoflSession {
        public String SessionUUID;
        public ZonedDateTime timestampCreated;

        public CoflSession() {
        }

        public CoflSession(String sessionUUID, ZonedDateTime timestampCreated) {
            this.SessionUUID = sessionUUID;
            this.timestampCreated = timestampCreated;
        }
    }
}

