/*
 * Decompiled with CFR 0.152.
 */
package CoflCore.network;

import CoflCore.CoflCore;
import CoflCore.misc.SessionManager;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Arrays;

public class QueryServerCommands {
    private static Gson gson = new GsonBuilder().create();

    public static String QueryCommands() {
        String queryResult = QueryServerCommands.GetRequest(CoflCore.CommandUri);
        if (queryResult != null) {
            Object[] commands = gson.fromJson(queryResult, CommandInfo[].class);
            System.out.println(">>> " + Arrays.toString(commands));
            StringBuilder sb = new StringBuilder();
            if (commands.length > 0) {
                for (Object cm : commands) {
                    sb.append(cm + "\n");
                }
            }
            return sb.toString().trim();
        }
        return "\u00a74ERROR: Could not connect to command server!";
    }

    private static String GetRequest(String uri) {
        try {
            int length;
            System.out.println("Get request");
            URL url = new URL(uri);
            HttpURLConnection con = (HttpURLConnection)url.openConnection();
            con.setRequestMethod("GET");
            con.setRequestProperty("Accept", "application/json");
            con.setRequestProperty("User-Agent", "CoflMod");
            con.setDoInput(true);
            System.out.println("InputStream");
            BufferedInputStream in = new BufferedInputStream(con.getInputStream());
            ByteArrayOutputStream result = new ByteArrayOutputStream();
            byte[] buffer = new byte[1024];
            while ((length = ((InputStream)in).read(buffer)) != -1) {
                result.write(buffer, 0, length);
            }
            String resString = result.toString("UTF-8");
            System.out.println("Result= " + resString);
            return resString;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String PostRequest(String uri, String data, String username) {
        try {
            int length;
            URL url = new URL(uri);
            HttpURLConnection con = (HttpURLConnection)url.openConnection();
            con.setRequestMethod("POST");
            con.setRequestProperty("Content-Type", "application/json; charset=UTF-8");
            con.setRequestProperty("Accept", "application/json");
            con.setRequestProperty("User-Agent", "CoflMod");
            con.setRequestProperty("conId", SessionManager.GetCoflSession((String)username).SessionUUID);
            con.setRequestProperty("uuid", username);
            con.setDoInput(true);
            con.setDoOutput(true);
            OutputStream os = con.getOutputStream();
            byte[] bytes = data.getBytes("UTF-8");
            os.write(bytes);
            os.close();
            int responseCode = con.getResponseCode();
            if (responseCode < 200 || responseCode >= 400) {
                throw new IOException("HTTP error code: " + responseCode);
            }
            BufferedInputStream in = new BufferedInputStream(con.getInputStream());
            ByteArrayOutputStream result = new ByteArrayOutputStream();
            byte[] buffer = new byte[1024];
            while ((length = ((InputStream)in).read(buffer)) != -1) {
                result.write(buffer, 0, length);
            }
            String resString = result.toString("UTF-8");
            return resString;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static class CommandInfo {
        public String subCommand;
        public String description;

        public CommandInfo() {
        }

        public CommandInfo(String subCommand, String description) {
            this.subCommand = subCommand;
            this.description = description;
        }

        public String toString() {
            return this.subCommand + ": " + this.description;
        }
    }
}

