/*
 * Decompiled with CFR 0.152.
 */
package CoflCore.proxy;

import com.google.gson.Gson;
import com.google.gson.annotations.SerializedName;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.stream.Collectors;

public class APIKeyManager {
    private final Gson gson = new Gson();
    private APIInfo apiInfo = new APIInfo();

    public APIInfo getApiInfo() {
        return this.apiInfo;
    }

    public void loadIfExists(Path configDir) throws Exception {
        Path dataPath = Paths.get(configDir.toFile().getPath(), "CoflSky", "api-key.json");
        File file = dataPath.toFile();
        if (file.exists()) {
            BufferedReader reader = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
            String raw = reader.lines().collect(Collectors.joining("\n"));
            this.apiInfo = this.gson.fromJson(raw, APIInfo.class);
            reader.close();
        }
    }

    public void saveKey(Path configDir) throws Exception {
        Path dataPath = Paths.get(configDir.toFile().getPath(), "CoflSky", "api-key.json");
        File file = dataPath.toFile();
        if (file.exists()) {
            file.delete();
        }
        file.createNewFile();
        String data = this.gson.toJson(this.apiInfo);
        BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(file)));
        bw.append(data);
        bw.flush();
        bw.close();
    }

    public class APIInfo {
        @SerializedName(value="api-key")
        public String key;
    }
}

