/*
 * Decompiled with CFR 0.152.
 */
package CoflCore.proxy;

import CoflCore.CoflCore;
import CoflCore.commands.models.ProxyRequest;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import java.util.zip.GZIPOutputStream;

public class ProxyManager {
    private final ExecutorService requestExecutor = Executors.newSingleThreadExecutor();

    public void handleRequestAsync(ProxyRequest request) {
        String userAgent = request.getUserAgent() != null ? request.getUserAgent() : "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36";
        int waitMs = request.getWaitMs() > 0 ? request.getWaitMs() : 1000;
        CompletableFuture<String> req = this.doRequest(request.getUrl(), userAgent, waitMs);
        if (request.getUploadTo() != null) {
            req.thenAcceptAsync(res -> this.uploadData((String)res, request.getId(), request.getUploadTo(), request.getRegex()));
        }
    }

    public void resetChromeData() {
        File userDataDir = ProxyManager.getChromeDataDir();
        if (userDataDir.exists()) {
            try {
                Path root = userDataDir.toPath();
                if (Files.exists(root, new LinkOption[0])) {
                    Files.walkFileTree(root, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                        @Override
                        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                            Files.deleteIfExists(file);
                            return FileVisitResult.CONTINUE;
                        }

                        @Override
                        public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                            Files.deleteIfExists(dir);
                            return FileVisitResult.CONTINUE;
                        }
                    });
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private String getString(HttpURLConnection con) {
        try {
            int length;
            BufferedInputStream in = new BufferedInputStream(con.getInputStream());
            ByteArrayOutputStream result = new ByteArrayOutputStream();
            byte[] buffer = new byte[1024];
            while ((length = ((InputStream)in).read(buffer)) != -1) {
                result.write(buffer, 0, length);
            }
            String resString = result.toString("UTF-8");
            return resString;
        }
        catch (IOException e) {
            return null;
        }
    }

    public void uploadData(final String data, final String id, final String uploadTo, final String selectRegex) {
        this.requestExecutor.submit(new Runnable(){

            @Override
            public void run() {
                try {
                    String uploadData = data;
                    if (selectRegex != null && !selectRegex.isEmpty()) {
                        try {
                            Pattern pattern = Pattern.compile(selectRegex, 32);
                            Matcher matcher = pattern.matcher(uploadData != null ? uploadData : "");
                            if (matcher.find()) {
                                uploadData = matcher.groupCount() >= 1 ? matcher.group(1) : matcher.group(0);
                            }
                        }
                        catch (PatternSyntaxException e) {
                            System.err.println("Invalid selectRegex: " + e.getMessage());
                        }
                    }
                    URL url = new URL(uploadTo);
                    HttpURLConnection con = (HttpURLConnection)url.openConnection();
                    con.setRequestMethod("POST");
                    con.setRequestProperty("X-Request-Id", id);
                    con.setRequestProperty("Content-Type", "application/json; charset=UTF-8");
                    con.setRequestProperty("Accept", "application/json");
                    con.setRequestProperty("User-Agent", "CoflMod");
                    con.setRequestProperty("Content-Encoding", "gzip");
                    con.setDoOutput(true);
                    con.setDoInput(true);
                    con.setChunkedStreamingMode(0);
                    try (OutputStream os = con.getOutputStream();
                         BufferedOutputStream bos = new BufferedOutputStream(os);
                         GZIPOutputStream gos = new GZIPOutputStream(bos);){
                        if (uploadData != null && !uploadData.isEmpty()) {
                            byte[] contentBytes = uploadData.getBytes(StandardCharsets.UTF_8);
                            gos.write(contentBytes);
                        }
                        gos.finish();
                    }
                    String response = ProxyManager.this.getString(con);
                    int responseCode = con.getResponseCode();
                    System.out.println("Response code=" + responseCode + " Response=" + response);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        });
    }

    private CompletableFuture<String> doRequest(final String targetUrl, final String userAgent, final int waitMs) {
        final CompletableFuture<String> future = new CompletableFuture<String>();
        this.requestExecutor.submit(new Runnable(){

            @Override
            public void run() {
                try {
                    String line;
                    String chromeExecutable = ProxyManager.this.findChromeExecutable();
                    if (chromeExecutable == null) {
                        chromeExecutable = "chromium";
                    }
                    Thread.sleep(waitMs);
                    Process process = this.runChrome(chromeExecutable);
                    BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
                    StringBuilder output = new StringBuilder();
                    while ((line = reader.readLine()) != null) {
                        output.append(line).append(System.lineSeparator());
                    }
                    int exitCode = process.waitFor();
                    if (exitCode == 0) {
                        future.complete(output.toString());
                    } else {
                        BufferedReader errorReader = new BufferedReader(new InputStreamReader(process.getErrorStream()));
                        StringBuilder errorOutput = new StringBuilder();
                        while ((line = errorReader.readLine()) != null) {
                            errorOutput.append(line).append(System.lineSeparator());
                        }
                        future.complete(output.toString());
                        System.err.println("Chromium process exited with code " + exitCode + " output " + output.toString().length() + ": " + errorOutput.toString());
                        future.completeExceptionally(new RuntimeException("Chromium process exited with code " + exitCode + ": " + errorOutput.toString()));
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }

            private Process runChrome(String chromeExecutable) throws IOException {
                File userDataDir = ProxyManager.getChromeDataDir();
                ProcessBuilder pb = new ProcessBuilder(chromeExecutable, "--headless", "--disable-gpu", "--user-data-dir=" + userDataDir.getAbsolutePath(), "--dump-dom", "--user-agent=" + userAgent, targetUrl);
                System.out.println("Running command: " + String.join((CharSequence)" ", pb.command()));
                return pb.start();
            }
        });
        return future;
    }

    private static File getChromeDataDir() {
        File configDir = CoflCore.configFile.getParentFile();
        File userDataDir = new File(configDir, "chrome-profile");
        if (!userDataDir.exists()) {
            userDataDir.mkdirs();
        }
        return userDataDir;
    }

    private String findChromeExecutable() {
        String os = System.getProperty("os.name").toLowerCase();
        try {
            String[] candidates;
            if (os.contains("win")) {
                String[] paths;
                String pf = System.getenv("ProgramFiles");
                String pf86 = System.getenv("ProgramFiles(x86)");
                String local = System.getenv("LocalAppData");
                for (String p : paths = new String[]{pf == null ? null : pf + "\\Google\\Chrome\\Application\\chrome.exe", pf86 == null ? null : pf86 + "\\Google\\Chrome\\Application\\chrome.exe", local == null ? null : local + "\\Google\\Chrome\\Application\\chrome.exe", "chrome.exe"}) {
                    File f;
                    if (p == null || !(f = new File(p)).exists()) continue;
                    return f.getAbsolutePath();
                }
                try {
                    Process pr = new ProcessBuilder("where", "chrome.exe").start();
                    BufferedReader r = new BufferedReader(new InputStreamReader(pr.getInputStream()));
                    String line = r.readLine();
                    if (line != null && !line.isEmpty()) {
                        return line.trim();
                    }
                }
                catch (Exception pr) {
                    // empty catch block
                }
                return null;
            }
            if (os.contains("mac")) {
                String[] candidates2;
                String[] paths;
                for (String p : paths = new String[]{"/Applications/Google Chrome.app/Contents/MacOS/Google Chrome", "/Applications/Chromium.app/Contents/MacOS/Chromium", "/Applications/Google Chrome Canary.app/Contents/MacOS/Google Chrome Canary"}) {
                    if (!new File(p).exists()) continue;
                    return p;
                }
                for (String c : candidates2 = new String[]{"google-chrome", "chromium", "chrome"}) {
                    try {
                        Process pr = new ProcessBuilder("which", c).start();
                        BufferedReader r = new BufferedReader(new InputStreamReader(pr.getInputStream()));
                        String line = r.readLine();
                        if (line == null || line.isEmpty()) continue;
                        return line.trim();
                    }
                    catch (Exception pr) {
                        // empty catch block
                    }
                }
                return null;
            }
            for (String c : candidates = new String[]{"google-chrome", "google-chrome-stable", "chromium-browser", "chromium", "chrome"}) {
                try {
                    Process pr = new ProcessBuilder("which", c).start();
                    BufferedReader r = new BufferedReader(new InputStreamReader(pr.getInputStream()));
                    String line = r.readLine();
                    if (line == null || line.isEmpty()) continue;
                    return line.trim();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }
}

