/*
 * Decompiled with CFR 0.152.
 */
package com.coflnet.sky;

import CoflCore.CoflCore;
import CoflCore.CoflSkyCommand;
import CoflCore.classes.Settings;
import CoflCore.commands.CommandType;
import CoflCore.commands.JsonStringCommand;
import CoflCore.commands.RawCommand;
import CoflCore.configuration.GUIType;
import CoflCore.network.WSClient;
import com.coflnet.sky.config.SellProtectionConfig;
import com.coflnet.sky.gui.tfm.ButtonRemapper;
import com.coflnet.sky.minecraft_integration.PlayerDataProvider;
import com.coflnet.sky.utils.BazaarSearchUtil;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.util.BlockPos;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.ChatStyle;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraftforge.common.MinecraftForge;

public class SkyCoflCommand
extends CommandBase {
    public int func_82362_a() {
        return 0;
    }

    public String func_71517_b() {
        return "cofl";
    }

    public List func_71514_a() {
        ArrayList<String> al = new ArrayList<String>();
        al.add("Cofl");
        al.add("coflnet");
        al.add("cl");
        return al;
    }

    public String func_71518_a(ICommandSender sender) {
        return "Sends sub-arguments to the SkyCofl command server\n\u00a7b/cofl \u00a77will request help text with more info\n";
    }

    public List<String> func_180525_a(ICommandSender sender, String[] args, BlockPos pos) {
        if (args.length == 1) {
            ArrayList<String> options = new ArrayList<String>(CoflCore.config.knownCommands.keySet());
            return CommandBase.func_175762_a((String[])args, options);
        }
        if (args.length == 2 && args[0].equalsIgnoreCase("set")) {
            List options = CoflCore.config.knownSettings.stream().map(Settings::getSettingKey).collect(Collectors.toList());
            options.add("sellProtectionThreshold");
            options.add("sellProtectionEnabled");
            return CommandBase.func_175762_a((String[])args, options);
        }
        return null;
    }

    public void func_71515_b(ICommandSender sender, String[] args) throws CommandException {
        new Thread(() -> {
            block26: {
                block25: {
                    System.out.println(Arrays.toString(args));
                    if (args.length < 1) break block25;
                    switch (args[0].toLowerCase()) {
                        case "copytoclipboard": {
                            String textForClipboard = String.join((CharSequence)" ", Arrays.copyOfRange(args, 1, args.length));
                            try {
                                StringSelection selection = new StringSelection(textForClipboard);
                                Toolkit.getDefaultToolkit().getSystemClipboard().setContents(selection, null);
                                Minecraft.func_71410_x().field_71439_g.func_145747_a((IChatComponent)new ChatComponentText("Text copied to clipboard!"));
                            }
                            catch (Exception e) {
                                Minecraft.func_71410_x().field_71439_g.func_145747_a((IChatComponent)new ChatComponentText("Failed to copy text to clipboard!"));
                            }
                            CoflCore.Wrapper.SendMessage(new JsonStringCommand(CommandType.Clicked, WSClient.gson.toJson("copy:" + textForClipboard)));
                            break;
                        }
                        case "setgui": {
                            if (args.length != 2) {
                                sender.func_145747_a((IChatComponent)new ChatComponentText("[\u00a71C\u00a76oflnet\u00a7f]\u00a77: \u00a77Available GUIs:"));
                                sender.func_145747_a((IChatComponent)new ChatComponentText("[\u00a71C\u00a76oflnet\u00a7f]\u00a77: \u00a77Cofl"));
                                sender.func_145747_a((IChatComponent)new ChatComponentText("[\u00a71C\u00a76oflnet\u00a7f]\u00a77: \u00a77TFM"));
                                sender.func_145747_a((IChatComponent)new ChatComponentText("[\u00a71C\u00a76oflnet\u00a7f]\u00a77: \u00a77Off"));
                                return;
                            }
                            if (args[1].equalsIgnoreCase("cofl")) {
                                CoflCore.config.purchaseOverlay = GUIType.COFL;
                                sender.func_145747_a((IChatComponent)new ChatComponentText("[\u00a71C\u00a76oflnet\u00a7f]\u00a77: \u00a77Set \u00a7bPurchase Overlay \u00a77to: \u00a7fCofl"));
                                MinecraftForge.EVENT_BUS.unregister((Object)ButtonRemapper.getInstance());
                            }
                            if (args[1].equalsIgnoreCase("tfm")) {
                                CoflCore.config.purchaseOverlay = GUIType.TFM;
                                sender.func_145747_a((IChatComponent)new ChatComponentText("[\u00a71C\u00a76oflnet\u00a7f]\u00a77: \u00a77Set \u00a7bPurchase Overlay \u00a77to: \u00a7fTFM"));
                                MinecraftForge.EVENT_BUS.register((Object)ButtonRemapper.getInstance());
                            }
                            if (args[1].equalsIgnoreCase("off") || args[1].equalsIgnoreCase("false")) {
                                CoflCore.config.purchaseOverlay = null;
                                sender.func_145747_a((IChatComponent)new ChatComponentText("[\u00a71C\u00a76oflnet\u00a7f]\u00a77: \u00a77Set \u00a7bPurchase Overlay \u00a77to: \u00a7fOff"));
                                MinecraftForge.EVENT_BUS.unregister((Object)ButtonRemapper.getInstance());
                                break;
                            }
                            break block26;
                        }
                        case "bazaarsearch": {
                            if (args.length < 2) {
                                sender.func_145747_a((IChatComponent)new ChatComponentText("[\u00a71C\u00a76oflnet\u00a7f]\u00a77: \u00a7cUsage: /cofl bazaarsearch <item_name>"));
                                return;
                            }
                            String searchTerm = String.join((CharSequence)" ", Arrays.copyOfRange(args, 1, args.length));
                            boolean success = BazaarSearchUtil.searchInBazaar(searchTerm);
                            if (!success) {
                                sender.func_145747_a((IChatComponent)new ChatComponentText("[\u00a71C\u00a76oflnet\u00a7f]\u00a77: \u00a7cCould not search in bazaar. Make sure you're in a bazaar interface."));
                                break;
                            }
                            break block26;
                        }
                        case "set": {
                            if (args.length >= 3) {
                                String setting = args[1];
                                String value = args[2];
                                if (setting.equalsIgnoreCase("sellProtectionThreshold")) {
                                    try {
                                        long threshold = SellProtectionConfig.parseThresholdValue(value);
                                        SellProtectionConfig.setSellProtectionThreshold(threshold);
                                        String formattedThreshold = SellProtectionConfig.formatThreshold(threshold);
                                        sender.func_145747_a((IChatComponent)new ChatComponentText("[\u00a71C\u00a76oflnet\u00a7f]\u00a77: \u00a77Set \u00a7bSell Protection Threshold \u00a77to: \u00a76" + formattedThreshold + " coins"));
                                    }
                                    catch (NumberFormatException e) {
                                        sender.func_145747_a((IChatComponent)new ChatComponentText("[\u00a71C\u00a76oflnet\u00a7f]\u00a77: \u00a7cInvalid format. Use numbers like 1000000, 2k, 3m, 1.5b"));
                                    }
                                    break;
                                }
                                if (setting.equalsIgnoreCase("sellProtectionEnabled")) {
                                    boolean enabled = Boolean.parseBoolean(value);
                                    SellProtectionConfig.setEnabled(enabled);
                                    sender.func_145747_a((IChatComponent)new ChatComponentText("[\u00a71C\u00a76oflnet\u00a7f]\u00a77: \u00a77Set \u00a7bSell Protection \u00a77to: \u00a7f" + (enabled ? "Enabled" : "Disabled")));
                                    break;
                                }
                            }
                        }
                        default: {
                            CoflSkyCommand.processCommand(args, PlayerDataProvider.getUsername());
                            break;
                        }
                    }
                    break block26;
                }
                this.SendCommandToServer("help", "general", sender);
            }
        }).start();
    }

    public void SendCommandToServer(String[] args, ICommandSender sender) {
        String command = String.join((CharSequence)" ", Arrays.copyOfRange(args, 1, args.length));
        this.SendCommandToServer(args[0], command, sender);
    }

    public void SendCommandToServer(String command, String arguments, ICommandSender sender) {
        RawCommand rc = new RawCommand(command, WSClient.gson.toJson(arguments));
        if (CoflCore.Wrapper.isRunning) {
            CoflCore.Wrapper.SendMessage(rc);
        } else {
            SkyCoflCommand.SendAfterStart(sender, rc);
        }
    }

    private static synchronized void SendAfterStart(ICommandSender sender, RawCommand rc) {
        sender.func_145747_a(new ChatComponentText("SkyCofl wasn't active.").func_150255_a(new ChatStyle().func_150238_a(EnumChatFormatting.RED)));
        CoflCore.Wrapper.startConnection(PlayerDataProvider.getUsername());
        CoflCore.Wrapper.SendMessage(rc);
    }
}

