/*
 * Decompiled with CFR 0.152.
 */
package com.coflnet.sky.config;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.Properties;
import net.minecraft.client.Minecraft;

public class SellProtectionConfig {
    private static final String CONFIG_FILE = "config" + File.separator + "SkyCofl" + File.separator + "skycofl-sellprotection.properties";
    private static Properties properties = new Properties();
    private static File configFile;

    private static void loadConfig() {
        try {
            configFile = new File(Minecraft.func_71410_x().field_71412_D, CONFIG_FILE);
            if (configFile.exists()) {
                FileInputStream fis = new FileInputStream(configFile);
                properties.load(fis);
                fis.close();
            }
        }
        catch (Exception e) {
            System.err.println("Failed to load SkyCofl sell protection config: " + e.getMessage());
        }
    }

    private static void saveConfig() {
        try {
            if (!configFile.exists()) {
                configFile.getParentFile().mkdirs();
                configFile.createNewFile();
            }
            FileOutputStream fos = new FileOutputStream(configFile);
            properties.store(fos, "SkyCofl Sell Protection Configuration");
            fos.close();
        }
        catch (Exception e) {
            System.err.println("Failed to save SkyCofl sell protection config: " + e.getMessage());
        }
    }

    public static long getSellProtectionThreshold() {
        return Long.parseLong(properties.getProperty("sellProtectionThreshold", "1000000"));
    }

    public static void setSellProtectionThreshold(long threshold) {
        properties.setProperty("sellProtectionThreshold", String.valueOf(threshold));
        SellProtectionConfig.saveConfig();
    }

    public static boolean isEnabled() {
        return Boolean.parseBoolean(properties.getProperty("sellProtectionEnabled", "true"));
    }

    public static void setEnabled(boolean enabled) {
        properties.setProperty("sellProtectionEnabled", String.valueOf(enabled));
        SellProtectionConfig.saveConfig();
    }

    public static long parseThresholdValue(String value) throws NumberFormatException {
        if (value == null || value.trim().isEmpty()) {
            throw new NumberFormatException("Empty value");
        }
        value = value.trim().toLowerCase();
        try {
            return Long.parseLong(value);
        }
        catch (NumberFormatException numberFormatException) {
            double number;
            String numberPart = value.replaceAll("[kmb]$", "");
            String suffix = value.replaceAll("^[0-9.]+", "");
            try {
                number = Double.parseDouble(numberPart);
            }
            catch (NumberFormatException e) {
                throw new NumberFormatException("Invalid number format: " + value);
            }
            switch (suffix) {
                case "k": {
                    return (long)(number * 1000.0);
                }
                case "m": {
                    return (long)(number * 1000000.0);
                }
                case "b": {
                    return (long)(number * 1.0E9);
                }
                case "": {
                    return (long)number;
                }
            }
            throw new NumberFormatException("Unknown suffix: " + suffix);
        }
    }

    public static String formatThreshold(long threshold) {
        if (threshold >= 1000000000L) {
            return String.format("%.1fB", (double)threshold / 1.0E9);
        }
        if (threshold >= 1000000L) {
            return String.format("%.1fM", (double)threshold / 1000000.0);
        }
        if (threshold >= 1000L) {
            return String.format("%.1fK", (double)threshold / 1000.0);
        }
        return String.valueOf(threshold);
    }

    static {
        SellProtectionConfig.loadConfig();
    }
}

