/*
 * Decompiled with CFR 0.152.
 */
package com.coflnet.sky.gui.bingui.helper;

import java.awt.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.lwjgl.opengl.GL11;

public class RenderUtils {
    public static Minecraft mc = Minecraft.func_71410_x();

    public static void drawRect(float x, float y, float width, float height, int color) {
        float alpha = (float)(color >> 24 & 0xFF) / 255.0f;
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float green = (float)(color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        GL11.glEnable((int)3042);
        GL11.glDisable((int)3553);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glColor4f((float)red, (float)green, (float)blue, (float)alpha);
        GL11.glBegin((int)7);
        GL11.glVertex2d((double)x, (double)y);
        GL11.glVertex2d((double)x, (double)(y + height));
        GL11.glVertex2d((double)(x + width), (double)(y + height));
        GL11.glVertex2d((double)(x + width), (double)y);
        GL11.glEnd();
        GL11.glEnable((int)3553);
        GL11.glDisable((int)3042);
    }

    public static void drawRectOutline(int x, int y, int width, int height, float lineWidth, Color color) {
        GL11.glEnable((int)3042);
        GL11.glDisable((int)3553);
        GL11.glBlendFunc((int)770, (int)771);
        RenderUtils.setColor(color);
        GL11.glLineWidth((float)lineWidth);
        GL11.glBegin((int)2);
        GL11.glVertex2d((double)x, (double)y);
        GL11.glVertex2d((double)(x + width), (double)y);
        GL11.glVertex2d((double)(x + width), (double)(y + height));
        GL11.glVertex2d((double)x, (double)(y + height));
        GL11.glEnd();
        GL11.glEnable((int)3553);
        GL11.glDisable((int)3042);
    }

    public static void drawCircle(int x, int y, int radius, Color color) {
        GL11.glEnable((int)3042);
        GL11.glDisable((int)3553);
        GL11.glBlendFunc((int)770, (int)771);
        RenderUtils.setColor(color);
        GL11.glBegin((int)6);
        GL11.glVertex2d((double)x, (double)y);
        for (int i = 0; i <= 360; ++i) {
            GL11.glVertex2d((double)((double)x + Math.sin((double)i * Math.PI / 180.0) * (double)radius), (double)((double)y + Math.cos((double)i * Math.PI / 180.0) * (double)radius));
        }
        GL11.glEnd();
        GL11.glEnable((int)3553);
        GL11.glDisable((int)3042);
    }

    public static void drawCircleOutline(int x, int y, float radius, float thickness, Color color) {
        GL11.glEnable((int)3042);
        GL11.glDisable((int)3553);
        GL11.glBlendFunc((int)770, (int)771);
        RenderUtils.setColor(color);
        GL11.glBegin((int)2);
        for (int i = 0; i <= 360; ++i) {
            GL11.glVertex2d((double)((double)x + Math.sin((double)i * Math.PI / 180.0) * (double)radius), (double)((double)y + Math.cos((double)i * Math.PI / 180.0) * (double)radius));
        }
        GL11.glEnd();
        GL11.glEnable((int)3553);
        GL11.glDisable((int)3042);
    }

    public static void drawLine(float x1, float y1, float x2, float y2, float thickness, Color color) {
        GL11.glEnable((int)3042);
        GL11.glDisable((int)3553);
        GL11.glBlendFunc((int)770, (int)771);
        RenderUtils.setColor(color);
        GL11.glLineWidth((float)thickness);
        GL11.glBegin((int)1);
        GL11.glVertex2d((double)x1, (double)y1);
        GL11.glVertex2d((double)x2, (double)y2);
        GL11.glEnd();
        GL11.glEnable((int)3553);
        GL11.glDisable((int)3042);
    }

    public static void drawTriangle(int x, int y, int x2, int y2, int x3, int y3, Color color) {
        GL11.glEnable((int)3042);
        GL11.glDisable((int)3553);
        GL11.glBlendFunc((int)770, (int)771);
        RenderUtils.setColor(color);
        GL11.glBegin((int)4);
        GL11.glVertex2d((double)x, (double)y);
        GL11.glVertex2d((double)x2, (double)y2);
        GL11.glVertex2d((double)x3, (double)y3);
        GL11.glEnd();
        GL11.glEnable((int)3553);
        GL11.glDisable((int)3042);
    }

    public static void drawTriangleOutline(int x, int y, int x2, int y2, int x3, int y3, Color color) {
        GL11.glEnable((int)3042);
        GL11.glDisable((int)3553);
        GL11.glBlendFunc((int)770, (int)771);
        RenderUtils.setColor(color);
        GL11.glBegin((int)2);
        GL11.glVertex2d((double)x, (double)y);
        GL11.glVertex2d((double)x2, (double)y2);
        GL11.glVertex2d((double)x3, (double)y3);
        GL11.glEnd();
        GL11.glEnable((int)3553);
        GL11.glDisable((int)3042);
    }

    public static void drawArc(int x, int y, int radius, int startAngle, int endAngle, Color color) {
        GL11.glEnable((int)3042);
        GL11.glDisable((int)3553);
        GL11.glBlendFunc((int)770, (int)771);
        RenderUtils.setColor(color);
        GL11.glBegin((int)6);
        GL11.glVertex2d((double)x, (double)y);
        for (int i = startAngle; i <= endAngle; ++i) {
            GL11.glVertex2d((double)((double)x + Math.sin((double)i * Math.PI / 180.0) * (double)radius), (double)((double)y + Math.cos((double)i * Math.PI / 180.0) * (double)radius));
        }
        GL11.glEnd();
        GL11.glEnable((int)3553);
        GL11.glDisable((int)3042);
    }

    public static void drawLoadingCircle(float x, float y, float radius, float thickness, float speed, Color color) {
        GL11.glEnable((int)3042);
        GL11.glDisable((int)3553);
        GL11.glBlendFunc((int)770, (int)771);
        RenderUtils.setColor(color);
        GL11.glLineWidth((float)thickness);
        GL11.glBegin((int)3);
        for (int i = 0; i <= 360; ++i) {
            GL11.glVertex2d((double)((double)x + Math.sin((double)((float)i + speed) * Math.PI / 180.0) * (double)radius), (double)((double)y + Math.cos((double)((float)i + speed) * Math.PI / 180.0) * (double)radius));
        }
        GL11.glEnd();
        GL11.glEnable((int)3553);
        GL11.glDisable((int)3042);
    }

    public static void drawRoundedRect(int x, int y, int width, int height, int radius, @NotNull Color color) {
        RenderUtils.drawRect(x + radius, y, width - radius * 2, height, color.getRGB());
        RenderUtils.drawRect(x, y + radius, radius, height - radius * 2, color.getRGB());
        RenderUtils.drawRect(x + width - radius, y + radius, radius, height - radius * 2, color.getRGB());
        RenderUtils.drawArc(x + radius, y + radius, radius, 180, 270, color);
        RenderUtils.drawArc(x + width - radius, y + radius, radius, 90, 180, color);
        RenderUtils.drawArc(x + radius, y + height - radius, radius, 270, 360, color);
        RenderUtils.drawArc(x + width - radius, y + height - radius, radius, 0, 90, color);
    }

    public static void drawGradientRect(int x, int y, int width, int height, Color color1, Color color2) {
        GL11.glEnable((int)3042);
        GL11.glDisable((int)3553);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glShadeModel((int)7425);
        GL11.glBegin((int)7);
        RenderUtils.setColor(color1);
        GL11.glVertex2d((double)x, (double)y);
        GL11.glVertex2d((double)(x + width), (double)y);
        RenderUtils.setColor(color2);
        GL11.glVertex2d((double)(x + width), (double)(y + height));
        GL11.glVertex2d((double)x, (double)(y + height));
        GL11.glEnd();
        GL11.glShadeModel((int)7424);
        GL11.glEnable((int)3553);
        GL11.glDisable((int)3042);
    }

    public static void drawString(String text, int x, int y, Color color) {
        RenderUtils.setColor(color);
        RenderUtils.mc.field_71466_p.func_78276_b(text, x, y, color.getRGB());
    }

    public static void drawStringWithShadow(String text, int x, int y, Color color) {
        RenderUtils.setColor(color);
        RenderUtils.mc.field_71466_p.func_175063_a(text, (float)x, (float)y, color.getRGB());
    }

    public static void drawCenteredString(String text, int x, int y, Color color) {
        RenderUtils.setColor(color);
        RenderUtils.mc.field_71466_p.func_78276_b(text, x - RenderUtils.mc.field_71466_p.func_78256_a(text) / 2, y, color.getRGB());
    }

    public static void drawCenteredStringWithShadow(String text, int x, int y, Color color) {
        RenderUtils.setColor(color);
        RenderUtils.mc.field_71466_p.func_175063_a(text, (float)(x - RenderUtils.mc.field_71466_p.func_78256_a(text) / 2), (float)y, color.getRGB());
    }

    public static void drawString(String text, int x, int y, Color color, int scale) {
        RenderUtils.setColor(color);
        FontRenderer fr = RenderUtils.mc.field_71466_p;
        fr.func_78276_b(text, x, y, color.getRGB());
    }

    public static void drawStringWithShadow(String text, int x, int y, Color color, int scale) {
        RenderUtils.setColor(color);
        FontRenderer fr = RenderUtils.mc.field_71466_p;
        fr.func_175063_a(text, (float)x, (float)y, color.getRGB());
    }

    public static void drawCenteredString(String text, int x, int y, Color color, int scale) {
        RenderUtils.setColor(color);
        FontRenderer fr = RenderUtils.mc.field_71466_p;
        fr.func_78276_b(text, x - fr.func_78256_a(text) / 2, y, color.getRGB());
    }

    public static void drawCenteredStringWithShadow(String text, int x, int y, Color color, int scale) {
        RenderUtils.setColor(color);
        FontRenderer fr = RenderUtils.mc.field_71466_p;
        fr.func_175063_a(text, (float)(x - fr.func_78256_a(text) / 2), (float)y, color.getRGB());
    }

    public static void drawCenteredStringWithShadow(String text, int x, int y, Color color, int scale, boolean centered) {
        RenderUtils.setColor(color);
        FontRenderer fr = RenderUtils.mc.field_71466_p;
        if (centered) {
            fr.func_175063_a(text, (float)(x - fr.func_78256_a(text) / 2), (float)y, color.getRGB());
        } else {
            fr.func_175063_a(text, (float)x, (float)y, color.getRGB());
        }
    }

    public static void drawItemStack(ItemStack itemStack, int x, int y, float scale) {
        GL11.glPushMatrix();
        GL11.glScalef((float)scale, (float)scale, (float)scale);
        mc.func_175599_af().func_175042_a(itemStack, x, y);
        GL11.glPopMatrix();
    }

    public static void drawItemStackWithText(ItemStack stack, int x, int y, String text) {
        if (stack == null) {
            return;
        }
        RenderItem itemRender = Minecraft.func_71410_x().func_175599_af();
        RenderUtils.setColor(Color.WHITE);
        RenderHelper.func_74520_c();
        itemRender.field_77023_b = -145.0f;
        itemRender.func_180450_b(stack, x, y);
        itemRender.func_180453_a(Minecraft.func_71410_x().field_71466_p, stack, x, y, text);
        itemRender.field_77023_b = 0.0f;
        RenderHelper.func_74518_a();
    }

    public static void drawItemStack(ItemStack stack, int x, int y) {
        RenderUtils.drawItemStackWithText(stack, x, y, null);
    }

    public static void drawItemStack(ItemStack itemStack, int x, int y, float scaleX, float scaleY) {
        GL11.glPushMatrix();
        GL11.glScalef((float)scaleX, (float)scaleY, (float)0.0f);
        RenderUtils.drawItemStack(itemStack, x, y);
        GL11.glPopMatrix();
    }

    public static void drawCenteredItemStack(ItemStack itemStack, int x, int y, float scale) {
        GL11.glPushMatrix();
        GL11.glScalef((float)scale, (float)scale, (float)scale);
        RenderUtils.drawItemStack(itemStack, (int)((float)x - scale / 2.0f), (int)((float)y - scale / 2.0f));
        GL11.glPopMatrix();
    }

    public static void drawCheckMark(int x, int y, int size, Color color) {
        GL11.glPushMatrix();
        GL11.glEnable((int)3042);
        GL11.glDisable((int)3553);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glLineWidth((float)2.0f);
        RenderUtils.setColor(color);
        GL11.glBegin((int)1);
        GL11.glVertex2d((double)x, (double)(y + size / 2));
        GL11.glVertex2d((double)(x + size / 2), (double)(y + size));
        GL11.glVertex2d((double)(x + size / 2), (double)(y + size));
        GL11.glVertex2d((double)(x + size), (double)y);
        GL11.glEnd();
        GL11.glEnable((int)3553);
        GL11.glDisable((int)3042);
        GL11.glPopMatrix();
    }

    public static void drawCrossMark(int x, int y, int x2, int y2, Color color) {
        GL11.glPushMatrix();
        GL11.glEnable((int)3042);
        GL11.glDisable((int)3553);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glLineWidth((float)2.0f);
        RenderUtils.setColor(color);
        GL11.glBegin((int)1);
        GL11.glVertex2d((double)x, (double)y);
        GL11.glVertex2d((double)x2, (double)y2);
        GL11.glVertex2d((double)x2, (double)y);
        GL11.glVertex2d((double)x, (double)y2);
        GL11.glEnd();
        GL11.glEnable((int)3553);
        GL11.glDisable((int)3042);
        GL11.glPopMatrix();
    }

    public static Color setAlpha(Color color, int alpha) {
        return new Color(color.getRed(), color.getGreen(), color.getBlue(), alpha);
    }

    public static void setColor(int color) {
        float alpha = (float)(color >> 24 & 0xFF) / 255.0f;
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float green = (float)(color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        GL11.glColor4f((float)red, (float)green, (float)blue, (float)alpha);
    }

    public static void setColor(Color color) {
        RenderUtils.setColor(color.getRGB());
    }

    public static void rotate(float angle) {
        GL11.glRotatef((float)angle, (float)0.0f, (float)0.0f, (float)1.0f);
    }

    public static void renderWaypointHighlightBoxes(int[][] blockCoords) {
        GL11.glPushMatrix();
        GL11.glDisable((int)2929);
        GL11.glEnable((int)3042);
        GL11.glDisable((int)3553);
        GL11.glBlendFunc((int)770, (int)771);
        RenderUtils.setColor(new Color(0, 255, 0, 128));
        for (int[] coord : blockCoords) {
            double x = (double)coord[0] - RenderUtils.mc.func_175598_ae().field_78730_l;
            double y = (double)coord[1] - RenderUtils.mc.func_175598_ae().field_78731_m;
            double z = (double)coord[2] - RenderUtils.mc.func_175598_ae().field_78728_n;
            GL11.glPushMatrix();
            GL11.glTranslated((double)x, (double)y, (double)z);
            GL11.glLineWidth((float)2.0f);
            GL11.glBegin((int)7);
            GL11.glVertex3d((double)0.0, (double)0.0, (double)0.0);
            GL11.glVertex3d((double)1.0, (double)0.0, (double)0.0);
            GL11.glVertex3d((double)1.0, (double)0.0, (double)1.0);
            GL11.glVertex3d((double)0.0, (double)0.0, (double)1.0);
            GL11.glVertex3d((double)0.0, (double)1.0, (double)0.0);
            GL11.glVertex3d((double)1.0, (double)1.0, (double)0.0);
            GL11.glVertex3d((double)1.0, (double)1.0, (double)1.0);
            GL11.glVertex3d((double)0.0, (double)1.0, (double)1.0);
            GL11.glVertex3d((double)0.0, (double)0.0, (double)1.0);
            GL11.glVertex3d((double)1.0, (double)0.0, (double)1.0);
            GL11.glVertex3d((double)1.0, (double)1.0, (double)1.0);
            GL11.glVertex3d((double)0.0, (double)1.0, (double)1.0);
            GL11.glVertex3d((double)0.0, (double)0.0, (double)0.0);
            GL11.glVertex3d((double)1.0, (double)0.0, (double)0.0);
            GL11.glVertex3d((double)1.0, (double)1.0, (double)0.0);
            GL11.glVertex3d((double)0.0, (double)1.0, (double)0.0);
            GL11.glVertex3d((double)0.0, (double)0.0, (double)0.0);
            GL11.glVertex3d((double)0.0, (double)0.0, (double)1.0);
            GL11.glVertex3d((double)0.0, (double)1.0, (double)1.0);
            GL11.glVertex3d((double)0.0, (double)1.0, (double)0.0);
            GL11.glVertex3d((double)1.0, (double)0.0, (double)0.0);
            GL11.glVertex3d((double)1.0, (double)0.0, (double)1.0);
            GL11.glVertex3d((double)1.0, (double)1.0, (double)1.0);
            GL11.glVertex3d((double)1.0, (double)1.0, (double)0.0);
            GL11.glEnd();
            GL11.glPopMatrix();
        }
        GL11.glEnable((int)3553);
        GL11.glDisable((int)3042);
        GL11.glEnable((int)2929);
        GL11.glPopMatrix();
    }
}

