/*
 * Decompiled with CFR 0.152.
 */
package com.coflnet.sky.gui.tfm;

import CoflCore.CoflCore;
import CoflCore.configuration.GUIType;
import com.coflnet.sky.gui.tfm.ToolTipHelper;
import com.coflnet.sky.handlers.EventHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.gui.inventory.GuiChest;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ContainerChest;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import org.lwjgl.input.Mouse;

public class ButtonRemapper {
    private static ButtonRemapper instance;
    private static final int BUY_BUTTON_SLOT = 31;
    private static final int ITEM_SLOT = 13;
    private static final int CONFIRM_BUTTON_SLOT = 11;
    private static final int CANCEL_CONFIRM_SLOT = 15;
    private static final int BACK_BUTTON_SLOT = 49;
    private static final double SCALE_VALUE = 2.0;
    private static final Pattern BED_TIME_PATTERN;
    private final Method drawItemMethod;
    private final Method renderToolTipMethod;

    private ButtonRemapper() {
        String[] methodNames = new String[]{"drawItemStack", "func_146982_a"};
        this.drawItemMethod = ReflectionHelper.findMethod(GuiContainer.class, null, (String[])methodNames, (Class[])new Class[]{ItemStack.class, Integer.TYPE, Integer.TYPE, String.class});
        this.drawItemMethod.setAccessible(true);
        methodNames = new String[]{"renderToolTip", "func_146285_a"};
        this.renderToolTipMethod = ReflectionHelper.findMethod(GuiScreen.class, null, (String[])methodNames, (Class[])new Class[]{ItemStack.class, Integer.TYPE, Integer.TYPE});
    }

    public static ButtonRemapper getInstance() {
        if (instance == null) {
            instance = new ButtonRemapper();
        }
        return instance;
    }

    public ItemStack getItem(int slotNum, GuiChest currentScreen) {
        ContainerChest container = (ContainerChest)currentScreen.field_147002_h;
        return container.func_75139_a(slotNum).func_75211_c();
    }

    public boolean waitingForBed(GuiChest currentScreen) {
        ItemStack bedStack = this.getItem(31, currentScreen);
        if (bedStack == null || !bedStack.func_77973_b().equals(Item.func_111206_d((String)"minecraft:bed"))) {
            return false;
        }
        ItemStack itemStack = this.getItem(13, currentScreen);
        if (itemStack == null) {
            return false;
        }
        List itemTooltip = itemStack.func_82840_a((EntityPlayer)Minecraft.func_71410_x().field_71439_g, false);
        for (String data : itemTooltip) {
            String timeData;
            Matcher matcher = BED_TIME_PATTERN.matcher(EnumChatFormatting.func_110646_a((String)data));
            if (!matcher.find() || (timeData = matcher.group(1)).equals("Soon!")) continue;
            return true;
        }
        return false;
    }

    private int[] getBuyBoxDimensions() {
        int centerX = this.getGuiCenterX();
        int centerY = this.getGuiCenterY();
        double multiplier = 0.1;
        return new int[]{(int)((double)centerX - (double)centerX * multiplier), (int)((double)centerY + (double)centerY * multiplier), (int)((double)centerX + (double)centerX * multiplier), (int)((double)centerY - (double)centerY * multiplier)};
    }

    private int[] getCancelBoxDimensions() {
        int centerX = this.getGuiCenterX();
        int centerY = (int)((double)this.getGuiCenterY() * 1.25);
        double multiplier = 0.05;
        return new int[]{(int)((double)centerX - (double)centerX * multiplier), (int)((double)centerY + (double)centerY * multiplier), (int)((double)centerX + (double)centerX * multiplier), (int)((double)centerY - (double)centerY * multiplier)};
    }

    private void drawBoxWithShadow(int leftX, int topY, int rightX, int bottomY, int colour, int shadowSize, int shadowColour) {
        Gui.func_73734_a((int)(leftX - shadowSize), (int)(topY + shadowSize), (int)(rightX + shadowSize), (int)(bottomY - shadowSize), (int)shadowColour);
        Gui.func_73734_a((int)leftX, (int)topY, (int)rightX, (int)bottomY, (int)colour);
    }

    private void drawTfmBox(boolean isConfirm) {
        String titleText = isConfirm ? "Cofl - Confirm Purchase" : "Cofl - Auction View";
        int outerBox = -11579569;
        this.drawBoxWithShadow((int)((double)this.getGuiCenterX() * 0.5), (int)((double)this.getGuiCenterY() * 1.6), (int)((double)this.getGuiCenterX() * 1.5), (int)((double)this.getGuiCenterY() * 0.4), outerBox, 1, -16777216);
        Minecraft.func_71410_x().field_71466_p.func_175063_a(titleText, (float)((int)((double)this.getGuiCenterX() * 0.55)), (float)((int)((double)this.getGuiCenterY() * 0.45)), -1);
    }

    private void renderTooltip(GuiChest chest, ItemStack item) {
        ToolTipHelper toolTipData = new ToolTipHelper(item);
        int toolTipY = this.getGuiCenterY() - toolTipData.determineHeight() / 2;
        int toolTipX = (int)((double)this.getGuiCenterX() * 1.25) - toolTipData.determineWidth() / 2;
        if (toolTipX < this.getGuiCenterX()) {
            toolTipX = this.getGuiCenterX() + 10;
        }
        try {
            this.renderToolTipMethod.invoke((Object)chest, item, toolTipX, toolTipY);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    private void renderItem(GuiChest chest, ItemStack item) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179139_a((double)2.0, (double)2.0, (double)0.0);
        int itemX = (int)((double)(this.getGuiCenterX() - 16) / 2.0);
        int itemY = (int)((double)(this.getGuiCenterY() - 16) / 2.0);
        try {
            this.drawItemMethod.invoke((Object)chest, item, itemX, itemY, null);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            e.printStackTrace();
        }
        GlStateManager.func_179121_F();
    }

    private void drawBuyBox(boolean shouldBeRed) {
        int colour = shouldBeRed ? 0xFF0000 : 65280;
        int[] dim = this.getBuyBoxDimensions();
        this.drawBoxWithShadow(dim[0], dim[1], dim[2], dim[3], colour -= Integer.MIN_VALUE, 1, -16777216);
    }

    private void drawCancelBox() {
        int colour = 0x7FFF0000;
        int[] dim = this.getCancelBoxDimensions();
        this.drawBoxWithShadow(dim[0], dim[1], dim[2], dim[3], colour, 1, -16777216);
    }

    public void drawProfitInfo() {
        FontRenderer font = Minecraft.func_71410_x().field_71466_p;
        String text = CoflCore.flipHandler.lastClickedFlipMessage;
        if (text == null) {
            return;
        }
        StringBuilder current = new StringBuilder();
        int lineNo = 0;
        for (int i = 0; i < text.length(); ++i) {
            char character = text.charAt(i);
            current.append(character);
            if (current.length() <= 50 || character != ' ') continue;
            font.func_175063_a(current.toString(), (float)((int)((double)this.getGuiCenterX() * 0.55)), (float)((int)((double)this.getGuiCenterY() * 0.5 + (double)(15 * lineNo))), -7368817);
            current = new StringBuilder();
            ++lineNo;
        }
        font.func_175063_a(current.toString(), (float)((int)((double)this.getGuiCenterX() * 0.55)), (float)((int)((double)this.getGuiCenterY() * 0.5 + (double)(15 * lineNo))), -7368817);
    }

    private void drawBox(GuiChest chest, boolean shouldBeRed, boolean isConfirm) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)0.0, (double)0.0, (double)512.0);
        ItemStack item = this.getItem(13, chest);
        this.drawTfmBox(isConfirm);
        this.drawBuyBox(shouldBeRed);
        this.drawCancelBox();
        if (item != null) {
            this.drawProfitInfo();
            this.renderItem(chest, item);
            this.renderTooltip(chest, item);
        }
        GlStateManager.func_179121_F();
    }

    private int getGuiCenterX() {
        ScaledResolution resolution = new ScaledResolution(Minecraft.func_71410_x());
        return resolution.func_78326_a() / 2;
    }

    private int getGuiCenterY() {
        ScaledResolution resolution = new ScaledResolution(Minecraft.func_71410_x());
        return resolution.func_78328_b() / 2;
    }

    private boolean isInBox(int x, int y) {
        int[] dim = this.getBuyBoxDimensions();
        return x > dim[0] && x < dim[2] && y > dim[3] && y < dim[1];
    }

    private boolean isInCancelBox(int x, int y) {
        int[] dim = this.getCancelBoxDimensions();
        return x > dim[0] && x < dim[2] && y > dim[3] && y < dim[1];
    }

    public void drawBuyButton(GuiChest currentScreen) {
        if (!this.shouldDrawGui(currentScreen)) {
            return;
        }
        this.drawBox(currentScreen, this.waitingForBed(currentScreen), false);
    }

    public boolean shouldDrawGui(GuiChest currentScreen) {
        ItemStack stack = this.getItem(31, currentScreen);
        return stack != null && (stack.func_77973_b().equals(Item.func_111206_d((String)"minecraft:bed")) || stack.func_77973_b().equals(Item.func_111206_d((String)"minecraft:gold_nugget")));
    }

    public void drawConfirmButton(GuiChest currentScreen) {
        this.drawBox(currentScreen, false, true);
    }

    private boolean shouldSkip(GuiScreen screen) {
        return !(screen instanceof GuiChest) || CoflCore.config.purchaseOverlay != GUIType.TFM || !EventHandler.isInSkyblock;
    }

    @SubscribeEvent
    public void onPostRenderEvent(GuiScreenEvent.DrawScreenEvent.Post event) {
        if (this.shouldSkip(event.gui)) {
            return;
        }
        GuiChest auctionView = (GuiChest)event.gui;
        ContainerChest container = (ContainerChest)auctionView.field_147002_h;
        String containerName = container.func_85151_d().func_145748_c_().func_150260_c();
        if (containerName.trim().equals("BIN Auction View")) {
            this.drawBuyButton(auctionView);
        } else if (containerName.trim().equals("Confirm Purchase")) {
            this.drawConfirmButton(auctionView);
        }
    }

    private void clickSlot(int windowId, int slot) {
        Minecraft.func_71410_x().field_71442_b.func_78753_a(windowId, slot, 2, 3, (EntityPlayer)Minecraft.func_71410_x().field_71439_g);
    }

    private void handleBuyClick(GuiChest currentScreen, GuiScreenEvent.MouseInputEvent.Pre event) {
        if (this.waitingForBed(currentScreen) || !this.shouldDrawGui(currentScreen)) {
            return;
        }
        event.setCanceled(true);
        this.clickSlot(currentScreen.field_147002_h.field_75152_c, 31);
    }

    private void handleConfirmClick(GuiChest currentScreen, int windowId) {
        this.clickSlot(windowId, 11);
    }

    private void handlePositiveClick(GuiScreen screen, GuiScreenEvent.MouseInputEvent.Pre event) {
        if (this.shouldSkip(screen)) {
            return;
        }
        GuiChest auctionView = (GuiChest)screen;
        ContainerChest container = (ContainerChest)auctionView.field_147002_h;
        String containerName = container.func_85151_d().func_145748_c_().func_150260_c();
        if (containerName.trim().equals("BIN Auction View")) {
            this.handleBuyClick(auctionView, event);
        } else if (containerName.trim().equals("Confirm Purchase")) {
            this.handleConfirmClick(auctionView, container.field_75152_c);
            event.setCanceled(true);
        }
    }

    private void doCancelClick(ContainerChest chest, int slotId) {
        this.clickSlot(chest.field_75152_c, slotId);
    }

    private void handleCancelClick(GuiScreen screen, GuiScreenEvent.MouseInputEvent.Pre event) {
        if (this.shouldSkip(screen)) {
            return;
        }
        GuiChest auctionView = (GuiChest)screen;
        ContainerChest container = (ContainerChest)auctionView.field_147002_h;
        String containerName = container.func_85151_d().func_145748_c_().func_150260_c();
        if (containerName.trim().equals("BIN Auction View")) {
            this.doCancelClick(container, 49);
        } else if (containerName.trim().equals("Confirm Purchase")) {
            this.doCancelClick(container, 15);
        } else {
            return;
        }
        event.setCanceled(true);
    }

    @SubscribeEvent
    public void onMouseClicked(GuiScreenEvent.MouseInputEvent.Pre event) {
        int y;
        if (!Mouse.getEventButtonState()) {
            return;
        }
        GuiScreen screen = event.gui;
        if (screen == null) {
            return;
        }
        int x = Mouse.getEventX() * screen.field_146294_l / Minecraft.func_71410_x().field_71443_c;
        if (this.isInBox(x, y = screen.field_146295_m - Mouse.getEventY() * screen.field_146295_m / Minecraft.func_71410_x().field_71440_d - 1)) {
            this.handlePositiveClick(screen, event);
        } else if (this.isInCancelBox(x, y)) {
            this.handleCancelClick(screen, event);
        }
    }

    static {
        BED_TIME_PATTERN = Pattern.compile("Can buy in: (.*)");
    }
}

