/*
 * Decompiled with CFR 0.152.
 */
package com.coflnet.sky.handlers;

import CoflCore.CoflCore;
import CoflCore.commands.Command;
import CoflCore.commands.CommandType;
import CoflCore.commands.JsonStringCommand;
import CoflCore.commands.models.AuctionData;
import CoflCore.commands.models.FlipData;
import CoflCore.commands.models.HotkeyRegister;
import CoflCore.handlers.DescriptionHandler;
import CoflCore.network.WSClient;
import com.coflnet.sky.SkyCofl;
import com.coflnet.sky.WSCommandHandler;
import com.coflnet.sky.config.InfoDisplayConfig;
import com.coflnet.sky.gui.bingui.helper.RenderUtils;
import com.coflnet.sky.handlers.EventHandler;
import com.coflnet.sky.handlers.ForgeDescriptionHandler;
import com.coflnet.sky.minecraft_integration.CountdownTimer;
import com.coflnet.sky.mixins.AccessorGuiEditSign;
import com.coflnet.sky.models.ClickableTextElement;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.mojang.realmsclient.util.Pair;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.regex.Pattern;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.inventory.GuiChest;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.gui.inventory.GuiEditSign;
import net.minecraft.client.gui.inventory.GuiInventory;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.Entity;
import net.minecraft.event.HoverEvent;
import net.minecraft.inventory.ContainerChest;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntitySign;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.ClientChatReceivedEvent;
import net.minecraftforge.client.event.DrawBlockHighlightEvent;
import net.minecraftforge.client.event.GuiOpenEvent;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.InputEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.FMLNetworkEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;

public class EventRegistry {
    public static Pattern chatpattern = Pattern.compile("a^", 2);
    public final ExecutorService chatThreadPool = Executors.newFixedThreadPool(2);
    public final ExecutorService tickThreadPool = Executors.newFixedThreadPool(2);
    public static long LastClick = System.currentTimeMillis();
    public static Boolean LastHotkeyState;
    public static Boolean LastEventButtonState;
    private ForgeDescriptionHandler forgeDescriptionHandler;
    public static ItemStack GOLD_NUGGET;
    public static final Pair<String, Pair<String, LocalDateTime>> EMPTY;
    public static Pair<String, Pair<String, LocalDateTime>> last;
    public static long lastStartTime;
    public static long LastViewAuctionInvocation;
    public static String LastViewAuctionUUID;
    private static final List<ClickableArea> clickableAreas;
    private static String currentHoverText;
    private static int hoverX;
    private static int hoverY;
    private static boolean isDragging;
    private static int dragStartX;
    private static int dragStartY;
    private static int textOffsetX;
    private static int textOffsetY;
    long UpdateThisTick = 0L;

    @SubscribeEvent
    public void onDisconnectedFromServerEvent(FMLNetworkEvent.ClientDisconnectionFromServerEvent event) {
        if (CoflCore.Wrapper.isRunning) {
            System.out.println("Disconnected from server");
            CoflCore.Wrapper.stop();
            EventHandler.isInSkyblock = false;
            System.out.println("SkyCofl stopped");
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent(priority=EventPriority.NORMAL, receiveCanceled=true)
    public void onMouseEvent(InputEvent.MouseInputEvent event) {
        if (LastEventButtonState != null && Mouse.getEventButtonState() == LastEventButtonState) {
            return;
        }
        LastEventButtonState = Mouse.getEventButtonState();
        EventRegistry.onAfterKeyPressed();
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent(priority=EventPriority.NORMAL, receiveCanceled=true)
    public void onKeyEvent(InputEvent.KeyInputEvent event) {
        if (LastHotkeyState != null && Keyboard.getEventKeyState() == LastHotkeyState) {
            return;
        }
        LastHotkeyState = Keyboard.getEventKeyState();
        EventRegistry.onAfterKeyPressed();
    }

    public static void onAfterKeyPressed() {
        FlipData f;
        if (SkyCofl.keyBindings[0].func_151468_f() && WSCommandHandler.lastOnClickEvent != null && (f = CoflCore.flipHandler.fds.GetLastFlip()) != null) {
            WSCommandHandler.Execute("/cofl openauctiongui " + f.Id + " false", (Entity)Minecraft.func_71410_x().field_71439_g);
        }
        if (SkyCofl.keyBindings[1].func_151470_d() && System.currentTimeMillis() - LastClick >= 300L) {
            f = CoflCore.flipHandler.fds.GetHighestFlip();
            if (f != null) {
                WSCommandHandler.Execute("/cofl openauctiongui " + f.Id + " true", (Entity)Minecraft.func_71410_x().field_71439_g);
                LastViewAuctionUUID = f.Id;
                LastViewAuctionInvocation = System.currentTimeMillis();
                LastClick = System.currentTimeMillis();
                String command = WSClient.gson.toJson("/viewauction " + f.Id);
                CoflCore.Wrapper.SendMessage(new JsonStringCommand(CommandType.Clicked, command));
                WSCommandHandler.Execute("/cofl track besthotkey " + f.Id, (Entity)Minecraft.func_71410_x().field_71439_g);
            } else if (SkyCofl.keyBindings[1].func_151468_f()) {
                WSCommandHandler.Execute("/cofl dialog nobestflip", (Entity)Minecraft.func_71410_x().field_71439_g);
            }
        }
        EventRegistry.triggerItemKeys(false);
    }

    public static void triggerItemKeys(boolean checkForKey) {
        if (SkyCofl.keyBindings[2].func_151468_f() || checkForKey && Keyboard.getEventKey() == SkyCofl.keyBindings[2].func_151463_i()) {
            String toAppend = EventRegistry.getContextToAppend();
            WSCommandHandler.Execute("/cofl hotkey upload_item" + toAppend, (Entity)Minecraft.func_71410_x().field_71439_g);
        }
        if (SkyCofl.keyBindings.length <= 3) {
            return;
        }
        System.out.println("Checking for additional hotkeys...");
        for (int i = 3; i < SkyCofl.keyBindings.length; ++i) {
            if (!SkyCofl.keyBindings[i].func_151468_f() && (!checkForKey || Keyboard.getEventKey() != SkyCofl.keyBindings[i].func_151463_i())) continue;
            String keyName = SkyCofl.keyBindings[i].func_151464_g();
            String toAppend = EventRegistry.getContextToAppend();
            WSCommandHandler.Execute("/cofl hotkey " + keyName + toAppend, (Entity)Minecraft.func_71410_x().field_71439_g);
        }
    }

    private static String getContextToAppend() {
        String toAppend = "";
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71439_g == null) {
            return toAppend;
        }
        ItemStack relevantItem = null;
        if (mc.field_71462_r instanceof GuiContainer) {
            GuiContainer gui = (GuiContainer)mc.field_71462_r;
            int mx = Mouse.getX() * gui.field_146294_l / mc.field_71443_c;
            int my = gui.field_146295_m - Mouse.getY() * gui.field_146295_m / mc.field_71440_d - 1;
            try {
                Slot hovered = null;
                try {
                    Method m3 = GuiContainer.class.getMethod("getSlotAtPosition", Integer.TYPE, Integer.TYPE);
                    Object res = m3.invoke((Object)gui, mx, my);
                    if (res instanceof Slot) {
                        hovered = (Slot)res;
                    }
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
                if (hovered == null) {
                    for (Object o : gui.field_147002_h.field_75151_b) {
                        if (!(o instanceof Slot)) continue;
                        Slot s2 = (Slot)o;
                        int slotX = gui.field_147003_i + s2.field_75223_e;
                        int slotY = gui.field_147009_r + s2.field_75221_f;
                        if (mx < slotX || mx >= slotX + 16 || my < slotY || my >= slotY + 16) continue;
                        hovered = s2;
                        break;
                    }
                }
                if (hovered != null && hovered.func_75216_d()) {
                    relevantItem = hovered.func_75211_c();
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (relevantItem == null) {
            relevantItem = mc.field_71439_g.func_70694_bm();
        }
        if (relevantItem != null && relevantItem.func_77942_o()) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            NBTTagCompound nbt = relevantItem.serializeNBT();
            try {
                CompressedStreamTools.func_74799_a((NBTTagCompound)nbt, (OutputStream)baos);
                String item = Base64.getEncoder().encodeToString(baos.toByteArray());
                toAppend = "|" + item;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            System.out.println("No NBT data found for the selected or hovered item.");
        }
        return toAppend;
    }

    @SubscribeEvent
    public void onDimensionLoad(WorldEvent.Load event) {
        WSCommandHandler.highlightCoordinates = new int[0][];
    }

    @SideOnly(value=Side.CLIENT)
    public void DrawOntoGUI(RenderGameOverlayEvent rgoe) {
        if (rgoe.type == RenderGameOverlayEvent.ElementType.CROSSHAIRS) {
            Minecraft mc = Minecraft.func_71410_x();
            mc.field_71456_v.func_73731_b(Minecraft.func_71410_x().field_71466_p, "Flips in Pipeline:" + CoflCore.flipHandler.fds.CurrentFlips(), 0, 0, Integer.MAX_VALUE);
        }
    }

    public static void AddHotKeys(HotkeyRegister[] keys) {
        int i;
        int defaultHotkeyCount = 3;
        HashMap<String, Integer> keyMap = new HashMap<String, Integer>();
        for (i = 0; i < SkyCofl.keyBindings.length; ++i) {
            keyMap.put(SkyCofl.keyBindings[i].func_151464_g(), i);
        }
        SkyCofl.keyBindings = Arrays.copyOf(SkyCofl.keyBindings, defaultHotkeyCount + keys.length);
        for (i = 0; i < keys.length; ++i) {
            int key = Keyboard.getKeyIndex((String)keys[i].DefaultKey.toUpperCase());
            if (keyMap.containsKey(keys[i].Name)) continue;
            SkyCofl.keyBindings[i + defaultHotkeyCount] = new KeyBinding(keys[i].Name, key, "SkyCofl (unchangeable)");
            System.out.println("Registered Key: " + keys[i].Name + " with key " + key);
            ClientRegistry.registerKeyBinding((KeyBinding)SkyCofl.keyBindings[i + defaultHotkeyCount]);
        }
    }

    public static String ExtractUuidFromInventory(IInventory inventory) {
        ItemStack stack = inventory.func_70301_a(13);
        if (stack != null) {
            try {
                String uuid = stack.serializeNBT().func_74775_l("tag").func_74775_l("ExtraAttributes").func_74779_i("uuid");
                if (uuid.length() == 0) {
                    throw new Exception();
                }
                return uuid;
            }
            catch (Exception e) {
                System.out.println("Clicked item " + stack.func_82833_r() + " has the following meta: " + stack.serializeNBT());
            }
        }
        return "";
    }

    @SubscribeEvent
    public void HandleChatEvent(ClientChatReceivedEvent sce) {
        CoflCore.handlers.EventRegistry.onChatMessage(sce.message.func_150260_c());
        String previousHover = null;
        for (IChatComponent component : sce.message.func_150253_a()) {
            String text;
            if (component.func_150256_b().func_150210_i() == null || component.func_150256_b().func_150210_i().func_150701_a() != HoverEvent.Action.SHOW_TEXT || (text = component.func_150256_b().func_150210_i().func_150702_b().func_150260_c()).equals(previousHover)) continue;
            previousHover = text;
            CoflCore.handlers.EventRegistry.onChatMessage(text);
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void OnGuiClick(GuiScreenEvent.MouseInputEvent mie) {
        ItemStack heldItem;
        String chestName;
        if (!CoflCore.Wrapper.isRunning) {
            return;
        }
        if (!(mie.gui instanceof GuiChest)) {
            return;
        }
        if (!(((GuiChest)mie.gui).field_147002_h instanceof ContainerChest)) {
            return;
        }
        ContainerChest chest = (ContainerChest)((GuiChest)mie.gui).field_147002_h;
        IInventory inv = chest.func_85151_d();
        if (inv.func_145818_k_() && (chestName = inv.func_70005_c_()).equalsIgnoreCase("BIN Auction View") && (heldItem = Minecraft.func_71410_x().field_71439_g.field_71071_by.func_70445_o()) != null) {
            System.out.println("Clicked on: " + heldItem.func_77973_b().getRegistryName());
            String itemUUID = EventRegistry.ExtractUuidFromInventory(inv);
            if (System.currentTimeMillis() > lastStartTime && heldItem.func_77969_a(GOLD_NUGGET)) {
                AuctionData ad = new AuctionData();
                ad.setItemId(itemUUID);
                if (LastViewAuctionInvocation + 60000L >= System.currentTimeMillis()) {
                    ad.setAuctionId(LastViewAuctionUUID);
                } else {
                    ad.setAuctionId("");
                }
                Command<AuctionData> data = new Command<AuctionData>(CommandType.PurchaseStart, ad);
                CoflCore.Wrapper.SendMessage(data);
                System.out.println("PurchaseStart");
                last = Pair.of((Object)"You claimed ", (Object)Pair.of((Object)itemUUID, (Object)LocalDateTime.now()));
                lastStartTime = System.currentTimeMillis() + 200L;
            }
        }
    }

    @SubscribeEvent
    public void OnRenderTick(TickEvent.RenderTickEvent event) {
        CountdownTimer.onRenderTick(event);
    }

    @SubscribeEvent
    public void highlightChests(DrawBlockHighlightEvent e) {
        if (WSCommandHandler.highlightCoordinates.length > 0) {
            RenderUtils.renderWaypointHighlightBoxes(WSCommandHandler.highlightCoordinates);
        }
    }

    @SubscribeEvent
    public void onGuiDraw(GuiScreenEvent.DrawScreenEvent.Post event) {
        Minecraft mc = Minecraft.func_71410_x();
        if (event.gui instanceof GuiContainer) {
            DescriptionHandler.DescModification[] toDisplay;
            if (isDragging) {
                int mouseX = Mouse.getX() * event.gui.field_146294_l / Minecraft.func_71410_x().field_71443_c;
                int mouseY = event.gui.field_146295_m - Mouse.getY() * event.gui.field_146295_m / Minecraft.func_71410_x().field_71440_d - 1;
                int deltaX = mouseX - dragStartX;
                int deltaY = mouseY - dragStartY;
                textOffsetX = deltaX;
                textOffsetY = deltaY;
            }
            if ((toDisplay = DescriptionHandler.getInfoDisplay()).length == 0) {
                clickableAreas.clear();
                return;
            }
            GuiContainer inventoryGui = (GuiContainer)event.gui;
            FontRenderer fontRenderer = mc.field_71466_p;
            int inventoryGuiLeft = inventoryGui.field_147003_i;
            int inventoryGuiTop = inventoryGui.field_147009_r;
            ArrayList<String> lines = new ArrayList<String>();
            ArrayList<List<ClickableTextElement>> clickableLines = new ArrayList<List<ClickableTextElement>>();
            int maxWidth = 0;
            for (DescriptionHandler.DescModification mod : toDisplay) {
                int width;
                if (mod == null || mod.value == null) continue;
                if (mod.type.equals("APPEND")) {
                    List<ClickableTextElement> clickableElements = this.parseClickableText(mod.value);
                    if (clickableElements != null && !clickableElements.isEmpty()) {
                        int totalWidth = 0;
                        for (ClickableTextElement element : clickableElements) {
                            if (element.getText() == null) continue;
                            totalWidth += fontRenderer.func_78256_a(element.getText());
                        }
                        lines.add("");
                        clickableLines.add(clickableElements);
                        if (totalWidth <= maxWidth) continue;
                        maxWidth = totalWidth;
                        continue;
                    }
                    lines.add(mod.value);
                    clickableLines.add(null);
                    width = fontRenderer.func_78256_a(mod.value);
                    if (width <= maxWidth) continue;
                    maxWidth = width;
                    continue;
                }
                if (!mod.type.equals("SUGGEST")) continue;
                String displayText = "\u00a77Will suggest: \u00a7r" + mod.value.split(": ")[1];
                lines.add(displayText);
                clickableLines.add(null);
                width = fontRenderer.func_78256_a(displayText);
                if (width <= maxWidth) continue;
                maxWidth = width;
            }
            int defaultTextX = inventoryGuiLeft - 5;
            int defaultTextY = inventoryGuiTop + 5;
            if (inventoryGui instanceof GuiInventory) {
                defaultTextY += 35;
            }
            if (WSCommandHandler.isModListed("notenoughupdates")) {
                defaultTextX -= 23;
            }
            int textX = defaultTextX + textOffsetX;
            if (textOffsetX <= 0) {
                textX -= maxWidth;
            }
            int textY = defaultTextY + textOffsetY;
            GlStateManager.func_179094_E();
            GlStateManager.func_179147_l();
            GlStateManager.func_179112_b((int)770, (int)771);
            int lineCount = lines.size();
            int textHeight = lineCount * (fontRenderer.field_78288_b + 2);
            int mouseX = Mouse.getX() * event.gui.field_146294_l / Minecraft.func_71410_x().field_71443_c;
            int mouseY = event.gui.field_146295_m - Mouse.getY() * event.gui.field_146295_m / Minecraft.func_71410_x().field_71440_d - 1;
            boolean isMouseOverText = this.isMouseOverTextArea(mouseX, mouseY, textX, textY, maxWidth, textHeight);
            for (int i = 0; i < lines.size(); ++i) {
                String line = (String)lines.get(i);
                List clickableElements = (List)clickableLines.get(i);
                int currentY = textY + (fontRenderer.field_78288_b + 2) * i;
                if (clickableElements != null && !clickableElements.isEmpty()) {
                    this.renderClickableTextLine(clickableElements, textX, currentY, fontRenderer, event);
                    continue;
                }
                if (line == null || line.isEmpty()) continue;
                fontRenderer.func_175065_a(line, (float)textX, (float)currentY, -1, true);
            }
            GlStateManager.func_179084_k();
            GlStateManager.func_179121_F();
            if (currentHoverText != null && !currentHoverText.isEmpty()) {
                String[] tooltipLineArray = currentHoverText.split("\\n");
                List<String> tooltipLines = Arrays.asList(tooltipLineArray);
                this.drawHoverTooltip(tooltipLines, hoverX, hoverY, event.gui.field_146294_l, event.gui.field_146295_m);
            }
        }
        currentHoverText = null;
    }

    private List<ClickableTextElement> parseClickableText(String value) {
        if (value == null || value.trim().isEmpty()) {
            return null;
        }
        String trimmed = value.trim();
        if (!trimmed.startsWith("[") || !trimmed.endsWith("]")) {
            return null;
        }
        try {
            Gson gson = new Gson();
            Type listType = new TypeToken<List<ClickableTextElement>>(){}.getType();
            return (List)gson.fromJson(value, listType);
        }
        catch (Exception e) {
            return null;
        }
    }

    private void renderClickableTextLine(List<ClickableTextElement> elements, int startX, int y, FontRenderer fontRenderer, GuiScreenEvent.DrawScreenEvent.Post event) {
        int currentX = startX;
        for (ClickableTextElement element : elements) {
            if (element.getText() == null || element.getText().isEmpty()) continue;
            String text = element.getText();
            int textWidth = fontRenderer.func_78256_a(text);
            int mouseX = Mouse.getX() * event.gui.field_146294_l / Minecraft.func_71410_x().field_71443_c;
            int mouseY = event.gui.field_146295_m - Mouse.getY() * event.gui.field_146295_m / Minecraft.func_71410_x().field_71440_d - 1;
            boolean isHovered = mouseX >= currentX && mouseX <= currentX + textWidth && mouseY >= y && mouseY <= y + fontRenderer.field_78288_b;
            int color = -1;
            if (element.getOnClick() != null && !element.getOnClick().isEmpty()) {
                color = isHovered ? -256 : -11141121;
            }
            fontRenderer.func_175065_a(text, (float)currentX, (float)y, color, true);
            if (isHovered && element.getOnClick() != null && !element.getOnClick().isEmpty()) {
                Gui.func_73734_a((int)currentX, (int)(y + fontRenderer.field_78288_b), (int)(currentX + textWidth), (int)(y + fontRenderer.field_78288_b + 1), (int)-256);
            }
            if (element.getOnClick() != null && !element.getOnClick().isEmpty()) {
                this.storeClickableArea(currentX, y, textWidth, fontRenderer.field_78288_b, element.getOnClick());
            }
            if (element.getHover() != null && !element.getHover().isEmpty()) {
                this.storeHoverArea(currentX, y, textWidth, fontRenderer.field_78288_b, element.getHover(), isHovered);
            }
            currentX += textWidth;
        }
    }

    private void storeClickableArea(int x, int y, int width, int height, String command) {
        clickableAreas.add(new ClickableArea(x, y, width, height, command));
    }

    private void storeHoverArea(int x, int y, int width, int height, String hoverText, boolean isHovered) {
        if (isHovered) {
            currentHoverText = hoverText;
            hoverX = x + width / 2;
            hoverY = y;
        }
    }

    private boolean isMouseOverTextArea(int mouseX, int mouseY, int textX, int textY, int textWidth, int textHeight) {
        return mouseX >= textX && mouseX <= textX + textWidth && mouseY >= textY && mouseY <= textY + textHeight;
    }

    @SubscribeEvent
    public void onInfoDisplayMouseClick(GuiScreenEvent.MouseInputEvent.Pre event) {
        if (!(event.gui instanceof GuiContainer)) {
            return;
        }
        int mouseX = Mouse.getX() * event.gui.field_146294_l / Minecraft.func_71410_x().field_71443_c;
        int mouseY = event.gui.field_146295_m - Mouse.getY() * event.gui.field_146295_m / Minecraft.func_71410_x().field_71440_d - 1;
        if (Mouse.getEventButtonState() && Mouse.getEventButton() == 0) {
            for (ClickableArea area : clickableAreas) {
                if (!area.contains(mouseX, mouseY)) continue;
                this.handleClickableTextClick(area.command);
                event.setCanceled(true);
                return;
            }
        }
        if (Mouse.getEventButton() == 1) {
            if (Mouse.getEventButtonState()) {
                DescriptionHandler.DescModification[] toDisplay = DescriptionHandler.getInfoDisplay();
                if (toDisplay.length > 0) {
                    int textHeight;
                    int textY;
                    GuiContainer inventoryGui = (GuiContainer)event.gui;
                    FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
                    int maxWidth = 0;
                    int lineCount = 0;
                    for (DescriptionHandler.DescModification mod : toDisplay) {
                        if (mod == null || mod.value == null || !mod.type.equals("APPEND") && !mod.type.equals("SUGGEST")) continue;
                        ++lineCount;
                        String displayText = mod.type.equals("SUGGEST") ? "\u00a77Will suggest: \u00a7r" + mod.value.split(": ")[1] : mod.value;
                        List<ClickableTextElement> clickableElements = this.parseClickableText(mod.value);
                        if (clickableElements != null && !clickableElements.isEmpty()) {
                            int totalWidth = 0;
                            for (ClickableTextElement element : clickableElements) {
                                if (element.getText() == null) continue;
                                totalWidth += fontRenderer.func_78256_a(element.getText());
                            }
                            if (totalWidth <= maxWidth) continue;
                            maxWidth = totalWidth;
                            continue;
                        }
                        int width = fontRenderer.func_78256_a(displayText);
                        if (width <= maxWidth) continue;
                        maxWidth = width;
                    }
                    int defaultTextX = inventoryGui.field_147003_i - 5;
                    int defaultTextY = inventoryGui.field_147009_r + 5;
                    if (inventoryGui instanceof GuiInventory) {
                        defaultTextY += 30;
                    }
                    int textX = defaultTextX + textOffsetX;
                    if (textOffsetX <= 0) {
                        textX -= maxWidth;
                    }
                    if (this.isMouseOverTextArea(mouseX, mouseY, textX, textY = defaultTextY + textOffsetY, maxWidth, textHeight = lineCount * (fontRenderer.field_78288_b + 2))) {
                        isDragging = true;
                        dragStartX = mouseX;
                        dragStartY = mouseY;
                        event.setCanceled(true);
                    }
                }
            } else if (isDragging) {
                isDragging = false;
                InfoDisplayConfig.setTextOffset(textOffsetX, textOffsetY);
                event.setCanceled(true);
            }
        }
    }

    public static void resetTextPosition() {
        textOffsetX = 0;
        textOffsetY = 0;
        isDragging = false;
        InfoDisplayConfig.resetTextOffset();
    }

    public static int[] getTextOffset() {
        return new int[]{textOffsetX, textOffsetY};
    }

    public static void setTextOffset(int offsetX, int offsetY) {
        textOffsetX = offsetX;
        textOffsetY = offsetY;
        InfoDisplayConfig.setTextOffset(offsetX, offsetY);
    }

    private void handleClickableTextClick(String command) {
        System.err.println("Clicked command: " + command);
        if (command == null || command.isEmpty()) {
            return;
        }
        try {
            WSCommandHandler.Execute(command, (Entity)Minecraft.func_71410_x().field_71439_g);
        }
        catch (Exception e) {
            System.err.println("Failed to execute clickable text command: " + command);
            e.printStackTrace();
        }
    }

    private void drawHoverTooltip(List<String> lines, int x, int y, int screenWidth, int screenHeight) {
        if (lines.isEmpty()) {
            return;
        }
        FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
        int maxWidth = 0;
        for (String line : lines) {
            int width = fontRenderer.func_78256_a(line);
            if (width <= maxWidth) continue;
            maxWidth = width;
        }
        int tooltipHeight = 8;
        if (lines.size() > 1) {
            tooltipHeight += (lines.size() - 1) * 10;
        }
        int tooltipX = x + 12;
        int tooltipY = y - 12;
        if (tooltipX + maxWidth + 4 > screenWidth) {
            tooltipX = x - maxWidth - 16;
        }
        if (tooltipY + tooltipHeight + 6 > screenHeight) {
            tooltipY = screenHeight - tooltipHeight - 6;
        }
        if (tooltipY < 4) {
            tooltipY = 4;
        }
        if (tooltipX < 4) {
            tooltipX = 4;
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_179140_f();
        GlStateManager.func_179097_i();
        GlStateManager.func_179147_l();
        GlStateManager.func_179112_b((int)770, (int)771);
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)300.0f);
        int backgroundColor = -267386864;
        int borderColorStart = 0x505000FF;
        int borderColorEnd = 1344798847;
        Gui.func_73734_a((int)(tooltipX - 3), (int)(tooltipY - 4), (int)(tooltipX + maxWidth + 3), (int)(tooltipY - 3), (int)-267386864);
        Gui.func_73734_a((int)(tooltipX - 3), (int)(tooltipY + tooltipHeight + 3), (int)(tooltipX + maxWidth + 3), (int)(tooltipY + tooltipHeight + 4), (int)-267386864);
        Gui.func_73734_a((int)(tooltipX - 3), (int)(tooltipY - 3), (int)(tooltipX + maxWidth + 3), (int)(tooltipY + tooltipHeight + 3), (int)-267386864);
        Gui.func_73734_a((int)(tooltipX - 4), (int)(tooltipY - 3), (int)(tooltipX - 3), (int)(tooltipY + tooltipHeight + 3), (int)-267386864);
        Gui.func_73734_a((int)(tooltipX + maxWidth + 3), (int)(tooltipY - 3), (int)(tooltipX + maxWidth + 4), (int)(tooltipY + tooltipHeight + 3), (int)-267386864);
        Gui.func_73734_a((int)(tooltipX - 3), (int)(tooltipY - 3 + 1), (int)(tooltipX - 3 + 1), (int)(tooltipY + tooltipHeight + 3 - 1), (int)0x505000FF);
        Gui.func_73734_a((int)(tooltipX + maxWidth + 2), (int)(tooltipY - 3 + 1), (int)(tooltipX + maxWidth + 3), (int)(tooltipY + tooltipHeight + 3 - 1), (int)1344798847);
        Gui.func_73734_a((int)(tooltipX - 3), (int)(tooltipY - 3), (int)(tooltipX + maxWidth + 3), (int)(tooltipY - 3 + 1), (int)0x505000FF);
        Gui.func_73734_a((int)(tooltipX - 3), (int)(tooltipY + tooltipHeight + 2), (int)(tooltipX + maxWidth + 3), (int)(tooltipY + tooltipHeight + 3), (int)1344798847);
        int currentTooltipY = tooltipY;
        for (int lineNumber = 0; lineNumber < lines.size(); ++lineNumber) {
            String line = lines.get(lineNumber);
            fontRenderer.func_175063_a(line, (float)tooltipX, (float)currentTooltipY, -1);
            currentTooltipY += 10;
        }
        GlStateManager.func_179084_k();
        GlStateManager.func_179126_j();
        GlStateManager.func_179145_e();
        GlStateManager.func_179121_F();
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void onTick(TickEvent.ClientTickEvent event) {
        ++this.UpdateThisTick;
        if (this.UpdateThisTick % 200L == 0L) {
            this.tickThreadPool.submit(() -> {
                try {
                    EventHandler.ScoreboardData();
                    EventHandler.TabMenuData();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            });
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onGuiOpen(GuiOpenEvent event) {
        if (event.gui == null) {
            CoflCore.flipHandler.lastClickedFlipMessage = "";
        }
        if (event.gui instanceof GuiEditSign) {
            DescriptionHandler.DescModification[] toDisplay;
            GuiEditSign signGui = (GuiEditSign)event.gui;
            for (DescriptionHandler.DescModification mod : toDisplay = DescriptionHandler.getInfoDisplay()) {
                if (mod == null || !mod.type.equals("SUGGEST")) continue;
                String[] parts = mod.value.split(": ");
                if (parts.length < 2) {
                    return;
                }
                try {
                    TileEntitySign tileEntitySign = ((AccessorGuiEditSign)signGui).getTileSign();
                    if (!tileEntitySign.field_145915_a[3].func_150260_c().contains(parts[0])) continue;
                    tileEntitySign.field_145915_a[0] = new ChatComponentText(parts[1]);
                }
                catch (RuntimeException e) {
                    System.err.println("Failed to access tileSign field in GuiEditSign: " + e.getMessage());
                    e.printStackTrace();
                }
            }
            return;
        }
        if (!CoflCore.config.extendedtooltips) {
            return;
        }
        if (this.forgeDescriptionHandler != null) {
            this.forgeDescriptionHandler.Close();
        }
        if (event.gui == null) {
            DescriptionHandler.emptyTooltipData();
        }
        if (!(event.gui instanceof GuiContainer)) {
            return;
        }
        new Thread(() -> {
            try {
                this.forgeDescriptionHandler = new ForgeDescriptionHandler();
                this.forgeDescriptionHandler.loadDescriptionAndListenForChanges(event);
            }
            catch (Exception e) {
                System.err.println("failed to update description: " + e + " | gui=" + (event == null ? "null" : event.gui));
                e.printStackTrace();
            }
        }).start();
    }

    @SubscribeEvent
    public void onBackgroundRenderDone(GuiScreenEvent.BackgroundDrawnEvent event) {
        if (this.forgeDescriptionHandler != null) {
            this.forgeDescriptionHandler.highlightSlots(event);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onItemTooltipEvent(ItemTooltipEvent event) {
        if (!CoflCore.config.extendedtooltips) {
            return;
        }
        if (this.forgeDescriptionHandler == null) {
            return;
        }
        this.forgeDescriptionHandler.setTooltips(event);
    }

    static {
        GOLD_NUGGET = new ItemStack((Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation("minecraft:gold_nugget")));
        EMPTY = Pair.of(null, (Object)Pair.of((Object)"", (Object)LocalDateTime.MIN));
        last = EMPTY;
        lastStartTime = Long.MIN_VALUE;
        LastViewAuctionInvocation = Long.MIN_VALUE;
        LastViewAuctionUUID = null;
        clickableAreas = new ArrayList<ClickableArea>();
        currentHoverText = null;
        hoverX = 0;
        hoverY = 0;
        isDragging = false;
        dragStartX = 0;
        dragStartY = 0;
        textOffsetX = InfoDisplayConfig.getTextOffsetX();
        textOffsetY = InfoDisplayConfig.getTextOffsetY();
    }

    private static class ClickableArea {
        public int x;
        public int y;
        public int width;
        public int height;
        public String command;

        public ClickableArea(int x, int y, int width, int height, String command) {
            this.x = x;
            this.y = y;
            this.width = width;
            this.height = height;
            this.command = command;
        }

        public boolean contains(int mouseX, int mouseY) {
            return mouseX >= this.x && mouseX <= this.x + this.width && mouseY >= this.y && mouseY <= this.y + this.height;
        }
    }
}

