/*
 * Decompiled with CFR 0.152.
 */
package com.coflnet.sky.handlers;

import com.coflnet.sky.config.SellProtectionConfig;
import com.coflnet.sky.utils.ChatUtils;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.inventory.GuiChest;
import net.minecraft.inventory.ContainerChest;
import net.minecraft.inventory.IInventory;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class SellProtectionTooltipHandler {
    private static final Pattern CLEAN_SELL_INSTANTLY_PATTERN = Pattern.compile("Total: ([0-9,\\.]+) coins");
    private static final Pattern CLEAN_SELL_INVENTORY_PATTERN = Pattern.compile("You earn: ([0-9,\\.]+) coins");
    private static final Pattern CLEAN_SELL_SACKS_PATTERN = Pattern.compile("You earn: ([0-9,\\.]+) coins");
    private static final Pattern SELL_INSTANTLY_PATTERN = Pattern.compile("Total: \u00a76([0-9,\\.]+) coins");
    private static final Pattern SELL_INVENTORY_PATTERN = Pattern.compile("You earn: \u00a76([0-9,\\.]+) coins");
    private static final Pattern SELL_SACKS_PATTERN = Pattern.compile("You earn: \u00a76([0-9,\\.]+) coins");

    @SubscribeEvent(priority=EventPriority.LOW)
    public void onItemTooltip(ItemTooltipEvent event) {
        long threshold;
        long sellAmount;
        boolean isSellItem;
        if (!SellProtectionConfig.isEnabled()) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71462_r == null || !(mc.field_71462_r instanceof GuiChest)) {
            return;
        }
        GuiChest chestGui = (GuiChest)mc.field_71462_r;
        ContainerChest container = (ContainerChest)chestGui.field_147002_h;
        IInventory inventory = container.func_85151_d();
        if (!inventory.func_145818_k_()) {
            return;
        }
        String chestName = inventory.func_145748_c_().func_150260_c();
        if (!chestName.contains("\u279c")) {
            return;
        }
        String itemName = event.itemStack.func_82833_r();
        String cleanItemName = ChatUtils.cleanColour(itemName);
        boolean bl = isSellItem = cleanItemName.contains("Sell Instantly") || cleanItemName.contains("Sell Sacks Now") || cleanItemName.contains("Sell Inventory Now");
        if (isSellItem && (sellAmount = this.parseSellAmountFromTooltip(event.toolTip)) >= (threshold = SellProtectionConfig.getSellProtectionThreshold())) {
            String formattedThreshold = SellProtectionConfig.formatThreshold(threshold);
            event.toolTip.add("");
            event.toolTip.add("\u00a7c\u26a0 \u00a7lSell Protection \u00a7c\u26a0");
            event.toolTip.add("\u00a77All clicks blocked if > \u00a76" + formattedThreshold + " coins");
            event.toolTip.add("\u00a7bHold Ctrl\u00a77 to override.");
            event.toolTip.add("\u00a78/cofl set sellProtectionThreshold <amount>");
        }
    }

    private long parseSellAmountFromTooltip(List<String> tooltip) {
        for (String line : tooltip) {
            String cleanLine = ChatUtils.cleanColour(line);
            Matcher matcher = CLEAN_SELL_INSTANTLY_PATTERN.matcher(cleanLine);
            if (matcher.find()) {
                return this.parseCoins(matcher.group(1));
            }
            matcher = CLEAN_SELL_INVENTORY_PATTERN.matcher(cleanLine);
            if (matcher.find()) {
                return this.parseCoins(matcher.group(1));
            }
            matcher = CLEAN_SELL_SACKS_PATTERN.matcher(cleanLine);
            if (matcher.find()) {
                return this.parseCoins(matcher.group(1));
            }
            matcher = SELL_INSTANTLY_PATTERN.matcher(line);
            if (matcher.find()) {
                return this.parseCoins(matcher.group(1));
            }
            matcher = SELL_INVENTORY_PATTERN.matcher(line);
            if (matcher.find()) {
                return this.parseCoins(matcher.group(1));
            }
            matcher = SELL_SACKS_PATTERN.matcher(line);
            if (!matcher.find()) continue;
            return this.parseCoins(matcher.group(1));
        }
        return 0L;
    }

    private long parseCoins(String coinStr) {
        try {
            String cleaned = coinStr.replace(",", "");
            if (cleaned.contains(".")) {
                double value = Double.parseDouble(cleaned);
                return (long)value;
            }
            return Long.parseLong(cleaned);
        }
        catch (NumberFormatException e) {
            return 0L;
        }
    }
}

