/*
 * Decompiled with CFR 0.152.
 */
package com.coflnet.sky.listeners;

import com.coflnet.sky.config.SellProtectionConfig;
import com.coflnet.sky.utils.ChatUtils;
import java.lang.reflect.Method;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiChest;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ContainerChest;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;

public class SellProtectionListener {
    private static final Pattern CLEAN_SELL_INSTANTLY_PATTERN = Pattern.compile("Total: ([0-9,\\.]+) coins");
    private static final Pattern CLEAN_SELL_INVENTORY_PATTERN = Pattern.compile("You earn: ([0-9,\\.]+) coins");
    private static final Pattern CLEAN_SELL_SACKS_PATTERN = Pattern.compile("You earn: ([0-9,\\.]+) coins");
    private static final Pattern SELL_INSTANTLY_PATTERN = Pattern.compile("Total: \u00a76([0-9,\\.]+) coins");
    private static final Pattern SELL_INVENTORY_PATTERN = Pattern.compile("You earn: \u00a76([0-9,\\.]+) coins");
    private static final Pattern SELL_SACKS_PATTERN = Pattern.compile("You earn: \u00a76([0-9,\\.]+) coins");

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onInventoryClick(GuiScreenEvent.MouseInputEvent.Pre event) {
        long threshold;
        long sellAmount;
        int mouseY;
        if (!SellProtectionConfig.isEnabled()) {
            return;
        }
        if (!Mouse.getEventButtonState()) {
            return;
        }
        GuiScreen gui = event.gui;
        if (!(gui instanceof GuiChest)) {
            return;
        }
        GuiChest chestGui = (GuiChest)gui;
        ContainerChest container = (ContainerChest)chestGui.field_147002_h;
        IInventory inventory = container.func_85151_d();
        if (!inventory.func_145818_k_()) {
            return;
        }
        String chestName = inventory.func_145748_c_().func_150260_c();
        if (!chestName.contains("\u279c")) {
            return;
        }
        boolean ctrlPressed = Keyboard.isKeyDown((int)29) || Keyboard.isKeyDown((int)157);
        int mouseX = Mouse.getX() * gui.field_146294_l / Minecraft.func_71410_x().field_71443_c;
        Slot hoveredSlot = this.getHoveredSlot(chestGui, mouseX, mouseY = gui.field_146295_m - Mouse.getY() * gui.field_146295_m / Minecraft.func_71410_x().field_71440_d - 1);
        if (hoveredSlot == null || !hoveredSlot.func_75216_d()) {
            return;
        }
        ItemStack hoveredItem = hoveredSlot.func_75211_c();
        String itemName = hoveredItem.func_82833_r();
        String cleanItemName = ChatUtils.cleanColour(itemName);
        boolean shouldProtect = false;
        int mouseButton = Mouse.getEventButton();
        if (cleanItemName.contains("Sell Instantly")) {
            if (mouseButton == 0 && !ctrlPressed) {
                shouldProtect = true;
            }
        } else if ((cleanItemName.contains("Sell Sacks Now") || cleanItemName.contains("Sell Inventory Now")) && !ctrlPressed) {
            shouldProtect = true;
        }
        if (shouldProtect && (sellAmount = this.parseSellAmount(hoveredItem)) >= (threshold = SellProtectionConfig.getSellProtectionThreshold())) {
            event.setCanceled(true);
            String formattedAmount = SellProtectionConfig.formatThreshold(sellAmount);
            String warningMessage = String.format("\u00a7c\u26a0 \u00a7lSell Protection \u00a7c\u26a0 \u00a77Blocked sale of \u00a76%s coins\u00a77! Hold \u00a7bCtrl\u00a77 to override.", formattedAmount);
            Minecraft.func_71410_x().field_71439_g.func_145747_a((IChatComponent)new ChatComponentText(warningMessage));
            return;
        }
    }

    private Slot getHoveredSlot(GuiChest gui, int mouseX, int mouseY) {
        try {
            Method getSlotAtPosition = GuiChest.class.getMethod("getSlotAtPosition", Integer.TYPE, Integer.TYPE);
            Object result = getSlotAtPosition.invoke((Object)gui, mouseX, mouseY);
            if (result instanceof Slot) {
                return (Slot)result;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        for (Object obj : gui.field_147002_h.field_75151_b) {
            if (!(obj instanceof Slot)) continue;
            Slot slot = (Slot)obj;
            int slotX = gui.field_147003_i + slot.field_75223_e;
            int slotY = gui.field_147009_r + slot.field_75221_f;
            if (mouseX < slotX || mouseX >= slotX + 16 || mouseY < slotY || mouseY >= slotY + 16) continue;
            return slot;
        }
        return null;
    }

    private long parseSellAmount(ItemStack item) {
        List lore = item.func_82840_a((EntityPlayer)Minecraft.func_71410_x().field_71439_g, false);
        for (String line : lore) {
            String cleanLine = ChatUtils.cleanColour(line);
            Matcher matcher = CLEAN_SELL_INSTANTLY_PATTERN.matcher(cleanLine);
            if (matcher.find()) {
                return this.parseCoins(matcher.group(1));
            }
            matcher = CLEAN_SELL_INVENTORY_PATTERN.matcher(cleanLine);
            if (matcher.find()) {
                return this.parseCoins(matcher.group(1));
            }
            matcher = CLEAN_SELL_SACKS_PATTERN.matcher(cleanLine);
            if (matcher.find()) {
                return this.parseCoins(matcher.group(1));
            }
            matcher = SELL_INSTANTLY_PATTERN.matcher(line);
            if (matcher.find()) {
                return this.parseCoins(matcher.group(1));
            }
            matcher = SELL_INVENTORY_PATTERN.matcher(line);
            if (matcher.find()) {
                return this.parseCoins(matcher.group(1));
            }
            matcher = SELL_SACKS_PATTERN.matcher(line);
            if (!matcher.find()) continue;
            return this.parseCoins(matcher.group(1));
        }
        return SellProtectionConfig.getSellProtectionThreshold();
    }

    private long parseCoins(String coinStr) {
        try {
            String cleaned = coinStr.replace(",", "");
            if (cleaned.contains(".")) {
                double value = Double.parseDouble(cleaned);
                return (long)value;
            }
            return Long.parseLong(cleaned);
        }
        catch (NumberFormatException e) {
            return SellProtectionConfig.getSellProtectionThreshold();
        }
    }
}

