/*
 * Decompiled with CFR 0.152.
 */
package com.coflnet.sky.test;

import com.coflnet.sky.models.ClickableTextElement;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.util.ArrayList;
import java.util.List;

public class ClickableTextTestUtil {
    public static void main(String[] args) {
        ClickableTextTestUtil.testClickableTextGeneration();
    }

    public static void testClickableTextGeneration() {
        ArrayList<ClickableTextElement> elements = new ArrayList<ClickableTextElement>();
        ClickableTextElement element1 = new ClickableTextElement();
        element1.setText("Test Text");
        element1.setHover("Test hover\n\u00a7bline 2");
        element1.setOnClick("/cofl help");
        elements.add(element1);
        ClickableTextElement element2 = new ClickableTextElement();
        element2.setText(" O");
        element2.setHover("Test hover");
        element2.setOnClick("/cofl dialog echo hi");
        elements.add(element2);
        Gson gson = new Gson();
        String json = gson.toJson(elements);
        System.out.println("Generated JSON for clickable text:");
        System.out.println(json);
        System.out.println("\nTesting parsing back:");
        try {
            TypeToken<List<ClickableTextElement>> typeToken = new TypeToken<List<ClickableTextElement>>(){};
            List parsed = (List)gson.fromJson(json, typeToken.getType());
            for (int i = 0; i < parsed.size(); ++i) {
                ClickableTextElement elem = (ClickableTextElement)parsed.get(i);
                System.out.println("Element " + i + ":");
                System.out.println("  Text: " + elem.getText());
                System.out.println("  Hover: " + elem.getHover());
                System.out.println("  OnClick: " + elem.getOnClick());
            }
        }
        catch (Exception e) {
            System.err.println("Error parsing JSON: " + e.getMessage());
        }
    }

    public static String generateSampleJson1() {
        ArrayList<ClickableTextElement> elements = new ArrayList<ClickableTextElement>();
        elements.add(new ClickableTextElement("Click for help", "Opens the help dialog", "/cofl help"));
        return new Gson().toJson(elements);
    }

    public static String generateSampleJson2() {
        ArrayList<ClickableTextElement> elements = new ArrayList<ClickableTextElement>();
        elements.add(new ClickableTextElement("Buy Item", "Click to purchase this item\n\u00a7aCost: 1000 coins", "/cofl buy"));
        elements.add(new ClickableTextElement(" | ", null, null));
        elements.add(new ClickableTextElement("View Auction", "Click to view the auction\n\u00a7eAuction ID: abc123", "/cofl viewauction abc123"));
        return new Gson().toJson(elements);
    }

    public static String generateSampleJson3() {
        ArrayList<ClickableTextElement> elements = new ArrayList<ClickableTextElement>();
        elements.add(new ClickableTextElement("Status: ", null, null));
        elements.add(new ClickableTextElement("Active", "System is running normally\n\u00a7aLast update: Now", "/cofl status"));
        return new Gson().toJson(elements);
    }
}

