/*
 * Decompiled with CFR 0.152.
 */
package com.coflnet.sky.utils;

import com.coflnet.sky.mixins.AccessorGuiEditSign;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiChest;
import net.minecraft.client.gui.inventory.GuiEditSign;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ContainerChest;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntitySign;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.EnumChatFormatting;
import net.minecraftforge.client.event.GuiOpenEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class BazaarSearchUtil {
    private static final Minecraft mc = Minecraft.func_71410_x();
    private static String pendingSearchTerm = null;
    private static boolean isSearching = false;

    public static boolean searchInBazaar(String searchTerm) {
        if (BazaarSearchUtil.mc.field_71439_g == null || BazaarSearchUtil.mc.field_71462_r == null) {
            return false;
        }
        GuiScreen currentGui = BazaarSearchUtil.mc.field_71462_r;
        if (!(currentGui instanceof GuiChest)) {
            return false;
        }
        GuiChest chestGui = (GuiChest)currentGui;
        ContainerChest container = (ContainerChest)chestGui.field_147002_h;
        IInventory inventory = container.func_85151_d();
        if (inventory == null) {
            return false;
        }
        String guiName = inventory.func_145748_c_().func_150260_c().trim();
        if (!BazaarSearchUtil.isBazaarGui(guiName)) {
            return false;
        }
        ItemStack searchItem = BazaarSearchUtil.findSearchItem(container);
        if (searchItem == null) {
            return false;
        }
        int searchSlot = BazaarSearchUtil.findSearchSlot(container);
        if (searchSlot == -1) {
            return false;
        }
        pendingSearchTerm = searchTerm;
        isSearching = true;
        MinecraftForge.EVENT_BUS.register((Object)new BazaarSearchEventHandler());
        BazaarSearchUtil.mc.field_71442_b.func_78753_a(container.field_75152_c, searchSlot, 0, 0, (EntityPlayer)BazaarSearchUtil.mc.field_71439_g);
        return true;
    }

    private static boolean isBazaarGui(String guiName) {
        String lowerName = guiName.toLowerCase();
        return lowerName.contains("bazaar") || lowerName.contains("buy") && lowerName.contains("sell") || lowerName.contains("instant buy") || lowerName.contains("instant sell");
    }

    private static ItemStack findSearchItem(ContainerChest container) {
        IInventory inventory = container.func_85151_d();
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            String cleanName;
            String displayName;
            ItemStack stack = inventory.func_70301_a(i);
            if (stack == null || (displayName = stack.func_82833_r()) == null || !(cleanName = EnumChatFormatting.func_110646_a((String)displayName).toLowerCase()).contains("search") && !cleanName.contains("find") && !cleanName.contains("look up")) continue;
            return stack;
        }
        return null;
    }

    private static int findSearchSlot(ContainerChest container) {
        IInventory inventory = container.func_85151_d();
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            String cleanName;
            ItemStack stack = inventory.func_70301_a(i);
            if (stack == null) continue;
            String displayName = stack.func_82833_r();
            if (displayName != null && ((cleanName = EnumChatFormatting.func_110646_a((String)displayName).toLowerCase()).contains("search") || cleanName.contains("find") || cleanName.contains("look up"))) {
                return i;
            }
            List lore = stack.func_82840_a((EntityPlayer)BazaarSearchUtil.mc.field_71439_g, false);
            for (String line : lore) {
                String cleanLine = EnumChatFormatting.func_110646_a((String)line).toLowerCase();
                if (!cleanLine.contains("search") && !cleanLine.contains("find") && !cleanLine.contains("look up")) continue;
                return i;
            }
        }
        return -1;
    }

    public static boolean isSearching() {
        return isSearching;
    }

    public static String getPendingSearchTerm() {
        return pendingSearchTerm;
    }

    public static void cancelSearch() {
        pendingSearchTerm = null;
        isSearching = false;
    }

    public static class BazaarSearchEventHandler {
        @SubscribeEvent
        public void onGuiOpen(GuiOpenEvent event) {
            if (!isSearching || pendingSearchTerm == null) {
                return;
            }
            if (event.gui instanceof GuiEditSign) {
                GuiEditSign signGui = (GuiEditSign)event.gui;
                try {
                    TileEntitySign tileEntitySign = ((AccessorGuiEditSign)signGui).getTileSign();
                    tileEntitySign.field_145915_a[0] = new ChatComponentText(pendingSearchTerm);
                    mc.func_152344_a(() -> {
                        if (mc.field_71462_r instanceof GuiEditSign) {
                            tileEntitySign.field_145915_a[0] = new ChatComponentText(pendingSearchTerm);
                            mc.field_71439_g.func_71053_j();
                        }
                        this.cleanup();
                    });
                }
                catch (Exception e) {
                    System.err.println("Failed to access tileSign field in GuiEditSign for bazaar search: " + e.getMessage());
                    e.printStackTrace();
                    this.cleanup();
                }
            }
        }

        private void cleanup() {
            pendingSearchTerm = null;
            isSearching = false;
            MinecraftForge.EVENT_BUS.unregister((Object)this);
        }
    }
}

