/*
 * Decompiled with CFR 0.152.
 */
package com.coflnet.utils;

import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_2561;
import net.minecraft.class_310;

@Environment(value=EnvType.CLIENT)
public class SellAmountParser {
    private static final Pattern INVENTORY_SACK_PATTERN = Pattern.compile("You earn: ([0-9,]+(?:\\.[0-9]+)?) coins");
    private static final Pattern SELL_INSTANTLY_PATTERN = Pattern.compile("Total: ([0-9,]+(?:\\.[0-9]+)?) coins");
    private static final long DEFAULT_PROTECTION_AMOUNT = Long.MAX_VALUE;

    public static long extractSellInstantlyAmount(class_1799 item) {
        try {
            List tooltip = item.method_7950(class_1792.class_9635.field_51353, (class_1657)class_310.method_1551().field_1724, (class_1836)class_1836.field_41070);
            return SellAmountParser.extractSellInstantlyAmountFromTooltip(tooltip);
        }
        catch (Exception e) {
            System.out.println("[SellAmountParser] Failed to get tooltip for sell instantly amount: " + e.getMessage());
            return Long.MAX_VALUE;
        }
    }

    public static long extractInventorySackAmount(class_1799 item) {
        try {
            List tooltip = item.method_7950(class_1792.class_9635.field_51353, (class_1657)class_310.method_1551().field_1724, (class_1836)class_1836.field_41070);
            return SellAmountParser.extractInventorySackAmountFromTooltip(tooltip);
        }
        catch (Exception e) {
            System.out.println("[SellAmountParser] Failed to get tooltip for inventory/sack amount: " + e.getMessage());
            return Long.MAX_VALUE;
        }
    }

    public static long extractSellInstantlyAmountFromTooltip(List<class_2561> lines) {
        for (class_2561 line : lines) {
            String lineText = line.getString();
            Matcher matcher = SELL_INSTANTLY_PATTERN.matcher(lineText);
            if (!matcher.find()) continue;
            String amountStr = matcher.group(1).replace(",", "");
            try {
                long amount = (long)Double.parseDouble(amountStr);
                System.out.println("[SellAmountParser] Found sell instantly amount: " + amount + " from text: " + lineText);
                return amount;
            }
            catch (NumberFormatException e) {
                System.out.println("[SellAmountParser] Failed to parse sell instantly amount: " + amountStr);
                return Long.MAX_VALUE;
            }
        }
        System.out.println("[SellAmountParser] No sell instantly amount found, using default protection amount");
        return Long.MAX_VALUE;
    }

    public static long extractInventorySackAmountFromTooltip(List<class_2561> lines) {
        for (class_2561 line : lines) {
            String lineText = line.getString();
            Matcher matcher = INVENTORY_SACK_PATTERN.matcher(lineText);
            if (!matcher.find()) continue;
            String amountStr = matcher.group(1).replace(",", "");
            try {
                long amount = (long)Double.parseDouble(amountStr);
                System.out.println("[SellAmountParser] Found inventory/sack amount: " + amount + " from text: " + lineText);
                return amount;
            }
            catch (NumberFormatException e) {
                System.out.println("[SellAmountParser] Failed to parse inventory/sack amount: " + amountStr);
                return Long.MAX_VALUE;
            }
        }
        System.out.println("[SellAmountParser] No inventory/sack amount found, using default protection amount");
        return Long.MAX_VALUE;
    }

    public static long getDefaultProtectionAmount() {
        return Long.MAX_VALUE;
    }
}

