/*
 * Decompiled with CFR 0.152.
 */
package com.coflnet.mixin;

import com.coflnet.config.SellProtectionManager;
import com.coflnet.utils.SellAmountParser;
import java.util.Locale;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_11909;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_465;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.glfw.GLFW;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Environment(value=EnvType.CLIENT)
@Mixin(value={class_465.class})
public abstract class SellProtectionMixin {
    @Shadow
    @Nullable
    protected class_1735 field_2787;

    @Shadow
    @Nullable
    public abstract class_1735 method_64240(double var1, double var3);

    @Inject(method={"mouseClicked"}, at={@At(value="HEAD")}, cancellable=true)
    private void onSellProtectionMouseClicked(class_11909 click, boolean doubleClick, CallbackInfoReturnable<Boolean> cir) {
        try {
            double mouseY;
            if (!SellProtectionManager.isEnabled()) {
                return;
            }
            int button = click.method_74245();
            if (button != 0 && button != 1) {
                return;
            }
            String screenTitle = ((class_465)this).method_25440().getString();
            if (!screenTitle.contains("\u279c")) {
                return;
            }
            double mouseX = click.comp_4798();
            class_1735 clickedSlot = this.method_64240(mouseX, mouseY = click.comp_4799());
            if (clickedSlot == null || !clickedSlot.method_7681()) {
                return;
            }
            class_1799 clickedItem = clickedSlot.method_7677();
            String itemName = "";
            itemName = clickedItem.method_65130() != null ? clickedItem.method_65130().getString() : clickedItem.method_7909().method_7854().method_7964().getString();
            boolean ctrlPressed = GLFW.glfwGetKey((long)class_310.method_1551().method_22683().method_4490(), (int)341) == 1 || GLFW.glfwGetKey((long)class_310.method_1551().method_22683().method_4490(), (int)345) == 1;
            boolean shouldBlock = false;
            String protection = "";
            long sellAmount = SellAmountParser.getDefaultProtectionAmount();
            if (itemName.contains("Sell Instantly")) {
                sellAmount = SellAmountParser.extractSellInstantlyAmount(clickedItem);
                if (button == 0 && !ctrlPressed && sellAmount > SellProtectionManager.getMaxAmount()) {
                    shouldBlock = true;
                    protection = "Sell Instantly";
                }
            } else if (itemName.contains("Sell Sacks Now") || itemName.contains("Sell Inventory Now")) {
                sellAmount = SellAmountParser.extractInventorySackAmount(clickedItem);
                if (!ctrlPressed && sellAmount > SellProtectionManager.getMaxAmount()) {
                    shouldBlock = true;
                    String string = protection = itemName.contains("Sell Sacks Now") ? "Sell Sacks Now" : "Sell Inventory Now";
                }
            }
            if (shouldBlock) {
                class_310 client = class_310.method_1551();
                if (client.field_1724 != null) {
                    String formattedAmount = this.formatCoins(sellAmount);
                    String message = "\u00a7c[SkyCofl Sell Protection] \u00a7fBlocked click on \u00a7e" + protection + "\u00a7f (\u00a76" + formattedAmount + " coins\u00a7f)! Hold \u00a7bCtrl\u00a7f to override.";
                    client.field_1724.method_7353((class_2561)class_2561.method_43470((String)message), false);
                }
                cir.setReturnValue((Object)true);
                return;
            }
        }
        catch (Exception e) {
            System.out.println("[SellProtectionMixin] mouseClicked failed: " + e.getMessage());
        }
    }

    private String formatCoins(long coins) {
        if (coins >= 1000000000L) {
            return String.format(Locale.US, "%.1fB", (double)coins / 1.0E9);
        }
        if (coins >= 1000000L) {
            return String.format(Locale.US, "%.1fM", (double)coins / 1000000.0);
        }
        if (coins >= 1000L) {
            return String.format(Locale.US, "%.1fK", (double)coins / 1000.0);
        }
        return String.valueOf(coins);
    }
}

