/*
 * Decompiled with CFR 0.152.
 */
package com.coflnet;

import CoflCore.CoflCore;
import CoflCore.CoflSkyCommand;
import CoflCore.classes.Position;
import CoflCore.commands.Command;
import CoflCore.commands.CommandType;
import CoflCore.commands.RawCommand;
import CoflCore.commands.models.FlipData;
import CoflCore.configuration.GUIType;
import CoflCore.handlers.DescriptionHandler;
import CoflCore.handlers.EventRegistry;
import com.coflnet.EventSubscribers;
import com.coflnet.gui.BinGUI;
import com.coflnet.gui.RenderUtils;
import com.coflnet.gui.cofl.CoflBinGUI;
import com.coflnet.gui.tfm.TfmBinGUI;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.serialization.DynamicOps;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandRegistrationCallback;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientLifecycleEvents;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.item.v1.ItemTooltipCallback;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.fabricmc.fabric.api.client.message.v1.ClientReceiveMessageEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.fabricmc.fabric.api.client.rendering.v1.HudRenderCallback;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderEvents;
import net.fabricmc.fabric.api.client.screen.v1.ScreenEvents;
import net.fabricmc.fabric.api.event.player.UseBlockCallback;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_124;
import net.minecraft.class_1263;
import net.minecraft.class_1269;
import net.minecraft.class_156;
import net.minecraft.class_1707;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2507;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2586;
import net.minecraft.class_2621;
import net.minecraft.class_2625;
import net.minecraft.class_266;
import net.minecraft.class_268;
import net.minecraft.class_269;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3545;
import net.minecraft.class_3675;
import net.minecraft.class_3797;
import net.minecraft.class_408;
import net.minecraft.class_437;
import net.minecraft.class_442;
import net.minecraft.class_465;
import net.minecraft.class_476;
import net.minecraft.class_634;
import net.minecraft.class_640;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import net.minecraft.class_746;
import net.minecraft.class_8646;
import net.minecraft.class_8816;
import net.minecraft.class_9015;
import net.minecraft.class_9331;

@Environment(value=EnvType.CLIENT)
public class CoflModClient
implements ClientModInitializer {
    public static final String targetVersion = "1.21.7";
    public static Gson gson = new GsonBuilder().excludeFieldsWithoutExposeAnnotation().create();
    private static boolean keyPressed = false;
    private static int counter = 0;
    public static class_304 bestflipsKeyBinding;
    public static class_304 uploadItemKeyBinding;
    public static ArrayList<String> knownIds;
    public static class_3545<Integer, Integer> indexesOfImportantScores;
    public static String importantScores;
    private String username = "";
    private static String lastNbtRequest;
    private boolean uploadedScoreboard = false;
    private static boolean popupShown;
    public static Position posToUpload;
    public static CoflModClient instance;
    public static class_2625 sign;
    private static final String COFL_EXTRA_SLOT_KEY = "COFL_ADDITIONAL_SLOT";

    public void onInitializeClient() {
        instance = this;
        this.username = class_310.method_1551().method_1548().method_1676();
        Path configDir = FabricLoader.getInstance().getConfigDir();
        CoflCore cofl = new CoflCore();
        cofl.init(configDir);
        cofl.registerEventFile((Object)new EventSubscribers());
        ClientLifecycleEvents.CLIENT_STARTED.register(mc -> RenderUtils.init());
        bestflipsKeyBinding = KeyBindingHelper.registerKeyBinding((class_304)new class_304("keybinding.coflmod.bestflips", class_3675.class_307.field_1668, 66, "SkyCofl"));
        uploadItemKeyBinding = KeyBindingHelper.registerKeyBinding((class_304)new class_304("keybinding.coflmod.uploaditem", class_3675.class_307.field_1668, 73, "SkyCofl"));
        ClientTickEvents.END_CLIENT_TICK.register(client -> {
            if (bestflipsKeyBinding.method_1434()) {
                if (counter == 0) {
                    EventRegistry.onOpenBestFlip((String)this.username, (boolean)true);
                }
                if (counter < 2) {
                    ++counter;
                }
            } else {
                counter = 0;
            }
            if (uploadItemKeyBinding.method_1436()) {
                this.handleGetHoveredItem(client);
            }
        });
        ClientPlayConnectionEvents.JOIN.register((handler, sender, server) -> {
            if (class_310.method_1551() != null && class_310.method_1551().method_1558() != null && class_310.method_1551().method_1558().field_3761.contains("hypixel.net")) {
                System.out.println("Connected to Hypixel");
                this.username = class_310.method_1551().method_1548().method_1676();
                if (!CoflCore.Wrapper.isRunning && CoflCore.config.autoStart) {
                    CoflSkyCommand.start((String)this.username);
                }
                Thread.startVirtualThread(() -> {
                    try {
                        Thread.sleep(5000L);
                        if (!CoflCore.Wrapper.isRunning) {
                            return;
                        }
                        CoflModClient.uploadScoreboard();
                        CoflModClient.uploadTabList();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                });
            }
            DescriptionHandler.emptyTooltipData();
            this.uploadedScoreboard = false;
        });
        ClientPlayConnectionEvents.DISCONNECT.register((handler, server) -> {
            if (CoflCore.Wrapper.isRunning) {
                System.out.println("Disconnected from server");
                CoflCore.Wrapper.stop();
            }
        });
        ClientCommandRegistrationCallback.EVENT.register((dispatcher, registryAccess) -> {
            this.registerDefaultCommands((CommandDispatcher<FabricClientCommandSource>)dispatcher, "cofl");
            this.registerDefaultCommands((CommandDispatcher<FabricClientCommandSource>)dispatcher, "cl");
            dispatcher.register((LiteralArgumentBuilder)ClientCommandManager.literal((String)"fc").then(ClientCommandManager.argument((String)"args", (ArgumentType)StringArgumentType.greedyString()).suggests((context, builder) -> {
                String[] suggestions = new String[]{":tableflip:", ":sad:", ":smile:", ":grin:", ":heart:", ":skull:", ":airplane:", ":check:", "<3", ":star:", ":yes:", ":no:", ":java:", ":arrow", ":shrug:", "o/", ":123:", ":totem:", ":typing:", ":maths:", ":snail:", ":thinking:", ":gimme:", ":wizard:", ":pvp:", ":peace:", ":oof:", ":puffer:", ":yey:", ":cat:", ":dab:", ":dj:", ":snow:", ":^_^:", ":^-^:", ":sloth:", ":cute:", ":dog:", ":fyou:", ":angwyflip:", ":snipe:", ":preapi:", ":tm:", ":r:", ":c:", ":crown:", ":fire:", ":sword:", ":shield:", ":cross:", ":star1:", ":star2:", ":star3:", ":star4:", ":rich:", ":boop:", ":yay:", ":gg:"};
                String input = context.getInput();
                String[] inputParts = input.split(" ");
                String currentWord = inputParts.length > 0 ? inputParts[inputParts.length - 1] : "";
                for (String suggestion : suggestions) {
                    if (!suggestion.toLowerCase().startsWith(currentWord.toLowerCase())) continue;
                    builder.suggest(suggestion, (Message)new TooltipMessage(this, "Will be replaced with the emoji"));
                }
                return builder.buildFuture();
            }).executes(context -> {
                String[] args = ((String)context.getArgument("args", String.class)).split(" ");
                String[] newArgs = new String[args.length + 1];
                System.arraycopy(args, 0, newArgs, 1, args.length);
                newArgs[0] = "chat";
                CoflSkyCommand.processCommand((String[])newArgs, (String)this.username);
                return 1;
            })));
        });
        ScreenEvents.AFTER_INIT.register((client, screen, scaledWidth, scaledHeight) -> {
            if (screen instanceof class_476) {
                class_476 gcs = (class_476)screen;
                if (CoflCore.config.purchaseOverlay != null && gcs.method_25440() != null && !(client.field_1755 instanceof BinGUI) && CoflModClient.isBINAuction(gcs)) {
                    if (CoflCore.config.purchaseOverlay == GUIType.COFL) {
                        client.method_1507((class_437)new CoflBinGUI(gcs));
                    }
                    if (CoflCore.config.purchaseOverlay == GUIType.TFM) {
                        client.method_1507((class_437)new TfmBinGUI(gcs));
                    }
                }
            }
        });
        ScreenEvents.AFTER_INIT.register((client, screen, scaledWidth, scaledHeight) -> {
            if (screen instanceof class_465) {
                class_465 hs = (class_465)screen;
                knownIds.clear();
                this.loadDescriptionsForInv(hs);
                if (!this.uploadedScoreboard) {
                    CoflModClient.uploadScoreboard();
                    CoflModClient.uploadTabList();
                    this.uploadedScoreboard = true;
                }
            }
        });
        ItemTooltipCallback.EVENT.register((stack, tooltipContext, tooltipType, lines) -> {
            DescriptionHandler.DescModification[] tooltips;
            class_437 patt0$temp;
            if (knownIds.indexOf(CoflModClient.getIdFromStack(stack)) == -1 && (patt0$temp = class_310.method_1551().field_1755) instanceof class_465) {
                class_465 hs = (class_465)patt0$temp;
                this.loadDescriptionsForInv(hs);
                return;
            }
            block14: for (DescriptionHandler.DescModification tooltip : tooltips = DescriptionHandler.getTooltipData((String)CoflModClient.getIdFromStack(stack))) {
                switch (tooltip.type) {
                    case "APPEND": {
                        lines.add(class_2561.method_30163((String)(tooltip.value + " ")));
                        continue block14;
                    }
                    case "REPLACE": {
                        if (tooltip.line < 0 || tooltip.line >= lines.size()) {
                            System.out.println("Invalid line index: " + tooltip.line + " for tooltip: " + tooltip.value);
                            continue block14;
                        }
                        lines.remove(tooltip.line);
                        lines.add(tooltip.line, class_2561.method_30163((String)tooltip.value));
                        continue block14;
                    }
                    case "INSERT": {
                        lines.add(tooltip.line, class_2561.method_30163((String)tooltip.value));
                        continue block14;
                    }
                    case "DELETE": {
                        lines.remove(tooltip.line);
                        continue block14;
                    }
                    case "HIGHLIGHT": {
                        class_437 patt1$temp = class_310.method_1551().field_1755;
                        if (!(patt1$temp instanceof class_465)) continue block14;
                        class_465 class_4652 = (class_465)patt1$temp;
                        continue block14;
                    }
                    default: {
                        System.out.println("Unknown type: " + tooltip.type);
                    }
                }
            }
        });
        HudRenderCallback.EVENT.register((drawContext, tickCounter) -> {
            if (EventSubscribers.showCountdown && EventSubscribers.countdownData != null && (class_310.method_1551().field_1755 == null || class_310.method_1551().field_1755 instanceof class_408)) {
                RenderUtils.drawStringWithShadow(drawContext, EventSubscribers.countdownData.getPrefix() + "New flips in: " + String.format("%.1f", Float.valueOf(EventSubscribers.countdown)), class_310.method_1551().method_22683().method_4480() / EventSubscribers.countdownData.getWidthPercentage(), class_310.method_1551().method_22683().method_4507() / EventSubscribers.countdownData.getHeightPercentage(), -1, EventSubscribers.countdownData.getScale());
            }
        });
        ClientReceiveMessageEvents.ALLOW_GAME.register((message, overlay) -> {
            EventRegistry.onChatMessage((String)message.getString());
            String previousHover = null;
            for (class_2561 component : message.method_10855()) {
                class_2568.class_10613 hest;
                String text;
                class_2568 patt0$temp;
                if (component.method_10866().method_10969() == null || !((patt0$temp = component.method_10866().method_10969()) instanceof class_2568.class_10613) || (text = (hest = (class_2568.class_10613)patt0$temp).comp_3510().getString()).equals(previousHover)) continue;
                previousHover = text;
                EventRegistry.onChatMessage((String)hest.comp_3510().getString());
            }
            return true;
        });
        ScreenEvents.AFTER_INIT.register((minecraftClient, screen, i, i1) -> {
            if (!(class_310.method_1551().field_1755 instanceof class_442)) {
                return;
            }
            if (!popupShown && !this.checkVersionCompability()) {
                popupShown = true;
                class_437 currentScreen = class_310.method_1551().field_1755;
                class_310.method_1551().method_1507((class_437)new class_8816.class_8817(currentScreen, class_2561.method_30163((String)"Warning")).method_54130((class_2561)class_2561.method_43470((String)"Modrinth"), popupScreen -> class_156.method_668().method_670("https://modrinth.com/mod/skycofl/versions")).method_54130(class_2561.method_30163((String)"Curseforge"), popupScreen -> class_156.method_668().method_670("https://www.curseforge.com/minecraft/mc-mods/skycofl/files/all?page=1&pageSize=20")).method_54130(class_2561.method_30163((String)"dismiss"), popupScreen -> popupScreen.method_25419()).method_54129(class_2561.method_30163((String)"This version of the SkyCofl mod is meant for use in Minecraft 1.21.7 and likely won't work on this version.\nYou can find other versions of SkyCofl here:")).method_54125());
            }
        });
        ClientReceiveMessageEvents.GAME.register((text, b) -> {
            String[] scores = CoflModClient.getScoreboard().toArray(new String[0]);
            if (scores == null || scores.length < 9) {
                return;
            }
            CoflModClient.updateIndexesOfImportantScores(scores);
            if (CoflModClient.importantScoresCSV(scores).equals(importantScores)) {
                return;
            }
            System.out.println("Uploading Scoreboard...");
            CoflModClient.uploadScoreboard();
        });
        UseBlockCallback.EVENT.register((playerEntity, world, hand, blockHitResult) -> {
            class_2586 patt0$temp = world.method_8321(blockHitResult.method_17777());
            if (patt0$temp instanceof class_2621) {
                class_2621 lcbe = (class_2621)patt0$temp;
                System.out.println("Lootable opened, saving position of lootable Block...");
                class_2338 pos = blockHitResult.method_17777();
                posToUpload = new Position(Integer.valueOf(pos.method_10263()), Integer.valueOf(pos.method_10264()), Integer.valueOf(pos.method_10260()));
            }
            return class_1269.field_5812;
        });
        WorldRenderEvents.LAST.register(worldRenderContext -> {
            if (EventSubscribers.positions == null || EventSubscribers.positions.size() == 0) {
                return;
            }
            for (Position position : EventSubscribers.positions) {
                RenderUtils.renderHighlightBox(worldRenderContext, new double[]{position.getX().intValue(), (double)position.getY().intValue() - 1.6, position.getZ() - 1}, new double[]{position.getX() - 1, (double)position.getY().intValue() - 0.6, position.getZ().intValue()}, new float[]{0.3f, 1.0f, 0.1f, 0.5f});
            }
        });
        ScreenEvents.AFTER_INIT.register((minecraftClient, screen, i, i1) -> {});
    }

    private void registerDefaultCommands(CommandDispatcher<FabricClientCommandSource> dispatcher, String name) {
        dispatcher.register((LiteralArgumentBuilder)ClientCommandManager.literal((String)name).then(ClientCommandManager.argument((String)"args", (ArgumentType)StringArgumentType.greedyString()).suggests((context, builder) -> {
            String input = context.getInput();
            String[] inputArgs = input.split(" ");
            String currentWord = inputArgs.length > 0 ? inputArgs[inputArgs.length - 1] : "";
            String[] suggestions = new String[]{"start", "stop", "vps", "report", "online", "delay", "blacklist", "bl", "whitelist", "wl", "mute", "blocked", "chat", "c", "nickname", "nick", "profit", "worstflips", "bestflips", "leaderboard", "lb", "loserboard", "buyspeedboard", "trades", "flips", "set", "s", "purchase", "buy", "transactions", "balance", "help", "h", "logout", "backup", "restore", "captcha", "importtfm", "replayactive", "reminder", "filters", "emoji", "addremindertime", "lore", "fact", "flip", "preapi", "transfercoins", "ping", "setgui tfm", "setgui cofl", "setgui off", "bazaar", "bz", "switchregion", "craftbreakdown", "cheapattrib", "ca", "ownconfigs", "configs", "config", "licenses", "license", "verify", "unverify", "attributeflip", "forge", "crafts", "craft", "upgradeplan", "updatecurrentconfig", "settimezone", "cheapmuseum", "cm", "replayflips", "lowball", "ahtax", "sethotkey"};
            System.out.println(inputArgs.length + currentWord);
            if (inputArgs.length == 3 && (inputArgs[1].equals("s") || inputArgs[1].equals("set"))) {
                for (String suggestion : suggestions = new String[]{"lbin", "finders", "onlyBin", "whitelistAftermain", "DisableFlips", "DebugMode", "blockHighCompetition", "minProfit", "minProfitPercent", "minVolume", "maxCost", "modjustProfit", "modsoundOnFlip", "modshortNumbers", "modshortNames", "modblockTenSecMsg", "modformat", "modblockedFormat", "modchat", "modcountdown", "modhideNoBestFlip", "modtimerX", "modtimerY", "modtimerSeconds", "modtimerScale", "modtimerPrefix", "modtimerPrecision", "modblockedMsg", "modmaxPercentOfPurse", "modnoBedDelay", "modstreamerMode", "modautoStartFlipper", "modnormalSoldFlips", "modtempBlacklistSpam", "moddataOnlyMode", "modahListHours", "modquickSell", "modmaxItemsInInventory", "moddisableSpamProtection", "showcost", "showestProfit", "showlbin", "showslbin", "showmedPrice", "showseller", "showvolume", "showextraFields", "showprofitPercent", "showprofit", "showsellerOpenBtn", "showlore", "showhideSold", "showhideManipulated", "privacyExtendDescriptions", "privacyAutoStart", "loreHighlightFilterMatch", "loreMinProfitForHighlight", "loreDisableHighlighting"}) {
                    if (!suggestion.toLowerCase().contains(currentWord.toLowerCase())) continue;
                    builder.suggest("set " + suggestion);
                }
            } else {
                if (inputArgs.length > 3) {
                    return builder.buildFuture();
                }
                for (String suggestion : suggestions) {
                    if (!suggestion.toLowerCase().startsWith(currentWord.toLowerCase()) && inputArgs.length != 1) continue;
                    builder.suggest(suggestion);
                }
            }
            return builder.buildFuture();
        }).executes(context -> {
            String[] args = ((String)context.getArgument("args", String.class)).split(" ");
            CoflSkyCommand.processCommand((String[])args, (String)this.username);
            return 1;
        })));
    }

    private void handleGetHoveredItem(class_310 client) {
        CoflModClient.uploadItem(client.field_1724.method_31548().method_5438(client.field_1724.method_31548().method_67532()));
    }

    public static void uploadItem(class_1799 hoveredStack) {
        class_310 client = class_310.method_1551();
        if (client.field_1724 == null || hoveredStack == null) {
            return;
        }
        RawCommand data = new RawCommand("hotkey", gson.toJson((Object)("upload_item" + CoflModClient.getContextToAppend(hoveredStack))));
        CoflCore.Wrapper.SendMessage(data);
    }

    private static String getContextToAppend(class_1799 hoveredStack) {
        String toAppend = "";
        class_310 client = class_310.method_1551();
        if (client.field_1724 == null) {
            return "";
        }
        class_2371 mockList = class_2371.method_10211();
        mockList.add((Object)hoveredStack);
        return "|" + CoflModClient.inventoryToNBT((class_2371<class_1799>)mockList);
    }

    private static void uploadTabList() {
        Command data = new Command(CommandType.uploadTab, (Object)CoflModClient.getTabList().toArray(new String[0]));
        CoflCore.Wrapper.SendMessage(data);
    }

    private static void uploadScoreboard() {
        String[] scores = CoflModClient.getScoreboard().toArray(new String[0]);
        if (scores.length > 8) {
            importantScores = CoflModClient.importantScoresCSV(scores);
        }
        Command data = new Command(CommandType.uploadScoreboard, (Object)scores);
        CoflCore.Wrapper.SendMessage(data);
    }

    public static FlipData popFlipData() {
        FlipData fd = EventSubscribers.flipData;
        EventSubscribers.flipData = null;
        return fd;
    }

    public static class_3414 findByName(String name) {
        class_3414 result = (class_3414)class_3417.field_14793.comp_349();
        for (Field f : class_3417.class.getDeclaredFields()) {
            if (!f.getName().equalsIgnoreCase(name)) continue;
            try {
                try {
                    result = (class_3414)f.get(class_3414.class);
                }
                catch (ClassCastException e) {
                    result = (class_3414)((class_6880.class_6883)f.get(class_6880.class_6883.class)).comp_349();
                }
            }
            catch (IllegalAccessException e) {
                System.out.println("SoundEvent inaccessible. This shouldn't happen");
            }
            break;
        }
        return result;
    }

    public static class_2371<class_1799> inventoryToItemStacks(class_1263 inventory) {
        class_2371 itemStacks = class_2371.method_10211();
        for (int i = 0; i < inventory.method_5439(); ++i) {
            itemStacks.add((Object)inventory.method_5438(i));
        }
        return itemStacks;
    }

    public static String inventoryToNBT(class_1263 inventory) {
        return CoflModClient.inventoryToNBT(CoflModClient.inventoryToItemStacks(inventory));
    }

    public static String[] getItemIdsFromInventory(class_1263 inventory) {
        return CoflModClient.getItemIdsFromInventory(CoflModClient.inventoryToItemStacks(inventory));
    }

    public static String inventoryToNBT(class_2371<class_1799> itemStacks) {
        class_2487 nbtCompound = new class_2487();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        class_746 player = class_310.method_1551().field_1724;
        try {
            nbtCompound = CoflModClient.writeNbt(nbtCompound, itemStacks, (class_7225.class_7874)player.method_56673());
            System.out.println(nbtCompound.method_10580("i").method_68658());
            class_2507.method_10634((class_2487)nbtCompound, (OutputStream)baos);
            return Base64.getEncoder().encodeToString(baos.toByteArray());
        }
        catch (IOException e) {
            e.printStackTrace();
            return "";
        }
    }

    public static class_2487 writeNbt(class_2487 nbt, class_2371<class_1799> stacks, class_7225.class_7874 registries) {
        class_2499 nbtList = new class_2499();
        for (int i = 0; i < stacks.size(); ++i) {
            class_2487 nbtCompound;
            class_1799 itemStack = (class_1799)stacks.get(i);
            if (!itemStack.method_7960()) {
                nbtCompound = new class_2487();
                nbtCompound.method_10567("Slot", (byte)i);
                nbtList.add((Object)((class_2520)class_1799.field_24671.encode((Object)itemStack, (DynamicOps)registries.method_57093((DynamicOps)class_2509.field_11560), (Object)nbtCompound).getOrThrow()));
                continue;
            }
            nbtCompound = new class_2487();
            nbtList.add((Object)nbtCompound);
        }
        if (!nbtList.isEmpty()) {
            nbt.method_10566("i", (class_2520)nbtList);
        }
        return nbt;
    }

    public static String[] getItemIdsFromInventory(class_2371<class_1799> itemStacks) {
        ArrayList<Object> res = new ArrayList<Object>();
        for (int i = 0; i < itemStacks.size(); ++i) {
            class_1799 stack = (class_1799)itemStacks.get(i);
            if (stack.method_7909() != class_1802.field_8162) {
                String id = CoflModClient.getIdFromStack(stack);
                knownIds.add(id);
                res.add(id);
                continue;
            }
            res.add("EMPTY_SLOT_" + i);
        }
        return (String[])res.toArray(String[]::new);
    }

    public static String getIdFromStack(class_1799 stack) {
        String itemName;
        JsonObject stackJson = null;
        for (class_9331 type : stack.method_57353().method_57831()) {
            if (!type.toString().contains("minecraft:custom_data")) continue;
            stackJson = (JsonObject)gson.fromJson(stack.method_58694(type).toString(), JsonObject.class);
        }
        String string = itemName = stack.method_65130() == null ? stack.method_7909().method_63680().getString() : stack.method_65130().getString();
        if (stackJson == null) {
            return itemName + ";" + stack.method_7947();
        }
        JsonElement uuid = stackJson.get("uuid");
        if (uuid != null) {
            return uuid.getAsString();
        }
        JsonElement idElement = stackJson.get("id");
        if (idElement != null && !Objects.equals(idElement.getAsString(), "ATTRIBUTE_SHARD")) {
            return idElement.getAsString() + ";" + stack.method_7947();
        }
        return itemName + ";" + stack.method_7947();
    }

    public void loadDescriptionsForInv(class_465 screen) {
        if (!class_310.method_1551().field_1724.method_31548().method_5438(8).method_57353().toString().contains("minecraft:custom_data=>{id:\"SKYBLOCK_MENU\"}")) {
            return;
        }
        Thread.startVirtualThread(() -> {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            class_2371 itemStacks = screen.method_17577().method_7602();
            try {
                knownIds.clear();
                String title = screen.method_25440().getString();
                String[] visibleItems = CoflModClient.getItemIdsFromInventory((class_2371<class_1799>)itemStacks);
                CoflModClient.loadDescriptionsForItems(title, (class_2371<class_1799>)itemStacks);
                if (title.contains("Bazaar")) {
                    System.out.println("Bazaar data: " + CoflModClient.inventoryToNBT((class_2371<class_1799>)itemStacks));
                }
                Thread.sleep(1000L);
                String[] itemIds = CoflModClient.getItemIdsFromInventory((class_2371<class_1799>)screen.method_17577().method_7602());
                List<String> visibleList = Arrays.asList(visibleItems);
                for (String itemId : itemIds) {
                    if (visibleList.contains(itemId)) continue;
                    CoflModClient.loadDescriptionsForItems(title, (class_2371<class_1799>)screen.method_17577().method_7602());
                    System.out.println("items changed, descriptions reloaded for " + itemId + " count: " + itemIds.length + " visible: " + visibleItems.length);
                    break;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                System.out.println("Failed to load descriptions for inventory: " + String.valueOf(e) + " " + CoflModClient.inventoryToNBT((class_2371<class_1799>)itemStacks));
            }
        });
    }

    public static void loadDescriptionsForItems(String title, class_2371<class_1799> items) {
        String[] visibleItems = CoflModClient.getItemIdsFromInventory(items);
        String userName = class_310.method_1551().method_1548().method_1676();
        String nbtString = CoflModClient.inventoryToNBT(items);
        if (nbtString.equals(lastNbtRequest)) {
            return;
        }
        lastNbtRequest = nbtString;
        DescriptionHandler.loadDescriptionForInventory((String[])visibleItems, (String)title, (String)nbtString, (String)userName, (Position)posToUpload);
    }

    private static List<String> getScoreboard() {
        ObjectArrayList scoreboardAsText = new ObjectArrayList();
        if (class_310.method_1551() == null || class_310.method_1551().field_1687 == null) {
            System.out.println("MinecraftClient or world is null, cannot get scoreboard.");
            return scoreboardAsText;
        }
        class_746 player = class_310.method_1551().field_1724;
        if (player == null) {
            System.out.println("Player is null, cannot get scoreboard.");
            return scoreboardAsText;
        }
        class_269 scoreboard = player.method_7327();
        class_266 objective = scoreboard.method_1189((class_8646)class_8646.field_45176.apply(1));
        for (class_9015 scoreHolder : scoreboard.method_1178()) {
            String strLine;
            class_268 team;
            if (!scoreboard.method_1166(scoreHolder).containsKey((Object)objective) || (team = scoreboard.method_1164(scoreHolder.method_5820())) == null || (strLine = team.method_1144().getString() + team.method_1136().getString()).trim().isEmpty()) continue;
            String formatted = class_124.method_539((String)strLine);
            scoreboardAsText.add((Object)formatted);
        }
        if (objective != null) {
            scoreboardAsText.add((Object)objective.method_1114().getString());
            Collections.reverse(scoreboardAsText);
        }
        return scoreboardAsText;
    }

    private static List<String> getTabList() {
        ArrayList<String> tabList = new ArrayList<String>();
        if (class_310.method_1551() == null || class_310.method_1551().field_1687 == null) {
            System.out.println("MinecraftClient or world is null, cannot get tab list.");
            return tabList;
        }
        class_310 client = class_310.method_1551();
        class_634 networkHandler = client.method_1562();
        if (networkHandler != null) {
            ArrayList playerList = new ArrayList(networkHandler.method_2880());
            for (class_640 playerListEntry : playerList) {
                if (playerListEntry == null) continue;
                if (playerListEntry.method_2971() != null) {
                    String displayName = playerListEntry.method_2971().getString();
                    tabList.add(displayName);
                    continue;
                }
                String playerName = playerListEntry.method_2966().getName();
                tabList.add(playerName);
            }
        }
        return tabList;
    }

    public static boolean isBINAuction(class_476 gcs) {
        return BinGUI.isAuctionInit(gcs) || BinGUI.isAuctionConfirming(gcs);
    }

    public static boolean isOwnAuction(class_476 gcs) {
        class_1799 stack = ((class_1707)gcs.method_17577()).method_7629().method_5438(31);
        return BinGUI.isAuctionInit(gcs) && (stack.method_7909() == class_1802.field_8871 || stack.method_7909() == class_1802.field_8494);
    }

    private boolean checkVersionCompability() {
        try {
            String v = class_3797.field_25319.comp_4025();
            System.out.println("Detected Minecraft version:" + v);
            boolean b = v.compareTo(targetVersion) == 0;
            return b;
        }
        catch (NoSuchMethodError e) {
            return false;
        }
    }

    private static class_3545<Integer, Integer> updateIndexesOfImportantScores(String[] scores) {
        class_3545 ids = new class_3545((Object)0, (Object)0);
        for (int i = 0; i < scores.length; ++i) {
            String score = scores[i];
            if (score.startsWith("Purse: ") || score.startsWith("Piggy: ")) {
                ids.method_34964((Object)i);
            }
            if (!score.startsWith(" \u23e3 ")) continue;
            ids.method_34965((Object)i);
        }
        indexesOfImportantScores = ids;
        return indexesOfImportantScores;
    }

    private static String importantScoresCSV(String[] scores) {
        return scores[(Integer)indexesOfImportantScores.method_15442()] + ";" + scores[(Integer)indexesOfImportantScores.method_15441()];
    }

    public static String findPriceSuggestion() {
        for (DescriptionHandler.DescModification descMod : CoflModClient.getExtraSlotDescMod()) {
            System.out.println(descMod.type + "|" + descMod.value);
            if (descMod.type.compareTo("SUGGEST") != 0) continue;
            return descMod.value;
        }
        return "";
    }

    public static DescriptionHandler.DescModification[] getExtraSlotDescMod() {
        return DescriptionHandler.getInfoDisplay();
    }

    static {
        knownIds = new ArrayList();
        indexesOfImportantScores = new class_3545((Object)0, (Object)0);
        importantScores = "";
        lastNbtRequest = "";
        popupShown = false;
        posToUpload = null;
        sign = null;
    }

    @Environment(value=EnvType.CLIENT)
    public class TooltipMessage
    implements Message {
        private final String text;

        public TooltipMessage(CoflModClient this$0, String text) {
            this.text = text;
        }

        public String getString() {
            return this.text;
        }
    }
}

