/*
 * Decompiled with CFR 0.152.
 */
package com.coflnet.gui;

import CoflCore.commands.models.FlipData;
import com.coflnet.CoflModClient;
import com.coflnet.gui.AuctionStatus;
import com.coflnet.gui.widget.ItemWidget;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1657;
import net.minecraft.class_1707;
import net.minecraft.class_1713;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_437;
import net.minecraft.class_476;
import net.minecraft.class_746;
import net.minecraft.class_9290;
import net.minecraft.class_9334;
import org.jetbrains.annotations.NotNull;

@Environment(value=EnvType.CLIENT)
public abstract class BinGUI
extends class_437 {
    protected int width;
    protected int height;
    protected int screenHeight;
    protected int screenWidth;
    protected int p;
    protected int r;
    protected final int AUCTION_ITEM_SLOT = 13;
    protected final int AUCTION_BUY_SLOT = 31;
    protected final int AUCTION_CANCEL_SLOT = 49;
    protected final int AUCTION_CONFIRM_SLOT = 11;
    protected final int AUCTION_CONFIRMATION_CANCEL_SLOT = 15;
    protected final int OWN_AUCTION_CLAIM_SLOT = 31;
    protected final int OWN_AUCTION_CANCEL_SLOT = 33;
    protected ItemWidget itemWidget;
    protected class_1799 currentItem;
    protected FlipData flipData;
    protected AuctionStatus auctionStatus;
    protected class_1707 gcsh;
    protected class_476 gcs;

    protected BinGUI(class_2561 title, @NotNull class_476 gcs, @NotNull int p, int r) {
        super(title);
        this.gcs = gcs;
        this.gcsh = (class_1707)gcs.method_17577();
        this.p = p;
        this.r = r;
        if (BinGUI.isAuctionConfirming(gcs)) {
            this.auctionStatus = AuctionStatus.AUCTION_CONFIRMING;
        } else if (BinGUI.isAuctionInit(gcs)) {
            this.auctionStatus = AuctionStatus.INIT;
        }
        this.flipData = CoflModClient.popFlipData();
        this.screenWidth = class_310.method_1551().field_1755.field_22789;
        this.screenHeight = class_310.method_1551().field_1755.field_22790;
        this.initSize(this.screenWidth, this.screenHeight);
        this.clearAndInitWidgets(this.screenWidth, this.screenHeight);
    }

    private void initSize(int screenWidth, int screenHeight) {
        this.width = class_310.method_1551().field_1755.field_22789 / 2;
        if (this.width < 300) {
            this.width = 300;
        }
        this.height = class_310.method_1551().field_1755.field_22790 / 3 * 2;
        if (this.height < 225) {
            this.height = 225;
        }
    }

    protected abstract void clearAndInitWidgets(int var1, int var2);

    public void setItem(class_1799 item) {
        this.currentItem = item;
        this.itemWidget.item = item;
    }

    public boolean method_25421() {
        return false;
    }

    public void method_25419() {
        this.auctionStatus = AuctionStatus.INIT;
        this.gcs.method_25419();
        super.method_25419();
    }

    protected void clickSlot(int slotId) {
        class_746 player = this.field_22787.field_1724;
        this.field_22787.field_1761.method_2906(this.gcsh.field_7763, slotId, 0, class_1713.field_7790, (class_1657)player);
    }

    protected AuctionStatus updateAuctionStatus(@NotNull class_1799 itemStack) {
        class_1792 item = itemStack.method_7909();
        if (item == class_1802.field_8157) {
            this.auctionStatus = AuctionStatus.OWN_AUCTION_CANCELING;
            return this.auctionStatus;
        }
        if (item == class_1802.field_8789) {
            this.auctionStatus = AuctionStatus.AUCTION_WAITING;
            return this.auctionStatus;
        }
        String customName = itemStack.method_65130().getString();
        String loreString = ((class_9290)itemStack.method_57353().method_58694(class_9334.field_49632)).toString();
        switch (customName) {
            case "Buy Item Right Now": {
                if (loreString.contains("Cannot afford bid!")) {
                    this.auctionStatus = AuctionStatus.AUCTION_BUYING;
                } else if (loreString.contains("Click to purchase!")) {
                    this.auctionStatus = AuctionStatus.AUCTION_BUYING;
                }
                return this.auctionStatus;
            }
            case "Collect Auction": {
                if (loreString.contains("Click to collect coins!")) {
                    this.auctionStatus = AuctionStatus.OWN_AUCTION_CLAIMING;
                } else if (loreString.contains("Click to pick up item!")) {
                    this.auctionStatus = AuctionStatus.OWN_AUCTION_CLAIMING;
                } else if (loreString.contains("Someone else purchased the item")) {
                    this.auctionStatus = AuctionStatus.AUCTION_SOLD;
                }
                return this.auctionStatus;
            }
            case "Confirm": {
                this.auctionStatus = AuctionStatus.AUCTION_CONFIRMING;
                return this.auctionStatus;
            }
        }
        return this.auctionStatus;
    }

    public void method_25420(class_332 context, int mouseX, int mouseY, float delta) {
        if (this.screenWidth != class_310.method_1551().field_1755.field_22789 || this.screenHeight != class_310.method_1551().field_1755.field_22790) {
            this.screenWidth = class_310.method_1551().field_1755.field_22789;
            this.screenHeight = class_310.method_1551().field_1755.field_22790;
            this.initSize(this.screenWidth, this.screenHeight);
            this.clearAndInitWidgets(this.screenWidth, this.screenHeight);
        }
    }

    public static boolean isAuctionConfirming(@NotNull class_476 gcs) {
        return gcs.method_25440().getString().contains("Confirm Purchase") && ((class_1707)gcs.method_17577()).method_7629().method_5439() == 27;
    }

    public static boolean isAuctionInit(@NotNull class_476 gcs) {
        return gcs.method_25440().getString().contains("BIN Auction View") && ((class_1707)gcs.method_17577()).method_7629().method_5439() == 54;
    }
}

