/*
 * Decompiled with CFR 0.152.
 */
package CoflCore;

import CoflCore.FlipHandler;
import CoflCore.configuration.Config;
import CoflCore.configuration.LocalConfig;
import CoflCore.misc.SessionManager;
import CoflCore.network.WSClientWrapper;
import CoflCore.proxy.APIKeyManager;
import com.google.gson.Gson;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.greenrobot.eventbus.EventBus;

public class CoflCore {
    public static final String MODID = "CoflSky";
    public static final String VERSION = "1.7.0";
    public static FlipHandler flipHandler = new FlipHandler();
    public static File configFile;
    private File coflDir;
    public static LocalConfig config;
    public static final String[] webSocketURIPrefix;
    public static WSClientWrapper Wrapper;
    public static String CommandUri;
    private static final APIKeyManager apiKeyManager;

    public void registerEventFile(Object target) {
        EventBus.getDefault().register(target);
    }

    public void init(Path configPath) {
        String configString = null;
        Gson gson = new Gson();
        this.coflDir = new File(configPath.toFile(), MODID);
        this.coflDir.mkdirs();
        SessionManager.setMainPath(Paths.get(this.coflDir.toString() + "/sessions", new String[0]));
        configFile = new File(this.coflDir, "config.json");
        try {
            if (configFile.isFile()) {
                configString = new String(Files.readAllBytes(Paths.get(configFile.getPath(), new String[0])));
                config = gson.fromJson(configString, LocalConfig.class);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (config == null) {
            config = LocalConfig.createDefaultConfig();
        }
        try {
            apiKeyManager.loadIfExists(configPath);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            LocalConfig.saveConfig(configFile, config);
            try {
                apiKeyManager.saveKey(configPath);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }));
    }

    public static APIKeyManager getAPIKeyManager() {
        return apiKeyManager;
    }

    static {
        webSocketURIPrefix = new String[]{"wss://sky.coflnet.com/modsocket", "ws://sky-mod.coflnet.com/modsocket"};
        Wrapper = new WSClientWrapper(webSocketURIPrefix);
        CommandUri = Config.BaseUrl + "/api/mod/commands";
        apiKeyManager = new APIKeyManager();
    }
}

