/*
 * Decompiled with CFR 0.152.
 */
package CoflCore;

import CoflCore.CoflCore;
import CoflCore.commands.Command;
import CoflCore.commands.CommandType;
import CoflCore.commands.JsonStringCommand;
import CoflCore.commands.RawCommand;
import CoflCore.commands.models.FlipData;
import CoflCore.configuration.Config;
import CoflCore.configuration.GUIType;
import CoflCore.events.OnCloseGUI;
import CoflCore.events.OnGetInventory;
import CoflCore.events.OnModChatMessage;
import CoflCore.events.OnOpenAuctionGUI;
import CoflCore.misc.SessionManager;
import CoflCore.network.QueryServerCommands;
import CoflCore.network.WSClient;
import java.io.IOException;
import java.util.Arrays;
import java.util.Base64;
import org.greenrobot.eventbus.EventBus;

public class CoflSkyCommand {
    public static final String HelpText = "Available local sub-commands:\n\u00a7bstart: \u00a77starts a new connection\n\u00a7bstop: \u00a77stops the connection\n\u00a7bconnect: \u00a77Connects to a different server\n\u00a7breset: \u00a77resets all local session information and stops the connection\n\u00a7bstatus: \u00a77Emits status information\n\u00a7bsetgui: \u00a77Changes the auction purchase GUI\nServer-Only Commands:";

    public static void processCommand(String[] args, String username) {
        new Thread(() -> {
            System.out.println(Arrays.toString(args));
            if (args.length >= 1) {
                switch (args[0].toLowerCase()) {
                    case "start": {
                        CoflSkyCommand.start(username);
                        break;
                    }
                    case "stop": {
                        CoflSkyCommand.stop();
                        break;
                    }
                    case "callback": {
                        CoflSkyCommand.callback(args);
                        break;
                    }
                    case "dev": {
                        CoflSkyCommand.dev(username);
                        break;
                    }
                    case "status": {
                        CoflSkyCommand.status(username);
                        break;
                    }
                    case "reset": {
                        CoflSkyCommand.reset(username);
                        break;
                    }
                    case "connect": {
                        CoflSkyCommand.connect(args, username);
                        break;
                    }
                    case "openauctiongui": {
                        CoflSkyCommand.openAuctionGUI(args);
                        break;
                    }
                    case "setgui": {
                        CoflSkyCommand.setGUI(args);
                        break;
                    }
                    case "closegui": {
                        CoflSkyCommand.closeGUI();
                        break;
                    }
                    case "getinventory": {
                        CoflSkyCommand.getInventory();
                        break;
                    }
                    default: {
                        CoflSkyCommand.sendCommandToServer(args, username);
                        break;
                    }
                }
            } else {
                EventBus.getDefault().post(new OnModChatMessage(HelpText));
                EventBus.getDefault().post(new OnModChatMessage(QueryServerCommands.QueryCommands()));
            }
        }).start();
    }

    public static void start(String username) {
        CoflCore.Wrapper.stop();
        EventBus.getDefault().post(new OnModChatMessage("Starting connection..."));
        CoflCore.Wrapper.startConnection(username);
    }

    public static void sendCommandToServer(String[] args, String username) {
        String command = String.join((CharSequence)" ", Arrays.copyOfRange(args, 1, args.length));
        RawCommand rc = new RawCommand(args[0], WSClient.gson.toJson(command));
        if (CoflCore.Wrapper.isRunning) {
            CoflCore.Wrapper.SendMessage(rc);
        } else {
            EventBus.getDefault().post(new OnModChatMessage("\u00a7cCoflSky wasn't active."));
            CoflCore.Wrapper.startConnection(username);
            CoflCore.Wrapper.SendMessage(rc);
        }
    }

    public static void stop() {
        CoflCore.Wrapper.stop();
        EventBus.getDefault().post(new OnModChatMessage("you stopped the connection to \u00a71C\u00a76oflnet\u00a7r.\n    To reconnect enter \u00a7b\"\u00a7r/cofl start\u00a7b\"\u00a7r or click this message\n"));
    }

    public static void callback(String[] args) {
        String command = String.join((CharSequence)" ", Arrays.copyOfRange(args, 1, args.length));
        System.out.println("CallbackData: " + command);
        System.out.println("Callback: " + command);
        WSClient.HandleCommand(new JsonStringCommand(CommandType.Execute, WSClient.gson.toJson(command)));
        CoflCore.Wrapper.SendMessage(new JsonStringCommand(CommandType.Clicked, WSClient.gson.toJson(command)));
        System.out.println("Sent!");
    }

    public static void dev(String username) {
        if (Config.BaseUrl.contains("localhost")) {
            CoflCore.Wrapper.startConnection(username);
            Config.BaseUrl = "https://sky.coflnet.com";
        } else {
            CoflCore.Wrapper.initializeNewSocket("ws://localhost:8009/modsocket", username);
            Config.BaseUrl = "http://localhost:5005";
        }
        EventBus.getDefault().post(new OnModChatMessage("toggled dev mode, now using " + Config.BaseUrl));
    }

    public static void status(String username) {
        String vendor = System.getProperty("java.vm.vendor");
        String name = System.getProperty("java.vm.name");
        String version = System.getProperty("java.version");
        String detailedVersion = System.getProperty("java.vm.version");
        String status = vendor + " " + name + " " + version + " " + detailedVersion + "|Connection = " + (CoflCore.Wrapper != null ? CoflCore.Wrapper.GetStatus() : "UNINITIALIZED_WRAPPER");
        try {
            status = status + "  uri=" + CoflCore.Wrapper.socket.uri.toString();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        try {
            SessionManager.CoflSession session = SessionManager.GetCoflSession(username);
            String sessionString = SessionManager.gson.toJson(session);
            status = status + "  session=" + sessionString;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        EventBus.getDefault().post(new OnModChatMessage(status));
    }

    public static void reset(String username) {
        CoflCore.Wrapper.SendMessage(new Command<String>(CommandType.Reset, ""));
        CoflCore.Wrapper.stop();
        EventBus.getDefault().post(new OnModChatMessage("Stopping Connection to Coflnet"));
        SessionManager.DeleteAllCoflSessions();
        EventBus.getDefault().post(new OnModChatMessage("Deleting Coflnet sessions..."));
        if (CoflCore.Wrapper.startConnection(username)) {
            EventBus.getDefault().post(new OnModChatMessage("Started the Connection to Coflnet"));
        }
    }

    public static void connect(String[] args, String username) {
        if (args.length == 2) {
            String destination = args[1];
            if (!destination.contains("://")) {
                destination = new String(Base64.getDecoder().decode(destination));
            }
            EventBus.getDefault().post(new OnModChatMessage("Stopping connection!"));
            CoflCore.Wrapper.stop();
            EventBus.getDefault().post(new OnModChatMessage("Opening connection to " + destination));
            if (CoflCore.Wrapper.initializeNewSocket(destination, username)) {
                EventBus.getDefault().post(new OnModChatMessage("Success"));
            } else {
                EventBus.getDefault().post(new OnModChatMessage("Could not open connection, please check the logs"));
            }
        } else {
            EventBus.getDefault().post(new OnModChatMessage("\u00a7cPleace specify a server to connect to"));
        }
    }

    public static void openAuctionGUI(String[] args) {
        boolean shouldInvalidate;
        FlipData flip = CoflCore.flipHandler.fds.getFlipById(args[1]);
        boolean bl = shouldInvalidate = args.length >= 3 && args[2].equals("true");
        if (flip == null) {
            CoflCore.flipHandler.lastClickedFlipMessage = "";
            EventBus.getDefault().post(new OnOpenAuctionGUI("/viewauction " + args[1], null));
            return;
        }
        String oneLineMessage = String.join((CharSequence)" ", flip.getMessageAsString()).replaceAll("\n", "").split(",\u00a77 sellers ah")[0];
        if (shouldInvalidate) {
            CoflCore.flipHandler.fds.InvalidateFlip(flip);
        }
        CoflCore.flipHandler.lastClickedFlipMessage = oneLineMessage;
        EventBus.getDefault().post(new OnOpenAuctionGUI("/viewauction " + flip.Id, flip));
    }

    public static void setGUI(String[] args) {
        if (args.length != 2) {
            EventBus.getDefault().post(new OnModChatMessage("[\u00a71C\u00a76oflnet\u00a7f]\u00a77: \u00a77Available GUIs:"));
            EventBus.getDefault().post(new OnModChatMessage("[\u00a71C\u00a76oflnet\u00a7f]\u00a77: \u00a77Cofl"));
            EventBus.getDefault().post(new OnModChatMessage("[\u00a71C\u00a76oflnet\u00a7f]\u00a77: \u00a77TFM"));
            EventBus.getDefault().post(new OnModChatMessage("[\u00a71C\u00a76oflnet\u00a7f]\u00a77: \u00a77Off"));
            return;
        }
        if (args[1].equalsIgnoreCase("cofl")) {
            CoflCore.config.purchaseOverlay = GUIType.COFL;
            EventBus.getDefault().post(new OnModChatMessage("[\u00a71C\u00a76oflnet\u00a7f]\u00a77: \u00a77Set \u00a7bPurchase Overlay \u00a77to: \u00a7fCofl"));
        }
        if (args[1].equalsIgnoreCase("tfm")) {
            CoflCore.config.purchaseOverlay = GUIType.TFM;
            EventBus.getDefault().post(new OnModChatMessage("[\u00a71C\u00a76oflnet\u00a7f]\u00a77: \u00a77Set \u00a7bPurchase Overlay \u00a77to: \u00a7fTFM"));
        }
        if (args[1].equalsIgnoreCase("off") || args[1].equalsIgnoreCase("false")) {
            CoflCore.config.purchaseOverlay = null;
            EventBus.getDefault().post(new OnModChatMessage("[\u00a71C\u00a76oflnet\u00a7f]\u00a77: \u00a77Set \u00a7bPurchase Overlay \u00a77to: \u00a7fOff"));
        }
    }

    public static void closeGUI() {
        EventBus.getDefault().post(new OnCloseGUI());
    }

    private static void getInventory() {
        EventBus.getDefault().post(new OnGetInventory());
    }
}

