/*
 * Decompiled with CFR 0.152.
 */
package CoflCore.network;

import CoflCore.CoflCore;
import CoflCore.classes.Countdown;
import CoflCore.classes.Position;
import CoflCore.classes.Sound;
import CoflCore.commands.Command;
import CoflCore.commands.JsonStringCommand;
import CoflCore.commands.RawCommand;
import CoflCore.commands.models.ChatMessageData;
import CoflCore.commands.models.FlipData;
import CoflCore.commands.models.HotkeyRegister;
import CoflCore.commands.models.ProxyRequest;
import CoflCore.configuration.ConfigurationManager;
import CoflCore.events.OnChatMessageReceive;
import CoflCore.events.OnCountdownReceive;
import CoflCore.events.OnExecuteCommand;
import CoflCore.events.OnFlipReceive;
import CoflCore.events.OnHighlightBlocks;
import CoflCore.events.OnModRequestReceive;
import CoflCore.events.OnPlaySoundReceive;
import CoflCore.events.OnWriteToChatReceive;
import CoflCore.events.ReceiveCommand;
import CoflCore.events.SocketClose;
import CoflCore.events.SocketError;
import CoflCore.network.NaiveSSLContext;
import CoflCore.proxy.ProxyManager;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import com.neovisionaries.ws.client.WebSocket;
import com.neovisionaries.ws.client.WebSocketAdapter;
import com.neovisionaries.ws.client.WebSocketException;
import com.neovisionaries.ws.client.WebSocketFactory;
import com.neovisionaries.ws.client.WebSocketFrame;
import com.neovisionaries.ws.client.WebSocketState;
import java.io.IOException;
import java.net.URI;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import org.greenrobot.eventbus.EventBus;

public class WSClient
extends WebSocketAdapter {
    public static Gson gson;
    private static final ProxyManager proxyManager;
    public URI uri;
    private WebSocket socket;
    public boolean shouldRun = false;
    public WebSocketState currentState = WebSocketState.CLOSED;

    public WSClient(URI uri) {
        this.uri = uri;
    }

    public void start() throws IOException, WebSocketException, NoSuchAlgorithmException {
        WebSocketFactory factory = new WebSocketFactory();
        factory.setVerifyHostname(false);
        factory.setSSLContext(NaiveSSLContext.getInstance("TLSv1.2"));
        factory.setConnectionTimeout(10000);
        this.socket = factory.createSocket(this.uri);
        this.socket.addListener(this);
        this.socket.connect();
    }

    public void stop() {
        System.out.println("Closing Socket");
        if (this.socket == null) {
            return;
        }
        this.socket.clearListeners();
        this.socket.disconnect();
        System.out.println("Socket closed");
    }

    @Override
    public void onStateChanged(WebSocket websocket, WebSocketState newState) throws Exception {
        System.out.println("WebSocket Changed state to: " + (Object)((Object)newState));
        this.currentState = newState;
        if (newState == WebSocketState.CLOSED && this.shouldRun) {
            CoflCore.Wrapper.restartWebsocketConnection();
        }
        super.onStateChanged(websocket, newState);
    }

    @Override
    public void onTextMessage(WebSocket websocket, String text) throws Exception {
        System.out.println("Received: " + text);
        JsonStringCommand body = gson.fromJson(text, JsonStringCommand.class);
        if (body.getType() == null) {
            System.out.println("Received a unknown command: " + text);
            return;
        }
        WSClient.HandleCommand(body);
    }

    public static void HandleCommand(JsonStringCommand body) {
        EventBus.getDefault().post(new ReceiveCommand(body));
        switch (body.getType()) {
            case Flip: {
                EventBus.getDefault().post(new OnFlipReceive(body.GetAs(new TypeToken<FlipData>(){}).getData()));
                break;
            }
            case ChatMessage: {
                EventBus.getDefault().post(new OnChatMessageReceive(body.GetAs(new TypeToken<ChatMessageData[]>(){}).getData()));
                break;
            }
            case PrivacySettings: {
                new ConfigurationManager().UpdateConfiguration((String)body.getData());
                break;
            }
            case WriteToChat: {
                EventBus.getDefault().post(new OnWriteToChatReceive(body.GetAs(new TypeToken<ChatMessageData>(){}).getData()));
                break;
            }
            case Execute: {
                EventBus.getDefault().post(new OnExecuteCommand(body.GetAs(new TypeToken<String>(){}).getData()));
                break;
            }
            case Countdown: {
                EventBus.getDefault().post(new OnCountdownReceive(body.GetAs(new TypeToken<Countdown>(){}).getData()));
                break;
            }
            case GetMods: {
                EventBus.getDefault().post(new OnModRequestReceive());
                break;
            }
            case PlaySound: {
                EventBus.getDefault().post(new OnPlaySoundReceive(body.GetAs(new TypeToken<Sound>(){}).getData()));
                break;
            }
            case HighlightBlocks: {
                EventBus.getDefault().post(new OnHighlightBlocks(body.GetAs(new TypeToken<List<Position>>(){}).getData()));
                break;
            }
            case RegisterKeybind: {
                EventBus.getDefault().post(body.GetAs(new TypeToken<HotkeyRegister[]>(){}).getData());
                break;
            }
            case ProxyRequest: {
                ProxyRequest[] proxyRequests;
                for (ProxyRequest req : proxyRequests = body.GetAs(new TypeToken<ProxyRequest[]>(){}).getData()) {
                    proxyManager.handleRequestAsync(req);
                }
                break;
            }
        }
    }

    @Override
    public void onDisconnected(WebSocket websocket, WebSocketFrame serverCloseFrame, WebSocketFrame clientCloseFrame, boolean closedByServer) {
        EventBus.getDefault().post(new SocketClose());
        CoflCore.Wrapper = null;
    }

    @Override
    public void onError(WebSocket websocket, WebSocketException cause) {
        EventBus.getDefault().post(new SocketError(cause));
    }

    public void SendCommand(Command cmd) {
        this.SendCommand(new RawCommand(cmd.getType().ToJson(), gson.toJson(cmd.getData())));
    }

    public void SendCommand(RawCommand cmd) {
        this.Send(cmd);
    }

    public void Send(Object obj) {
        String json = gson.toJson(obj);
        System.out.println("###Sending message of json value " + json);
        if (this.socket == null) {
            try {
                this.start();
            }
            catch (Exception e) {
                System.out.println("Ran into an error on implicit start for send: " + e);
            }
        }
        this.socket.sendText(json);
    }

    static {
        proxyManager = new ProxyManager();
        gson = new GsonBuilder().create();
    }
}

