/*
 * Decompiled with CFR 0.152.
 */
package CoflCore.network;

import CoflCore.commands.Command;
import CoflCore.commands.RawCommand;
import CoflCore.events.OnModChatMessage;
import CoflCore.misc.SessionManager;
import CoflCore.network.WSClient;
import com.neovisionaries.ws.client.WebSocketException;
import java.io.IOException;
import java.net.URI;
import java.security.NoSuchAlgorithmException;
import org.greenrobot.eventbus.EventBus;

public class WSClientWrapper {
    public WSClient socket;
    public boolean isRunning;
    private String[] uris;

    public WSClientWrapper(String[] uris) {
        this.uris = uris;
    }

    public void restartWebsocketConnection() {
        this.socket.stop();
        System.out.println("Sleeping...");
        EventBus.getDefault().post(new OnModChatMessage("Lost connection to Coflnet, trying to reestablish the connection in 2 Seconds..."));
        this.socket = new WSClient(this.socket.uri);
        this.isRunning = false;
        while (!this.isRunning) {
            this.start();
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        this.socket.shouldRun = true;
    }

    public boolean startConnection(String username) {
        if (this.isRunning) {
            return false;
        }
        for (String s2 : this.uris) {
            System.out.println("Trying connection with uri=" + s2);
            if (!this.initializeNewSocket(s2, username)) continue;
            return true;
        }
        EventBus.getDefault().post("Cofl could not establish a connection to any server!\nIf you use a vpn/proxy please try connecting without it.\nIf that does not work please contact us on our ");
        return false;
    }

    public boolean initializeNewSocket(String uriPrefix, String username) {
        String uri = uriPrefix;
        uri = uri + "?version=1.7.0";
        uri = uri + "&player=" + username;
        try {
            SessionManager.UpdateCoflSessions();
            String coflSessionID = SessionManager.GetCoflSession((String)username).SessionUUID;
            uri = uri + "&SId=" + coflSessionID;
            if (this.socket != null) {
                this.socket.stop();
            }
            this.socket = new WSClient(URI.create(uri));
            this.isRunning = false;
            boolean successfull = this.start();
            if (successfull) {
                this.socket.shouldRun = true;
            }
            return successfull;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    private synchronized boolean start() {
        if (!this.isRunning) {
            try {
                this.socket.start();
                this.isRunning = true;
                return true;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (WebSocketException e) {
                e.printStackTrace();
            }
            catch (NoSuchAlgorithmException e) {
                e.printStackTrace();
            }
            return false;
        }
        return false;
    }

    public synchronized void stop() {
        if (this.isRunning) {
            this.socket.shouldRun = false;
            this.socket.stop();
            this.isRunning = false;
            this.socket = null;
        }
    }

    public synchronized void SendMessage(RawCommand cmd) {
        if (this.isRunning) {
            this.socket.SendCommand(cmd);
        }
    }

    public synchronized void SendMessage(Command cmd) {
        if (this.isRunning) {
            this.socket.SendCommand(cmd);
        } else {
            System.err.println("Tried sending a callback to coflnet but failed. The connection must be closed. cmd: " + (Object)((Object)cmd.getType()));
        }
    }

    public String GetStatus() {
        return "" + this.isRunning + " " + (this.socket != null ? this.socket.currentState.toString() : "NOT_INITIALIZED");
    }
}

