/*
 * Decompiled with CFR 0.152.
 */
package CoflCore.proxy;

import CoflCore.CoflCore;
import CoflCore.commands.models.ProxyRequest;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class ProxyManager {
    private final String ProxyResponseUrl = "http://sky.coflnet.com/api/data/proxy";
    private final ExecutorService requestExecutor = Executors.newSingleThreadExecutor();

    public void handleRequestAsync(ProxyRequest request) {
        CompletableFuture<String> req = this.doRequest(request.getUrl());
        if (request.isUploadEnabled()) {
            req.thenAcceptAsync(res -> this.uploadData((String)res, request.getId()));
        }
    }

    private String getString(HttpURLConnection con) {
        try {
            int length;
            BufferedInputStream in = new BufferedInputStream(con.getInputStream());
            ByteArrayOutputStream result = new ByteArrayOutputStream();
            byte[] buffer = new byte[1024];
            while ((length = ((InputStream)in).read(buffer)) != -1) {
                result.write(buffer, 0, length);
            }
            String resString = result.toString("UTF-8");
            return resString;
        }
        catch (IOException e) {
            return null;
        }
    }

    public void uploadData(final String data, final String id) {
        this.requestExecutor.submit(new Runnable(){

            @Override
            public void run() {
                try {
                    URL url = new URL("http://sky.coflnet.com/api/data/proxy");
                    HttpURLConnection con = (HttpURLConnection)url.openConnection();
                    con.setRequestMethod("POST");
                    con.setRequestProperty("X-Request-Id", id);
                    con.setDoOutput(true);
                    con.setDoInput(true);
                    OutputStream os = con.getOutputStream();
                    os.write(data.getBytes("UTF-8"));
                    os.close();
                    String response = ProxyManager.this.getString(con);
                    System.out.println("Response=" + response);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        });
    }

    private CompletableFuture<String> doRequest(final String targetUrl) {
        final CompletableFuture<String> future = new CompletableFuture<String>();
        this.requestExecutor.submit(new Runnable(){

            @Override
            public void run() {
                try {
                    URL url = new URL(targetUrl);
                    HttpURLConnection con = (HttpURLConnection)url.openConnection();
                    con.setRequestMethod("GET");
                    con.setRequestProperty("Accept", "application/json");
                    con.setRequestProperty("User-Agent", "CoflMod");
                    String key = CoflCore.getAPIKeyManager().getApiInfo().key;
                    if (targetUrl.startsWith("https://api.hypixel.net") && !key.isEmpty()) {
                        con.setRequestProperty("API-Key", key);
                    }
                    con.setDoInput(true);
                    future.complete(ProxyManager.this.getString(con));
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        });
        return future;
    }
}

