/*
 * Decompiled with CFR 0.152.
 */
package de.torui.coflsky;

import CoflCore.CoflCore;
import CoflCore.commands.Command;
import CoflCore.commands.RawCommand;
import CoflCore.commands.models.ChatMessageData;
import CoflCore.commands.models.ModListData;
import CoflCore.commands.models.ProxyRequest;
import CoflCore.commands.models.SoundData;
import CoflCore.events.OnChatMessageReceive;
import CoflCore.events.OnCloseGUI;
import CoflCore.events.OnCountdownReceive;
import CoflCore.events.OnExecuteCommand;
import CoflCore.events.OnFlipReceive;
import CoflCore.events.OnGetInventory;
import CoflCore.events.OnHighlightBlocks;
import CoflCore.events.OnModChatMessage;
import CoflCore.events.OnOpenAuctionGUI;
import CoflCore.events.OnPlaySoundReceive;
import CoflCore.events.OnWriteToChatReceive;
import CoflCore.events.ReceiveCommand;
import CoflCore.proxy.ProxyManager;
import com.google.gson.Gson;
import de.torui.coflsky.gui.bingui.BinGuiManager;
import de.torui.coflsky.handlers.EventRegistry;
import de.torui.coflsky.handlers.ForgeDescriptionHandler;
import de.torui.coflsky.minecraft_integration.CountdownTimer;
import de.torui.coflsky.utils.FileUtils;
import java.io.File;
import java.util.Arrays;
import java.util.stream.Stream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.audio.SoundHandler;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.event.ClickEvent;
import net.minecraft.event.HoverEvent;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.ChatStyle;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.ClientCommandHandler;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import org.greenrobot.eventbus.Subscribe;

public class WSCommandHandler {
    public static transient String lastOnClickEvent;
    private static final ModListData modListData;
    private static final Gson gson;
    private static final ProxyManager proxyManager;
    public static int[][] highlightCoordinates;

    @Subscribe
    public void onReceiveCommand(ReceiveCommand event) {
    }

    @Subscribe
    public void onFlipReceive(OnFlipReceive event) {
        ChatMessageData[] messages = event.FlipData.Messages;
        SoundData sound = event.FlipData.Sound;
        if (sound != null && sound.Name != null) {
            WSCommandHandler.PlaySound(sound.Name, sound.Pitch);
        }
        WSCommandHandler.ChatMessage(messages);
        CoflCore.flipHandler.fds.Insert(event.FlipData);
        EventRegistry.onAfterKeyPressed();
    }

    @Subscribe
    public void onChatMessage(OnChatMessageReceive event) {
        WSCommandHandler.ChatMessage(event.ChatMessages);
    }

    @Subscribe
    public void onModChatMessage(OnModChatMessage event) {
        WSCommandHandler.ChatMessage(new ChatMessageData[]{new ChatMessageData(event.message, null, null)});
    }

    @Subscribe
    public void onChatMessageDataReceive(OnWriteToChatReceive event) {
        WSCommandHandler.ChatMessage(new ChatMessageData[]{event.ChatMessage});
    }

    @Subscribe
    public void onPlaySoundReceive(OnPlaySoundReceive event) {
        if (event.Sound == null || event.Sound.getSoundName() == null) {
            return;
        }
        String soundName = event.Sound.getSoundName();
        float pitch = event.Sound.getSoundPitch().intValue();
        WSCommandHandler.PlaySound(soundName, pitch);
    }

    @Subscribe
    public void onCountdownReceive(OnCountdownReceive event) {
        CountdownTimer.startCountdown(event.CountdownData);
    }

    @Subscribe
    public void onOpenAuctionGUI(OnOpenAuctionGUI event) {
        BinGuiManager.openNewFlipGui(event.flip.getMessageAsString().replaceAll("\n", "").split(",\u00a77 sellers ah")[0], event.flip.Render);
        Minecraft.func_71410_x().field_71439_g.func_71165_d("/viewauction " + event.flip.Id);
    }

    @Subscribe
    public void onExecuteCommand(OnExecuteCommand event) {
        WSCommandHandler.Execute(event.Command, (Entity)Minecraft.func_71410_x().field_71439_g);
    }

    @Subscribe
    public void onCloseGUI(OnCloseGUI event) {
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71462_r != null) {
            mc.func_147108_a(null);
        }
    }

    @Subscribe
    public void onGetInventory(OnGetInventory event) {
        ForgeDescriptionHandler.uploadInventory();
    }

    @Subscribe
    public void onHighlightBlocks(OnHighlightBlocks event) {
        highlightCoordinates = new int[event.positions.size()][];
        for (int i = 0; i < event.positions.size(); ++i) {
            WSCommandHandler.highlightCoordinates[i] = new int[]{event.positions.get(i).getX(), event.positions.get(i).getY(), event.positions.get(i).getZ()};
        }
    }

    private static void handleProxyRequest(ProxyRequest[] request) {
        for (ProxyRequest req : request) {
            proxyManager.handleRequestAsync(req);
        }
    }

    public static void cacheMods() {
        File modFolder = new File(Minecraft.func_71410_x().field_71412_D, "mods");
        for (File mods : modFolder.listFiles()) {
            if (mods.isDirectory()) continue;
            modListData.addFilename(mods.getName());
            try {
                modListData.addFileHashes(FileUtils.getSha256Checksum(mods));
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        for (ModContainer mod : Loader.instance().getModList()) {
            modListData.addModname(mod.getName());
            modListData.addModname(mod.getModId());
        }
    }

    private static void getMods() {
        CoflCore.Wrapper.SendMessage(new RawCommand("foundMods", gson.toJson(modListData)));
    }

    private static void PlaySound(String soundName, float pitch) {
        SoundHandler handler = Minecraft.func_71410_x().func_147118_V();
        PositionedSoundRecord psr = PositionedSoundRecord.func_147674_a((ResourceLocation)new ResourceLocation(soundName), (float)pitch);
        handler.func_147682_a((ISound)psr);
    }

    private static void Execute(Command<String> cmd, Entity sender) {
        System.out.println("Execute: " + cmd.getData() + " sender:" + sender);
        WSCommandHandler.Execute(cmd.getData(), sender);
    }

    public static void Execute(String cmd, Entity sender) {
        if (cmd.startsWith("/cofl") || cmd.startsWith("http")) {
            ClientCommandHandler.instance.func_71556_a((ICommandSender)sender, cmd);
        } else {
            Minecraft.func_71410_x().field_71439_g.func_71165_d(cmd);
        }
    }

    private static IChatComponent CommandToChatComponent(ChatMessageData wcmd, String fullMessage) {
        if (wcmd.OnClick != null) {
            lastOnClickEvent = wcmd.Text != null && wcmd.OnClick.startsWith("/viewauction") ? "/cofl openauctiongui " + wcmd.OnClick.split(" ")[1] + " false" : "/cofl callback " + wcmd.OnClick;
        }
        if (wcmd.Text != null) {
            ChatComponentText comp = new ChatComponentText(wcmd.Text);
            if (wcmd.OnClick != null) {
                ChatStyle style = wcmd.OnClick.startsWith("http") ? new ChatStyle().func_150241_a(new ClickEvent(ClickEvent.Action.OPEN_URL, wcmd.OnClick)) : (wcmd.OnClick.startsWith("suggest:") ? new ChatStyle().func_150241_a(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, wcmd.OnClick.substring(8))) : (wcmd.OnClick.startsWith("copy:") ? new ChatStyle().func_150241_a(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/cofl copyToClipboard " + wcmd.OnClick.substring(5))) : new ChatStyle().func_150241_a(new ClickEvent(ClickEvent.Action.RUN_COMMAND, lastOnClickEvent))));
                comp.func_150255_a(style);
            }
            if (wcmd.Hover != null && !wcmd.Hover.isEmpty()) {
                if (comp.func_150256_b() == null) {
                    comp.func_150255_a(new ChatStyle());
                }
                comp.func_150256_b().func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (IChatComponent)new ChatComponentText(wcmd.Hover)));
            }
            return comp;
        }
        return null;
    }

    public static void sendChatMessage(IChatComponent message) {
        Minecraft.func_71410_x().field_71439_g.func_145747_a(message);
    }

    public static IChatComponent ChatMessage(ChatMessageData[] array) {
        ChatComponentText master = new ChatComponentText("");
        String fullMessage = WSCommandHandler.ChatMessageDataToString(array);
        for (ChatMessageData wcmd : array) {
            IChatComponent comp = WSCommandHandler.CommandToChatComponent(wcmd, fullMessage);
            if (comp == null) continue;
            master.func_150257_a(comp);
        }
        Minecraft.func_71410_x().field_71439_g.func_145747_a((IChatComponent)master);
        return master;
    }

    private static void WriteToChat(Command<ChatMessageData> cmd) {
        ChatMessageData wcmd = cmd.getData();
        IChatComponent comp = WSCommandHandler.CommandToChatComponent(wcmd, wcmd.Text);
        if (comp != null) {
            Minecraft.func_71410_x().field_71439_g.func_145747_a(comp);
        }
    }

    public static String ChatMessageDataToString(ChatMessageData[] messages) {
        Stream<String> stream = Arrays.stream(messages).map(message -> message.Text);
        String s2 = String.join((CharSequence)",", (CharSequence[])stream.toArray(String[]::new));
        stream.close();
        return s2;
    }

    static {
        modListData = new ModListData();
        gson = new Gson();
        proxyManager = new ProxyManager();
        highlightCoordinates = new int[0][];
    }
}

