/*
 * Decompiled with CFR 0.152.
 */
package de.torui.coflsky.handlers;

import CoflCore.classes.Position;
import CoflCore.handlers.DescriptionHandler;
import de.torui.coflsky.handlers.ChestUtils;
import de.torui.coflsky.minecraft_integration.PlayerDataProvider;
import de.torui.coflsky.utils.ReflectionUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.invoke.MethodHandle;
import java.util.ArrayList;
import java.util.Base64;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.inventory.GuiChest;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.inventory.ContainerChest;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.BlockPos;
import net.minecraftforge.client.event.GuiOpenEvent;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;

public class ForgeDescriptionHandler {
    public static String allItemIds;
    public static final NBTTagCompound EMPTY_COMPOUND;
    private boolean IsOpen = true;
    private boolean shouldUpdate = false;
    public static MethodHandle xSizeField;
    public static MethodHandle ySizeField;

    public void Close() {
        this.IsOpen = false;
    }

    public static String ExtractStackableIdFromItemStack(ItemStack stack) {
        if (stack != null) {
            try {
                NBTTagCompound serialized = stack.serializeNBT();
                String name = serialized.func_74775_l("tag").func_74775_l("display").func_74779_i("Name");
                return name + ":" + stack.field_77994_a;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return "";
    }

    public static String ExtractIdFromItemStack(ItemStack stack) {
        if (stack != null) {
            try {
                String uuid = stack.serializeNBT().func_74775_l("tag").func_74775_l("ExtraAttributes").func_74779_i("uuid");
                if (uuid.length() == 0) {
                    throw new Exception();
                }
                return uuid;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return ForgeDescriptionHandler.ExtractStackableIdFromItemStack(stack);
    }

    private DescriptionHandler.DescModification[] getTooltipData(ItemStack itemStack) {
        String id = ForgeDescriptionHandler.ExtractIdFromItemStack(itemStack);
        return DescriptionHandler.getTooltipData(id);
    }

    public void loadDescriptionAndListenForChanges(GuiOpenEvent event) {
        GuiContainer gc = (GuiContainer)event.gui;
        this.shouldUpdate = ForgeDescriptionHandler.loadDescriptionForInventory(event, gc, false);
        int iteration = 1;
        while (this.IsOpen) {
            try {
                Thread.sleep(300 * iteration++);
                ++iteration;
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            if (!this.IsOpen) break;
            if (this.shouldUpdate || ForgeDescriptionHandler.hasAnyStackChanged(gc)) {
                this.shouldUpdate = ForgeDescriptionHandler.loadDescriptionForInventory(event, gc, true);
                iteration = 5;
            }
            if (iteration < 30) continue;
            iteration = 29;
        }
    }

    private static boolean hasAnyStackChanged(GuiContainer gc) {
        return !allItemIds.equals(ForgeDescriptionHandler.getCurrentInventoryIds(gc));
    }

    private static String getCurrentInventoryIds(GuiContainer gc) {
        StringBuilder builder = new StringBuilder();
        for (Slot obj : gc.field_147002_h.field_75151_b) {
            ItemStack stack = obj.func_75211_c();
            String id = ForgeDescriptionHandler.ExtractIdFromItemStack(stack);
            builder.append(id);
        }
        return builder.toString();
    }

    public static void uploadInventory() {
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71439_g == null || mc.field_71439_g.field_71071_by == null) {
            return;
        }
        NBTTagCompound compound = new NBTTagCompound();
        NBTTagList tl = new NBTTagList();
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        ArrayList<String> itemIds = new ArrayList<String>();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        for (int i = 0; i < mc.field_71439_g.field_71071_by.func_70302_i_(); ++i) {
            ItemStack stack = mc.field_71439_g.field_71071_by.func_70301_a(i);
            String id = ForgeDescriptionHandler.ExtractIdFromItemStack(stack);
            itemIds.add(id);
            items.add(stack);
            if (stack != null) {
                tl.func_74742_a((NBTBase)stack.serializeNBT());
                continue;
            }
            tl.func_74742_a((NBTBase)EMPTY_COMPOUND);
        }
        try {
            compound.func_74782_a("i", (NBTBase)tl);
            CompressedStreamTools.func_74799_a((NBTTagCompound)compound, (OutputStream)baos);
            DescriptionHandler.loadDescriptionForInventory(itemIds.toArray(new String[0]), "Crafting", Base64.getEncoder().encodeToString(baos.toByteArray()), PlayerDataProvider.getUsername());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static boolean loadDescriptionForInventory(GuiOpenEvent event, GuiContainer gc, boolean skipLoadCheck) {
        InventoryWrapper wrapper = new InventoryWrapper();
        Position pos = null;
        if (event.gui != null && event.gui instanceof GuiChest) {
            ContainerChest chest;
            IInventory inv;
            if (!skipLoadCheck) {
                ForgeDescriptionHandler.waitForChestContentLoad(event, gc);
            }
            if ((inv = (chest = (ContainerChest)((GuiChest)event.gui).field_147002_h).func_85151_d()).func_145818_k_()) {
                Object chestName;
                wrapper.chestName = chestName = inv.func_70005_c_();
                BlockPos chestPos = ChestUtils.getLookedAtChest();
                if (chestPos != null && ((String)chestName).endsWith("hest")) {
                    pos = new Position(chestPos.func_177958_n(), chestPos.func_177956_o(), chestPos.func_177952_p());
                }
            }
        }
        allItemIds = ForgeDescriptionHandler.getCurrentInventoryIds(gc);
        NBTTagCompound compound = new NBTTagCompound();
        NBTTagList tl = new NBTTagList();
        for (Slot obj : gc.field_147002_h.field_75151_b) {
            ItemStack stack = obj.func_75211_c();
            if (stack != null) {
                tl.func_74742_a((NBTBase)stack.serializeNBT());
                continue;
            }
            tl.func_74742_a((NBTBase)EMPTY_COMPOUND);
        }
        boolean shouldGetRefreshed = false;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            compound.func_74782_a("i", (NBTBase)tl);
            CompressedStreamTools.func_74799_a((NBTTagCompound)compound, (OutputStream)baos);
            wrapper.fullInventoryNbt = Base64.getEncoder().encodeToString(baos.toByteArray());
            ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
            ArrayList<String> itemIds = new ArrayList<String>();
            for (Slot obj : gc.field_147002_h.field_75151_b) {
                ItemStack stack = obj.func_75211_c();
                stacks.add(stack);
                String id = ForgeDescriptionHandler.ExtractIdFromItemStack(stack);
                itemIds.add(id);
            }
            System.out.println("Loading description for inventory: " + wrapper.chestName + " with " + itemIds.size() + " items");
            DescriptionHandler.loadDescriptionForInventory(itemIds.toArray(new String[0]), wrapper.chestName, wrapper.fullInventoryNbt, PlayerDataProvider.getUsername(), pos);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return shouldGetRefreshed;
    }

    private static void waitForChestContentLoad(GuiOpenEvent event, GuiContainer gc) {
        for (int i = 1; i < 10 && ((Slot)gc.field_147002_h.field_75151_b.get(gc.field_147002_h.field_75151_b.size() - 37)).func_75211_c() == null; ++i) {
            try {
                Thread.sleep(20 * i);
                continue;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    public void setTooltips(ItemTooltipEvent event) {
        DescriptionHandler.DescModification[] data = this.getTooltipData(event.itemStack);
        if (data == null || data.length == 0) {
            return;
        }
        block12: for (DescriptionHandler.DescModification datum : data) {
            if (event.toolTip.size() <= datum.line) {
                System.out.println("Skipped line modification " + datum.line + " for " + event.itemStack.func_82833_r());
                continue;
            }
            switch (datum.type) {
                case "APPEND": {
                    event.toolTip.add(datum.value);
                    continue block12;
                }
                case "REPLACE": {
                    event.toolTip.set(datum.line, datum.value);
                    continue block12;
                }
                case "INSERT": {
                    event.toolTip.add(datum.line, datum.value);
                    continue block12;
                }
                case "DELETE": {
                    event.toolTip.remove(datum.line);
                }
            }
        }
    }

    public void highlightSlots(GuiScreenEvent.BackgroundDrawnEvent event) {
        if (!(event.gui instanceof GuiContainer)) {
            return;
        }
        GuiContainer containerGui = (GuiContainer)event.gui;
        for (Slot inventorySlot : containerGui.field_147002_h.field_75151_b) {
            DescriptionHandler.DescModification[] tooltipData;
            if (!inventorySlot.func_75216_d()) continue;
            for (DescriptionHandler.DescModification modification : tooltipData = this.getTooltipData(inventorySlot.func_75211_c())) {
                if (!"HIGHLIGHT".equals(modification.type)) continue;
                int color = (int)(Long.parseLong(modification.value, 16) & 0xFFFFFFFFL);
                try {
                    int guiTop = (containerGui.field_146295_m - ySizeField.invokeExact(containerGui)) / 2;
                    int guiLeft = (containerGui.field_146294_l - xSizeField.invokeExact(containerGui)) / 2;
                    int slotX = inventorySlot.field_75223_e + guiLeft;
                    int slotY = inventorySlot.field_75221_f + guiTop;
                    GlStateManager.func_179094_E();
                    GlStateManager.func_179137_b((double)0.0, (double)0.0, (double)0.1);
                    Gui.func_73734_a((int)slotX, (int)slotY, (int)(slotX + 16), (int)(slotY + 16), (int)(modification.value.length() > 6 ? color : color | 0xFF000000));
                    GlStateManager.func_179121_F();
                }
                catch (Throwable e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    public static void emptyTooltipData() {
    }

    static {
        EMPTY_COMPOUND = new NBTTagCompound();
        xSizeField = ReflectionUtil.getField(GuiContainer.class, "xSize", "field_146999_f", "f");
        ySizeField = ReflectionUtil.getField(GuiContainer.class, "ySize", "field_147000_g", "g");
    }

    private static class InventoryWrapper {
        public String chestName;
        public String fullInventoryNbt;

        private InventoryWrapper() {
        }
    }
}

