/*
 * Decompiled with CFR 0.152.
 */
package net.mt1006.metalfences.blocks;

import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.WeatheringCopper;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.mt1006.metalfences.MetalFencesBlockAccessor;
import org.jetbrains.annotations.NotNull;

public class WeatheringCopperFenceBlock
extends FenceBlock
implements WeatheringCopper {
    private final WeatheringCopper.WeatherState weatherState;

    public WeatheringCopperFenceBlock(WeatheringCopper.WeatherState weatherState, BlockBehaviour.Properties properties) {
        super(properties);
        this.weatherState = weatherState;
    }

    protected void randomTick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        this.changeOverTime(state, level, pos, random);
    }

    protected boolean isRandomlyTicking(BlockState state) {
        return MetalFencesBlockAccessor.nextWeathered(state.getBlock()) != null;
    }

    @NotNull
    public Optional<BlockState> getNext(BlockState blockState) {
        Block nextBlock = MetalFencesBlockAccessor.nextWeathered(blockState.getBlock());
        return nextBlock != null ? Optional.of(nextBlock.withPropertiesOf(blockState)) : Optional.empty();
    }

    @NotNull
    public WeatheringCopper.WeatherState getAge() {
        return this.weatherState;
    }

    @NotNull
    protected InteractionResult useItemOn(ItemStack itemStack, BlockState blockState, Level level, BlockPos blockPos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        InteractionResult result = MetalFencesBlockAccessor.useItemOnWeathering(itemStack, blockState, level, blockPos, player, hand);
        return result != null ? result : super.useItemOn(itemStack, blockState, level, blockPos, player, hand, hitResult);
    }
}

