/*
 * Decompiled with CFR 0.152.
 */
package me.kokko.tradingcards;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import me.kokko.tradingcards.CardLoot;
import me.kokko.tradingcards.ConfigManager;
import me.kokko.tradingcards.PluginTradingCards;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.LivingEntity;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class CardDrop {
    private static final ConfigurationSection dropTables;
    private static final ConfigurationSection dropGroupsConfig;
    private static String dropSelector;
    private static final Set<Location> dropLocations;
    private static final Map<String, Set<String>> groupMembersCache;
    private static final Random random;

    public static void drop(LivingEntity entity) {
        String entityType = entity.getType().toString().toLowerCase();
        PluginTradingCards.info(3, "<CardDrop> (drop) entity.type = " + entityType);
        Location entityLocation = entity.getLocation().getBlock().getLocation();
        PluginTradingCards.info(3, "<CardDrop> (drop) entity.location = " + String.valueOf(entityLocation));
        if (entity.getKiller() == null) {
            return;
        }
        if (!CardDrop.hasDropLoot(entityType)) {
            return;
        }
        PluginTradingCards.info(3, "<CardDrop> (drop) dropSelector: " + dropSelector);
        boolean addedToLocationSet = dropLocations.add(entityLocation);
        PluginTradingCards.info(3, "<CardDrop> (drop) addedToLocationSet: " + addedToLocationSet);
        PluginTradingCards.info(3, "<CardDrop> (drop) dropLocations: " + String.valueOf(dropLocations));
        if (!addedToLocationSet) {
            return;
        }
        PluginTradingCards.info(4, "<CardDrop> (drop) !addedToLocationSet = false");
        long removeFromLocationSetDelay = (long)ConfigManager.getSetting().getInt("drop-location-delay-minutes", 60) * 20L * 60L;
        Bukkit.getScheduler().runTaskLater((Plugin)PluginTradingCards.getInstance(), () -> dropLocations.remove(entityLocation), removeFromLocationSetDelay);
        PluginTradingCards.info(3, "<CardDrop> (drop) removeFromLocationSetDelay: " + removeFromLocationSetDelay);
        ConfigurationSection mobDropLootConfig = dropTables.getConfigurationSection(dropSelector);
        List<ItemStack> dropLoot = mobDropLootConfig != null ? CardLoot.rand(random).loot(mobDropLootConfig) : Collections.emptyList();
        for (ItemStack item : dropLoot) {
            entityLocation.getWorld().dropItemNaturally(entityLocation, item);
        }
    }

    private static boolean hasDropLoot(String entityType) {
        if (dropTables == null) {
            return false;
        }
        if (dropTables.contains(entityType)) {
            dropSelector = entityType;
            return true;
        }
        if (dropGroupsConfig == null) {
            return false;
        }
        for (String group : dropGroupsConfig.getKeys(false)) {
            Set groupMembers = groupMembersCache.computeIfAbsent(group, g -> {
                HashSet<String> lowercaseGroupMembers = new HashSet<String>();
                for (String member : dropGroupsConfig.getStringList(group)) {
                    lowercaseGroupMembers.add(member.toLowerCase());
                }
                return lowercaseGroupMembers;
            });
            if (!groupMembers.contains(entityType) || !dropTables.contains(group)) continue;
            dropSelector = group;
            break;
        }
        return dropSelector != null;
    }

    static {
        dropLocations = new HashSet<Location>();
        groupMembersCache = new HashMap<String, Set<String>>();
        random = new Random(PluginTradingCards.getTimeSeed());
        FileConfiguration dropsConfig = ConfigManager.getConfig("drops");
        dropTables = dropsConfig.getConfigurationSection("drop");
        dropGroupsConfig = dropsConfig.getConfigurationSection("group");
    }
}

