/*
 * Decompiled with CFR 0.152.
 */
package me.kokko.tradingcards;

import java.util.List;
import me.kokko.tradingcards.CardDrop;
import me.kokko.tradingcards.CardPack;
import me.kokko.tradingcards.CardsInventory;
import me.kokko.tradingcards.ConfigManager;
import me.kokko.tradingcards.PluginTradingCards;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class CardEvents
implements Listener {
    private PersistentDataContainer dataContainer;

    public CardEvents() {
        PluginTradingCards.info(3, "<CardEvents> (constructor) CardEvents constructed");
    }

    @EventHandler
    public void onPlayerInteract(PlayerInteractEvent event) {
        if (!event.getAction().isRightClick()) {
            return;
        }
        PluginTradingCards.info(3, "<CardEvents> (onPlayerInteract) Event action: " + String.valueOf(event.getAction()));
        PluginTradingCards.info(3, "<CardEvents> (onPlayerInteract) Event hand: " + String.valueOf(event.getHand()));
        Player player = event.getPlayer();
        ItemStack itemInHand = player.getInventory().getItemInMainHand();
        ItemMeta itemInHandMeta = itemInHand.getItemMeta();
        if (itemInHandMeta == null) {
            return;
        }
        this.dataContainer = itemInHandMeta.getPersistentDataContainer();
        String cardAlbumOwner = this.getDataKey(this.dataContainer, "card-album");
        if (cardAlbumOwner != null) {
            this.handleAlbum(player, cardAlbumOwner);
            event.setCancelled(true);
            return;
        }
        String cardPackId = this.getDataKey(this.dataContainer, "card-pack");
        if (cardPackId != null) {
            this.handlePack(player, cardPackId);
            event.setCancelled(true);
            return;
        }
        PluginTradingCards.info(3, "<CardEvents> (onPlayerInteract) Player has finished interacting with right-click");
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        if (!(event.getInventory().getHolder() instanceof CardsInventory)) {
            return;
        }
        ItemStack clickedItem = event.getCurrentItem();
        if (clickedItem == null || clickedItem.getType().isAir()) {
            return;
        }
        this.dataContainer = clickedItem.getItemMeta().getPersistentDataContainer();
        if (this.hasDataKey(this.dataContainer, "card-id")) {
            return;
        }
        event.getWhoClicked().sendMessage(ConfigManager.message("trading-cards-only"));
        event.setCancelled(true);
    }

    @EventHandler
    public void onEntityDeath(EntityDeathEvent event) {
        LivingEntity entity = event.getEntity();
        if (ConfigManager.hasFeature("drop-loot")) {
            CardDrop.drop(entity);
        }
    }

    private void handleAlbum(Player player, String cardAlbumOwner) {
        CardsInventory playerInventory = CardsInventory.map.get(cardAlbumOwner);
        if (playerInventory == null) {
            PluginTradingCards.info(3, "<CardEvents> (handleAlbum) creating new album");
            playerInventory = new CardsInventory(54, cardAlbumOwner);
            CardsInventory.map.put(cardAlbumOwner, playerInventory);
        }
        PluginTradingCards.info(3, "<CardEvents> (handleAlbum) albumOwner: " + cardAlbumOwner);
        player.openInventory(playerInventory.getInventory());
    }

    private void handlePack(Player player, String cardPackId) {
        this.removeHeldItem(player);
        PluginTradingCards.info(3, "<CardEvents> (handlePack) " + player.getName() + " is opening a " + cardPackId);
        List<ItemStack> cards = CardPack.unpack(cardPackId, this.getSeed());
        for (ItemStack card : cards) {
            player.getInventory().addItem(new ItemStack[]{card});
        }
        PluginTradingCards.info(3, "<CardEvents> (handlePack) cardPackId: " + cardPackId);
    }

    private String getDataKey(PersistentDataContainer dataContainer, String key) {
        return (String)dataContainer.get(new NamespacedKey((Plugin)PluginTradingCards.getInstance(), key), PersistentDataType.STRING);
    }

    private boolean hasDataKey(PersistentDataContainer dataContainer, String key) {
        return dataContainer.has(new NamespacedKey((Plugin)PluginTradingCards.getInstance(), key), PersistentDataType.STRING);
    }

    private void removeHeldItem(Player player) {
        player.getInventory().removeItem(new ItemStack[]{player.getInventory().getItemInMainHand()});
    }

    private long getSeed() {
        return Long.parseUnsignedLong(this.getDataKey(this.dataContainer, "card-pack-seed"), 16);
    }
}

