/*
 * Decompiled with CFR 0.152.
 */
package me.kokko.tradingcards;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import me.kokko.tradingcards.CardPackStack;
import me.kokko.tradingcards.ConfigManager;
import me.kokko.tradingcards.PluginTradingCards;
import me.kokko.tradingcards.TradingCard;
import me.kokko.tradingcards.TradingCardStack;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.inventory.ItemStack;

public class CardLoot {
    private final Random random;
    private int amountMin;
    private int amountMax;
    private int amountTotal = 0;
    private final List<String> cardsNormal = new ArrayList<String>();
    private final List<String> cardsGlinty = new ArrayList<String>();
    private final List<String> cardsChance = new ArrayList<String>();
    private final List<String> cardPacks = new ArrayList<String>();

    public CardLoot(Random random) {
        this.random = random;
    }

    public static CardLoot rand(Random random) {
        return new CardLoot(random);
    }

    public List<ItemStack> loot(ConfigurationSection lootConfig) {
        if (this.evaluateChance(lootConfig.getInt("chance", 1))) {
            return Collections.emptyList();
        }
        if (lootConfig.contains("amount.min") || lootConfig.contains("amount.max")) {
            this.amountMin = lootConfig.getInt("amount.min", 1);
            this.amountMax = lootConfig.getInt("amount.max", 64);
        } else {
            this.amountMax = this.amountMin = lootConfig.getInt("amount", 8);
        }
        PluginTradingCards.info(3, "<CardLoot> (loot) amount.min = " + this.amountMin);
        PluginTradingCards.info(3, "<CardLoot> (loot) amount.max = " + this.amountMax);
        this.populatePack(lootConfig);
        return this.generateCardLoot();
    }

    private boolean evaluateChance(int chance) {
        PluginTradingCards.info(3, "<CardLoot> (evaluateChance) chance: " + chance);
        if (chance == 1) {
            return false;
        }
        return this.random.nextInt(chance) != 0;
    }

    private List<String> poolAvailableCards(ConfigurationSection slot) {
        int amount;
        Set<String> include = this.getCardsList(slot.getConfigurationSection("include"));
        Set<String> exclude = this.getCardsList(slot.getConfigurationSection("exclude"));
        if (include == null) {
            return Collections.emptyList();
        }
        if (exclude != null) {
            include.removeAll(exclude);
        }
        if ((amount = this.evaluateAmount(slot, include.size())) <= 0) {
            amount = 1;
        }
        boolean unique = slot.getBoolean("unique", false);
        return this.generatePool(include, unique, amount);
    }

    private List<String> poolAvailablePacks(ConfigurationSection slot) {
        HashSet<String> packs = new HashSet<String>(slot.getStringList("packs"));
        PluginTradingCards.info(3, "<CardLoot> (poolAvailablePacks) packs: " + String.valueOf(packs));
        int amount = this.evaluateAmount(slot, packs.size());
        if (amount <= 0) {
            amount = 1;
        }
        boolean unique = slot.getBoolean("unique", false);
        return this.generatePool(packs, unique, amount);
    }

    private Set<String> getCardsList(ConfigurationSection bundle) {
        if (bundle == null) {
            return null;
        }
        HashSet<String> cardSet = new HashSet<String>();
        boolean hasGames = bundle.contains("games");
        boolean hasSeries = bundle.contains("series");
        boolean hasRarities = bundle.contains("rarities");
        if (bundle.contains("list")) {
            cardSet.addAll(bundle.getStringList("list"));
        }
        if (hasGames || hasSeries || hasRarities) {
            HashSet games = hasGames ? new HashSet(bundle.getStringList("games")) : TradingCard.namespaces;
            HashSet series = hasSeries ? new HashSet(bundle.getStringList("series")) : TradingCard.series;
            HashSet rarities = hasRarities ? new HashSet(bundle.getStringList("rarities")) : TradingCard.rarities;
            PluginTradingCards.info(3, "<CardLoot> (getCardsPool) TradingCard.index = " + String.valueOf(TradingCard.index));
            for (String game : games) {
                PluginTradingCards.info(3, "<CardLoot> (getCardsPool) game = " + game);
                for (String serie : series) {
                    PluginTradingCards.info(3, "<CardLoot> (getCardsPool) serie = " + serie);
                    for (String rarity : rarities) {
                        PluginTradingCards.info(3, "<CardLoot> (getCardsPool) rarity = " + rarity);
                        List<String> cards = TradingCard.index.get(game).get(serie).get(rarity);
                        if (cards != null) {
                            cardSet.addAll(cards);
                        }
                        PluginTradingCards.info(3, "<CardLoot> (getCardsPool) cards = " + String.valueOf(cards));
                    }
                }
            }
        }
        return cardSet;
    }

    private int evaluateAmount(ConfigurationSection slot, int bundleSize) {
        if (slot.isInt("amount") || !slot.contains("amount")) {
            return Math.max(1, Math.min(slot.getInt("amount", bundleSize), 64));
        }
        String[] quantities = slot.getString("amount", "..2").split("\\.\\.");
        int min = quantities[0].isEmpty() ? 1 : Integer.parseInt(quantities[0]);
        int max = Integer.parseInt(quantities[1]);
        int range = max - min + 1;
        if (!slot.contains("function")) {
            return this.random.nextInt(range) + min;
        }
        String function = slot.getString("function", "lin").toLowerCase();
        double x = this.random.nextDouble();
        double weight = switch (function) {
            case "lin" -> x;
            case "nil" -> 1.0 - x;
            case "exp" -> Math.pow(x, 2.0);
            case "pxe" -> Math.pow(1.0 - x, 2.0);
            case "sqr" -> Math.sqrt(x);
            case "log" -> Math.log(1.0 + x * 7.0) / Math.log(8.0);
            default -> x;
        };
        int value = min + (int)(weight * (double)range);
        return Math.min(value, max);
    }

    private List<String> generatePool(Set<String> pool, boolean unique, int amount) {
        if (pool.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<String> poolList = new ArrayList<String>(pool);
        int poolSize = poolList.size();
        if (poolSize == 1) {
            return Collections.nCopies(amount, (String)poolList.getFirst());
        }
        ArrayList<String> pull = new ArrayList<String>(amount);
        if (!unique) {
            for (int i = 0; i < amount; ++i) {
                pull.add((String)poolList.get(this.random.nextInt(poolSize)));
            }
            return pull;
        }
        if (poolSize >= amount) {
            Collections.shuffle(poolList);
            pull.addAll(poolList.subList(0, amount));
            return pull;
        }
        pull.addAll(poolList);
        for (int i = pull.size(); i < amount; ++i) {
            String card = (String)poolList.get(this.random.nextInt(poolSize));
            pull.add(card);
        }
        return pull;
    }

    private void populatePack(ConfigurationSection config) {
        for (String slotName : config.getKeys(false)) {
            ConfigurationSection slotConfig = config.getConfigurationSection(slotName);
            if (slotConfig == null) continue;
            PluginTradingCards.info(3, "<CardLoot> (populatePack) slotConfig.name: " + slotConfig.getName());
            if (this.evaluateChance(slotConfig.getInt("chance", 1))) continue;
            boolean containsGlint = slotConfig.contains("glint");
            boolean isGlinted = slotConfig.getBoolean("glint");
            PluginTradingCards.info(3, "<CardLoot> (populatePack) containsGlint: " + containsGlint);
            PluginTradingCards.info(3, "<CardLoot> (populatePack) isGlinted: " + isGlinted);
            int packSize = 0;
            List<String> packs = this.poolAvailablePacks(slotConfig);
            packSize += packs.size();
            PluginTradingCards.info(3, "<CardLoot> (populatePack) packs.size: " + packs.size());
            if (this.amountTotal + packs.size() >= this.amountMax && !packs.isEmpty()) {
                packs = packs.subList(0, this.amountMax - this.amountTotal);
            }
            List<String> cards = this.poolAvailableCards(slotConfig);
            packSize += cards.size();
            PluginTradingCards.info(3, "<CardLoot> (populatePack) cards.size: " + cards.size());
            if (this.amountTotal + cards.size() >= this.amountMax && !cards.isEmpty()) {
                cards = cards.subList(0, this.amountMax - this.amountTotal);
            }
            this.amountTotal += packSize;
            this.cardPacks.addAll(packs);
            if (!containsGlint) {
                this.cardsChance.addAll(cards);
            } else if (isGlinted) {
                this.cardsGlinty.addAll(cards);
            } else {
                this.cardsNormal.addAll(cards);
            }
            PluginTradingCards.info(3, "<CardLoot> (populatePack) cardPacks: " + String.valueOf(this.cardPacks));
            PluginTradingCards.info(3, "<CardLoot> (populatePack) cardsNormal: " + String.valueOf(this.cardsNormal));
            PluginTradingCards.info(3, "<CardLoot> (populatePack) cardsGlinty: " + String.valueOf(this.cardsGlinty));
            PluginTradingCards.info(3, "<CardLoot> (populatePack) cardsChance: " + String.valueOf(this.cardsChance));
            PluginTradingCards.info(3, "<CardLoot> (populatePack) amountTotal: " + this.amountTotal);
            if (this.amountTotal < this.amountMax) continue;
            break;
        }
        if (this.amountTotal < this.amountMin) {
            this.amountMax = this.amountMin;
            this.populatePack(config);
        }
    }

    private List<ItemStack> generateCardLoot() {
        ArrayList<ItemStack> loot = new ArrayList<ItemStack>();
        Material cardMaterial = Material.getMaterial((String)ConfigManager.getConfig("lists").getString("material.card", "PAPER"));
        Material packMaterial = Material.getMaterial((String)ConfigManager.getConfig("lists").getString("material.pack", "BOOK"));
        for (String card : this.cardsChance) {
            loot.add(TradingCardStack.init(cardMaterial).generate(card, this.random).build());
        }
        for (String card : this.cardsGlinty) {
            loot.add(TradingCardStack.init(cardMaterial).create(card, true).build());
        }
        for (String card : this.cardsNormal) {
            loot.add(TradingCardStack.init(cardMaterial).create(card, false).build());
        }
        for (String pack : this.cardPacks) {
            long randomNextLong = this.random.nextLong();
            PluginTradingCards.info(3, "<CardLoot> (generateCardLoot) randomNextLong: " + randomNextLong);
            loot.add(CardPackStack.init(packMaterial).generate(pack, Long.toHexString(randomNextLong)).build());
        }
        return loot;
    }
}

