/*
 * Decompiled with CFR 0.152.
 */
package me.kokko.tradingcards;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import me.kokko.tradingcards.CardLoot;
import me.kokko.tradingcards.ConfigManager;
import me.kokko.tradingcards.PluginTradingCards;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.inventory.ItemStack;

public class CardPack {
    public static final Set<String> list = new HashSet<String>();
    private static FileConfiguration packs;

    public CardPack() {
        if (packs == null) {
            packs = ConfigManager.getConfig("packs");
        }
    }

    public static List<ItemStack> unpack(String name, Long seed) {
        CardPack pack = new CardPack();
        return pack.open(name, seed);
    }

    public static void listLoad(FileConfiguration config) {
        if (config == null) {
            return;
        }
        ConfigurationSection packs = config.getConfigurationSection("pack");
        if (packs == null) {
            return;
        }
        list.addAll(packs.getKeys(false));
    }

    public List<ItemStack> open(String cardPackName, Long seed) {
        ConfigurationSection pack = this.getPackContents(cardPackName);
        if (pack == null) {
            return Collections.emptyList();
        }
        if (!ConfigManager.hasFeature("always-random")) {
            seed = PluginTradingCards.getTimeSeed();
        }
        Random random = new Random(seed);
        return CardLoot.rand(random).loot(pack);
    }

    private ConfigurationSection getPackContents(String name) {
        ConfigurationSection pack = packs.getConfigurationSection("pack." + name);
        if (pack == null) {
            return null;
        }
        return pack.getConfigurationSection("contents");
    }
}

