/*
 * Decompiled with CFR 0.152.
 */
package me.kokko.tradingcards;

import me.kokko.tradingcards.Artifakt;
import me.kokko.tradingcards.ConfigManager;
import me.kokko.tradingcards.Komponent;
import me.kokko.tradingcards.PluginTradingCards;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class CardPackStack
extends Artifakt {
    private String packName;
    private String packSeed;
    private ConfigurationSection packConfig;

    public CardPackStack(Material material) {
        super(material);
    }

    public static CardPackStack init(Material material) {
        return new CardPackStack(material);
    }

    public CardPackStack generate(String name, String seed) {
        if (!this.setConfig(name)) {
            return this;
        }
        this.packName = name;
        this.packSeed = seed;
        return this;
    }

    @Override
    public ItemStack build() {
        this.setMeta(this.packName, this.packSeed);
        this.setDisplay();
        this.meta.lore(this.lore);
        this.item.setItemMeta(this.meta);
        return this.item;
    }

    private boolean setConfig(String name) {
        this.packConfig = ConfigManager.getConfig("packs").getConfigurationSection("pack." + name);
        return this.packConfig != null;
    }

    private void setMeta(String name, String seed) {
        PluginTradingCards.info(3, "<CardPackStack> (setMeta) name: " + name);
        PluginTradingCards.info(3, "<CardPackStack> (setMeta) seed: " + seed);
        this.metaKey((Plugin)PluginTradingCards.getInstance(), "card-pack", name);
        this.metaKey((Plugin)PluginTradingCards.getInstance(), "card-pack-seed", seed);
        this.customModelData(this.packConfig.getInt("custom-model-data"));
    }

    private void setDisplay() {
        ConfigurationSection packLore = this.packConfig.getConfigurationSection("lore");
        this.name(Komponent.assemble(this.packConfig).build(true));
        this.loreAdd(Komponent.assemble(packLore).build(true));
    }
}

