/*
 * Decompiled with CFR 0.152.
 */
package me.kokko.tradingcards;

import java.util.HashMap;
import java.util.Map;
import me.kokko.tradingcards.ConfigManager;
import me.kokko.tradingcards.PluginTradingCards;
import me.kokko.tradingcards.TradingCardStack;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.MemoryConfiguration;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public class CardsInventory
implements InventoryHolder {
    public static final Map<String, CardsInventory> map = new HashMap<String, CardsInventory>();
    private final Inventory inventory;

    public CardsInventory(int size, String name) {
        TextComponent title = Component.text(name);
        this.inventory = PluginTradingCards.getInstance().getServer().createInventory((InventoryHolder)this, size, (Component)title);
        PluginTradingCards.info(3, "<CardsInventory> (constructor) created inventory: " + String.valueOf(title));
    }

    public static void loadMap() {
        map.clear();
        FileConfiguration dataConfig = ConfigManager.getConfig("data");
        ConfigurationSection inventoriesSection = dataConfig.getConfigurationSection("inventories");
        if (inventoriesSection == null) {
            inventoriesSection = dataConfig.createSection("inventories");
        }
        for (String inventoryData : inventoriesSection.getKeys(false)) {
            ConfigurationSection inventory = inventoriesSection.getConfigurationSection(inventoryData);
            if (inventory == null) continue;
            CardsInventory cardsInventory = new CardsInventory(inventory.getInt("size"), inventory.getName());
            cardsInventory.fromConfig(inventory);
            map.put(inventoryData, cardsInventory);
        }
    }

    public static void saveMap() {
        FileConfiguration dataConfig = ConfigManager.getConfig("data");
        dataConfig.set("inventories", null);
        ConfigurationSection inventoriesSection = dataConfig.createSection("inventories");
        map.forEach((key, cardsInventory) -> inventoriesSection.set(key, (Object)cardsInventory.toConfig()));
        ConfigManager.saveConfig("data");
    }

    @NotNull
    public Inventory getInventory() {
        Inventory inventory = this.inventory;
        if (inventory == null) {
            CardsInventory.$$$reportNull$$$0(0);
        }
        return inventory;
    }

    public ConfigurationSection toConfig() {
        MemoryConfiguration section = new MemoryConfiguration();
        section.set("size", (Object)this.inventory.getSize());
        for (int i = 0; i < this.inventory.getSize(); ++i) {
            ItemStack item = this.inventory.getItem(i);
            if (item == null) continue;
            String itemData = this.serializeItem(item);
            section.set("item" + i, (Object)itemData);
        }
        return section;
    }

    public void fromConfig(ConfigurationSection section) {
        String materialName = ConfigManager.getConfig("lists").getString("item.card.material", "PAPER");
        Material material = Material.getMaterial((String)materialName);
        for (String key : section.getKeys(false)) {
            String[] card;
            String value;
            if (key.equals("size") || (value = section.getString(key)) == null || !value.contains(".") || (card = value.split("\\.")).length < 3) continue;
            String id = card[0];
            boolean glint = Boolean.parseBoolean(card[1]);
            int stack = Integer.parseInt(card[2]);
            ItemStack item = TradingCardStack.init(material).create(id, glint).build();
            if (item == null) continue;
            item.setAmount(stack);
            int index = Integer.parseInt(key.replace("item", ""));
            this.inventory.setItem(index, item);
        }
    }

    private String serializeItem(ItemStack item) {
        String id = (String)item.getPersistentDataContainer().get(new NamespacedKey((Plugin)PluginTradingCards.getInstance(), "card-id"), PersistentDataType.STRING);
        boolean glint = item.getItemMeta() != null && item.getItemMeta().getEnchantmentGlintOverride() != false;
        int stack = item.getAmount();
        return String.join((CharSequence)".", id, String.valueOf(glint), String.valueOf(stack));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "me/kokko/tradingcards/CardsInventory", "getInventory"));
    }
}

