/*
 * Decompiled with CFR 0.152.
 */
package me.kokko.tradingcards;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import me.kokko.tradingcards.Artifakt;
import me.kokko.tradingcards.CardPack;
import me.kokko.tradingcards.CardPackStack;
import me.kokko.tradingcards.ConfigManager;
import me.kokko.tradingcards.InventoryBattlefield;
import me.kokko.tradingcards.Komponent;
import me.kokko.tradingcards.PluginTradingCards;
import me.kokko.tradingcards.TradingCard;
import me.kokko.tradingcards.TradingCardStack;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabExecutor;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CommandManager
implements TabExecutor {
    private static final String ITEM_MATERIAL_PATH = "item.%s.material";
    private final Map<String, CommandAction> commands = new HashMap<String, CommandAction>();
    private final Map<String, String> permissions = new HashMap<String, String>();
    private final Map<String, Material> materialCache = new HashMap<String, Material>();

    public CommandManager() {
        this.initializeCommands();
        this.cachePermissions();
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        if (sender == null) {
            CommandManager.$$$reportNull$$$0(0);
        }
        if (command == null) {
            CommandManager.$$$reportNull$$$0(1);
        }
        if (label == null) {
            CommandManager.$$$reportNull$$$0(2);
        }
        if (args == null) {
            CommandManager.$$$reportNull$$$0(3);
        }
        if (this.getPlayer(sender) == null) {
            return true;
        }
        if (args.length == 0) {
            this.showCommandUsage(sender, label);
            return true;
        }
        String action = args[0].toLowerCase();
        return this.processCommand(sender, action, Arrays.copyOfRange(args, 1, args.length));
    }

    private Player getPlayer(CommandSender sender) {
        if (sender instanceof Player) {
            Player player = (Player)sender;
            return player;
        }
        sender.sendMessage(ConfigManager.message("player-only-command"));
        return null;
    }

    private boolean processCommand(CommandSender sender, String command, String[] args) {
        if (!this.validateCommand(sender, command)) {
            return true;
        }
        CommandAction action = this.commands.get(command);
        if (action == null) {
            sender.sendMessage(ConfigManager.message("unknown-command"));
            return false;
        }
        return action.execute(sender, args);
    }

    private boolean validateCommand(CommandSender sender, String command) {
        if (!ConfigManager.hasFeature(command)) {
            sender.sendMessage(ConfigManager.message("feature-disabled"));
            return false;
        }
        if (!this.hasPermission(sender, command)) {
            sender.sendMessage(ConfigManager.message("missing-permission"));
            return false;
        }
        return true;
    }

    private void initializeCommands() {
        this.registerCommand("give", this::handleGive);
        this.registerCommand("update", this::handleUpdate);
        this.registerCommand("album", this::handleAlbum);
        this.registerCommand("pack", this::handlePack);
        this.registerCommand("battle", this::handleBattle);
        this.registerCommand("reload", this::handleReload);
    }

    private void registerCommand(String name, CommandAction action) {
        this.commands.put(name, action);
        PluginTradingCards.info(3, "<CommandManager> (registerCommand) Command Registered: " + name);
    }

    private void cachePermissions() {
        ConfigurationSection perms = ConfigManager.getConfig("config").getConfigurationSection("permissions");
        if (perms == null) {
            return;
        }
        for (String key : perms.getKeys(false)) {
            String value = this.getPermissionValue(key);
            this.permissions.put(key, this.getPermissionValue(key));
            PluginTradingCards.info(3, "<CommandManager> (getPermissionValue) Permission " + key + " registered as " + value);
        }
    }

    private String getPermissionValue(String key) {
        return ConfigManager.getConfig("config").getString("permission." + key);
    }

    private boolean hasPermission(CommandSender sender, String command) {
        String permission = this.permissions.get(command);
        return permission == null || sender.hasPermission(permission);
    }

    private boolean handleGive(CommandSender sender, String[] args) {
        Player player = this.getPlayer(sender);
        if (player == null) {
            return false;
        }
        if (args.length == 0) {
            player.sendMessage(ConfigManager.message("missing-argument"));
            return true;
        }
        String cardId = args[0].toLowerCase();
        if (!this.isValidCard(cardId)) {
            player.sendMessage(ConfigManager.message("card-not-found"));
            return true;
        }
        boolean glinted = false;
        if (args.length > 1) {
            if (!this.isValidBoolean(args[1])) {
                player.sendMessage(ConfigManager.message("invalid-boolean"));
                return true;
            }
            glinted = this.parseBoolean(args[1]) && this.hasPermission((CommandSender)player, "give-glinted");
        }
        player.getInventory().addItem(new ItemStack[]{TradingCardStack.init(this.getCachedMaterial("card", Material.PAPER)).create(args[0], glinted).build()});
        return true;
    }

    private boolean handleUpdate(CommandSender sender, String[] args) {
        Player player = this.getPlayer(sender);
        if (player == null) {
            return true;
        }
        ItemStack selectedCard = player.getInventory().getItemInMainHand();
        ItemMeta meta = selectedCard.getItemMeta();
        NamespacedKey key = new NamespacedKey((Plugin)PluginTradingCards.getInstance(), "card-id");
        if (meta == null || !meta.getPersistentDataContainer().has(key, PersistentDataType.STRING)) {
            PluginTradingCards.info(2, "<CommandManager> (updateCommand) Card is not CARD");
            player.sendMessage(ConfigManager.message("invalid-item-held"));
            return false;
        }
        String id = (String)meta.getPersistentDataContainer().get(key, PersistentDataType.STRING);
        ItemMeta cardUpdatedMeta = TradingCardStack.init(this.getCachedMaterial("card", Material.PAPER)).create(id, meta.getEnchantmentGlintOverride()).build().getItemMeta();
        meta.displayName(cardUpdatedMeta.displayName());
        meta.lore(cardUpdatedMeta.lore());
        selectedCard.setItemMeta(meta);
        return true;
    }

    private boolean handleAlbum(CommandSender sender, String[] args) {
        String albumId;
        Player player = this.getPlayer(sender);
        if (player == null) {
            return false;
        }
        String string = args.length > 0 ? (this.hasPermission((CommandSender)player, "album-own") && args[0].equals(player.getName()) ? player.getName() : (this.hasPermission((CommandSender)player, "album-specific") ? args[0] : null)) : (albumId = this.hasPermission((CommandSender)player, "album-random") ? Long.toHexString(PluginTradingCards.getTimeSeed()) : null);
        if (albumId == null) {
            player.sendMessage(ConfigManager.message("missing-permission"));
            return false;
        }
        ConfigurationSection config = ConfigManager.getConfig("lists").getConfigurationSection("item.album");
        if (config == null) {
            player.sendMessage(ConfigManager.message("missing-configs"));
            return false;
        }
        ConfigurationSection name = config.getConfigurationSection("name");
        ConfigurationSection lore = config.getConfigurationSection("lore");
        Material material = this.getCachedMaterial("album", Material.BOOK);
        Artifakt cardAlbum = Artifakt.material(material).metaKey((Plugin)PluginTradingCards.getInstance(), "card-album", albumId).customModelData(config.getInt("custom-model-data")).name(Komponent.assemble(name).build(true)).loreAdd(Komponent.assemble(lore).build(true));
        player.getInventory().addItem(new ItemStack[]{cardAlbum.build()});
        return true;
    }

    private boolean handlePack(CommandSender sender, String[] args) {
        Player player = this.getPlayer(sender);
        if (player == null) {
            return false;
        }
        if (args.length == 0) {
            player.sendMessage(ConfigManager.message("pack-not-selected"));
            return false;
        }
        String name = args[0];
        long seed = args.length >= 2 ? (long)args[1].chars().sum() : PluginTradingCards.getTimeSeed();
        String seedString = Long.toHexString(seed);
        PluginTradingCards.info(3, "<CommandManager> (packCommand) name " + name);
        PluginTradingCards.info(3, "<CommandManager> (packCommand) seed " + seedString);
        player.getInventory().addItem(new ItemStack[]{CardPackStack.init(this.getCachedMaterial("pack", Material.BOOK)).generate(name, seedString).build()});
        return true;
    }

    private boolean handleBattle(CommandSender sender, String[] args) {
        String action;
        Player player = this.getPlayer(sender);
        if (player == null) {
            return false;
        }
        if (args.length == 0) {
            player.sendMessage(ConfigManager.message("command-incomplete"));
            return false;
        }
        switch (action = args[0].toLowerCase()) {
            case "request": {
                if (args.length < 2) {
                    player.sendMessage(ConfigManager.message("battle-request-incomplete"));
                    return false;
                }
                Player target = Bukkit.getPlayer((String)args[1]);
                if (target == null || player == target) {
                    player.sendMessage(ConfigManager.message("invalid-player"));
                    return false;
                }
                return InventoryBattlefield.request(player, target);
            }
            case "accept": {
                return InventoryBattlefield.accept(player);
            }
            case "open": {
                return InventoryBattlefield.open(player);
            }
            case "close": {
                return InventoryBattlefield.close(player);
            }
        }
        player.sendMessage(ConfigManager.message("invalid-command"));
        return false;
    }

    private boolean handleReload(CommandSender sender, String[] args) {
        PluginTradingCards.info(4, "<CommandManager> (handleReload) calling ConfigManager.reloadConfigs()");
        ConfigManager.reloadConfigs();
        TradingCard.indexLoad();
        CardPack.listLoad(ConfigManager.getConfig("packs"));
        sender.sendMessage(ConfigManager.message("reload-complete"));
        return true;
    }

    @Nullable
    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        if (sender == null) {
            CommandManager.$$$reportNull$$$0(4);
        }
        if (command == null) {
            CommandManager.$$$reportNull$$$0(5);
        }
        if (label == null) {
            CommandManager.$$$reportNull$$$0(6);
        }
        if (args == null) {
            CommandManager.$$$reportNull$$$0(7);
        }
        if (args.length == 0) {
            return Collections.emptyList();
        }
        String input = args[args.length - 1].toLowerCase();
        LinkedHashSet<String> completions = new LinkedHashSet<String>();
        String action = args[0].toLowerCase();
        switch (args.length) {
            case 1: {
                this.handleRootCompletions(sender, action, completions);
                break;
            }
            case 2: {
                this.handleSecondArgCompletions(sender, action, input, completions);
                break;
            }
            case 3: {
                this.handleThirdArgCompletions(sender, action, input, completions);
            }
        }
        return this.sortedUniqueCompletions(completions);
    }

    private void handleRootCompletions(CommandSender sender, String input, Set<String> completions) {
        this.commands.keySet().stream().filter(command -> command.startsWith(input)).filter(command -> this.hasPermission(sender, (String)command)).filter(ConfigManager::hasFeature).forEach(completions::add);
    }

    private void handleSecondArgCompletions(CommandSender sender, String command, String input, Set<String> completions) {
        switch (command) {
            case "give": {
                this.addFilteredCompletions(TradingCard.cards, input, completions);
                break;
            }
            case "pack": {
                this.addFilteredCompletions(CardPack.list, input, completions);
                break;
            }
            case "album": {
                if (this.hasPermission(sender, "album-specific")) {
                    completions.addAll(this.suggestOnlinePlayers(input));
                }
                if (this.hasPermission(sender, "album-own")) {
                    completions.add(sender.getName());
                    break;
                }
                completions.remove(sender.getName());
                break;
            }
            case "battle": {
                this.addFilteredCompletions(List.of("request", "accept", "open", "close"), input, completions);
            }
        }
    }

    private void handleThirdArgCompletions(CommandSender sender, String command, String input, Set<String> completions) {
        switch (command) {
            case "give": {
                this.addBooleanCompletions(input, completions);
                break;
            }
            case "battle": {
                completions.addAll(this.suggestOnlinePlayers(input));
            }
        }
    }

    private void addFilteredCompletions(Collection<String> source, String input, Set<String> output) {
        source.stream().filter(item -> item.toLowerCase().startsWith(input)).forEach(output::add);
    }

    private void addBooleanCompletions(String input, Set<String> output) {
        Stream.of("true", "false").filter(bool -> bool.startsWith(input)).forEach(output::add);
    }

    private List<String> suggestOnlinePlayers(String input) {
        return Bukkit.getOnlinePlayers().stream().map(Player::getName).filter(name -> name.toLowerCase().startsWith(input)).collect(Collectors.toList());
    }

    private List<String> sortedUniqueCompletions(Set<String> completions) {
        return completions.stream().distinct().sorted().collect(Collectors.toList());
    }

    private Material getCachedMaterial(String selector, Material fallback) {
        return this.materialCache.computeIfAbsent(selector, key -> {
            Material material = Material.matchMaterial((String)ConfigManager.getConfig("lists").getString(String.format(ITEM_MATERIAL_PATH, selector), key));
            return material == null ? fallback : material;
        });
    }

    private boolean parseBoolean(String input) {
        return Boolean.parseBoolean(input.toLowerCase());
    }

    private boolean isValidCard(String cardId) {
        return TradingCard.cards.contains(cardId);
    }

    private boolean isValidBoolean(String input) {
        return input.equalsIgnoreCase("true") || input.equalsIgnoreCase("false");
    }

    private void showCommandUsage(CommandSender sender, String command) {
        sender.sendMessage("Usage: '/" + command + " [args]'");
        sender.sendMessage("or type: '/" + command + " help' for more info");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sender";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "label";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "args";
                break;
            }
        }
        objectArray2[1] = "me/kokko/tradingcards/CommandManager";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "onCommand";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "onTabComplete";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static interface CommandAction {
        public boolean execute(CommandSender var1, String[] var2);
    }
}

