/*
 * Decompiled with CFR 0.152.
 */
package me.kokko.tradingcards;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import me.kokko.tradingcards.PluginTradingCards;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class ConfigManager {
    private static PluginTradingCards plugin;
    private static final Map<String, FileConfiguration> configs;
    private static final List<String> CONFIG_FILES;

    public static synchronized void initialize(PluginTradingCards pluginInstance) {
        if (plugin != null) {
            PluginTradingCards.info(2, "<ConfigManager> (initialize) ConfigManager already initialized");
        } else {
            plugin = pluginInstance;
            plugin.saveDefaultConfig();
            PluginTradingCards.info(3, "<ConfigManager> (initialize) ConfigManager initialized");
        }
        ConfigManager.reloadConfigs();
    }

    public static FileConfiguration getConfig(String name) {
        return configs.computeIfAbsent(name, k -> {
            PluginTradingCards.info(2, "<ConfigManager> (getConfig) Config '" + name + "' not found. Returning Empty.");
            return new YamlConfiguration();
        });
    }

    public static void saveConfig(String name) {
        FileConfiguration config = configs.get(name);
        String path = name + ".yml";
        if (config == null) {
            PluginTradingCards.info(1, "<ConfigManager> (saveConfig) Config '" + name + "' not found. Cannot save.");
            return;
        }
        File file = new File(plugin.getDataFolder(), path);
        try {
            config.save(file);
        }
        catch (IOException e) {
            PluginTradingCards.info(1, "<ConfigManager> (saveConfig) Error saving '" + path + "' #[" + e.getMessage() + "]#");
        }
    }

    public static String message(String path) {
        FileConfiguration messages = ConfigManager.getConfig("messages");
        String result = messages.getString(path, path);
        if (result.equals(path)) {
            PluginTradingCards.info(1, "<ConfigManager> (message) Missing message key: " + path);
        }
        return result;
    }

    public static synchronized void reloadConfigs() {
        PluginTradingCards.info(3, "<ConfigManager> (reloadConfigs) Reloading config files");
        if (plugin == null) {
            PluginTradingCards.info(1, "<ConfigManager> (reloadConfigs) Not initialized!");
            return;
        }
        PluginTradingCards.info(3, "<ConfigManager> (reloadConfigs) Debug level is resetting");
        plugin.resetDebugLevel();
        PluginTradingCards.info(3, "<ConfigManager> (reloadConfigs) Debug level has been reset");
        configs.clear();
        PluginTradingCards.info(3, "<ConfigManager> (reloadConfigs) Configs cleared from cache");
        plugin.reloadConfig();
        PluginTradingCards.info(3, "<ConfigManager> (reloadConfigs) Plugin files reloaded");
        configs.put("config", plugin.getConfig());
        PluginTradingCards.info(3, "<ConfigManager> (reloadConfigs) config added to config cache");
        CONFIG_FILES.forEach(ConfigManager::loadCustomConfig);
        PluginTradingCards.info(3, "<ConfigManager> (reloadConfigs) Configs reloaded");
    }

    public static boolean hasFeature(String feature) {
        return ConfigManager.getConfig("config").getBoolean("feature." + feature, true);
    }

    public static ConfigurationSection getSetting() {
        return ConfigManager.getConfig("config").getConfigurationSection("setting");
    }

    private static void loadCustomConfig(String name) {
        File file = new File(plugin.getDataFolder(), name + ".yml");
        if (!file.exists()) {
            try {
                plugin.saveResource(name + ".yml", false);
            }
            catch (IllegalArgumentException e) {
                PluginTradingCards.info(1, "<ConfigManager> (loadCustomConfig) Resource not found in JAR!");
            }
        }
        configs.put(name, (FileConfiguration)YamlConfiguration.loadConfiguration((File)file));
        PluginTradingCards.info(3, "<ConfigManager> (loadCustomConfig) " + name + " added to config cache");
    }

    private ConfigManager() {
        throw new AssertionError((Object)"Cannot instantiate ConfigManager");
    }

    static {
        configs = new ConcurrentHashMap<String, FileConfiguration>();
        CONFIG_FILES = List.of("messages", "games", "cards", "packs", "drops", "lists", "data");
    }
}

