/*
 * Decompiled with CFR 0.152.
 */
package me.kokko.tradingcards;

import java.util.HashMap;
import java.util.Map;
import me.kokko.tradingcards.ConfigManager;
import me.kokko.tradingcards.PluginTradingCards;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public class InventoryBattlefield
implements InventoryHolder {
    private static final Map<Player, Player> requests = new HashMap<Player, Player>();
    private static final Map<Player, InventoryBattlefield> battles = new HashMap<Player, InventoryBattlefield>();
    private final Inventory inventory;

    public InventoryBattlefield(PluginTradingCards plugin, String title) {
        this.inventory = plugin.getServer().createInventory((InventoryHolder)this, 54, (Component)Component.text(title));
        PluginTradingCards.info(3, "<InventoryBattlefield> (constructor) new battlefield: " + title);
    }

    public static boolean request(Player player1, Player player2) {
        if (requests.containsKey(player1)) {
            player1.sendMessage(ConfigManager.message("battle-request-pending"));
            return false;
        }
        if (requests.containsKey(player2)) {
            player1.sendMessage(ConfigManager.message("battle-request-busy"));
            return false;
        }
        if (battles.containsKey(player1)) {
            player1.sendMessage(ConfigManager.message("battle-in-progress"));
            return false;
        }
        if (battles.containsKey(player2)) {
            player1.sendMessage(ConfigManager.message("battle-player-busy"));
            return false;
        }
        requests.put(player2, player1);
        Bukkit.getScheduler().runTaskLater((Plugin)PluginTradingCards.getInstance(), () -> requests.remove(player2), 7200L);
        player2.sendMessage(ConfigManager.message("battle-request-received"));
        player1.sendMessage(ConfigManager.message("battle-request-sent"));
        return true;
    }

    public static boolean accept(Player player2) {
        if (requests.containsKey(player2)) {
            Player player1 = requests.get(player2);
            requests.remove(player2);
            InventoryBattlefield.createBattlefield(player1, player2);
            return true;
        }
        player2.sendMessage(ConfigManager.message("no-request-pending"));
        return false;
    }

    public static boolean open(Player player) {
        if (!battles.containsKey(player)) {
            return false;
        }
        player.openInventory(battles.get(player).getInventory());
        return true;
    }

    public static boolean close(Player player) {
        if (!battles.containsKey(player)) {
            return false;
        }
        battles.remove(player);
        return true;
    }

    @NotNull
    public Inventory getInventory() {
        Inventory inventory = this.inventory;
        if (inventory == null) {
            InventoryBattlefield.$$$reportNull$$$0(0);
        }
        return inventory;
    }

    private static void createBattlefield(Player player1, Player player2) {
        InventoryBattlefield battlefield = new InventoryBattlefield(PluginTradingCards.getInstance(), "Battlefield");
        Inventory inventory = battlefield.getInventory();
        battles.put(player1, battlefield);
        battles.put(player2, battlefield);
        player1.openInventory(inventory);
        player2.openInventory(inventory);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "me/kokko/tradingcards/InventoryBattlefield", "getInventory"));
    }
}

