/*
 * Decompiled with CFR 0.152.
 */
package me.kokko.tradingcards;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import net.kyori.adventure.text.minimessage.MiniMessage;
import org.bukkit.configuration.ConfigurationSection;

public class Komponent {
    public boolean hideLabel = false;
    private String text = null;
    private String colors = null;
    private Set<String> decorations;
    private Component container = Component.empty();
    private Component prefix = Component.empty();
    private Component component = null;
    private Component suffix = Component.empty();
    private Component end = Component.empty();
    private static final Map<String, TextColor> customColors = new HashMap<String, TextColor>();
    private static final Map<String, String> customGradients = new HashMap<String, String>();
    private static final Map<String, TextColor> colorCache = new HashMap<String, TextColor>();
    private static final Set<TextDecoration> decorationsCache = new HashSet<TextDecoration>();

    public Komponent() {
        this.decorations = new HashSet<String>();
    }

    public static Komponent empty() {
        return new Komponent();
    }

    public static Komponent text(String text) {
        Komponent komponent = new Komponent();
        komponent.text = text;
        return komponent;
    }

    public static Komponent assemble(ConfigurationSection stylesheet) {
        Komponent komponent = new Komponent();
        komponent.compose(stylesheet);
        return komponent;
    }

    public Komponent format(ConfigurationSection stylesheet) {
        if (stylesheet == null) {
            return this;
        }
        this.text = this.text == null ? stylesheet.getString("text", stylesheet.getName()) : this.text;
        this.colors = this.colors == null ? stylesheet.getString("color") : this.colors;
        HashSet decorationSet = new HashSet(stylesheet.getStringList("style"));
        this.decorations = this.decorations.isEmpty() ? decorationSet : this.decorations;
        return this;
    }

    public Komponent compose(ConfigurationSection stylesheet) {
        if (stylesheet == null) {
            return this;
        }
        if (!stylesheet.getBoolean("label", true)) {
            this.hideLabel = true;
            return this;
        }
        this.format(stylesheet);
        this.container = this.buildComponentFrom(null, stylesheet.getString("container.color"), new HashSet<String>(stylesheet.getStringList("container.style")));
        this.prefix = this.buildComponentFrom(stylesheet.getString("affix.prefix"), stylesheet.getString("affix.color"), new HashSet<String>(stylesheet.getStringList("affix.style")));
        this.suffix = this.buildComponentFrom(stylesheet.getString("affix.suffix"), stylesheet.getString("affix.color"), new HashSet<String>(stylesheet.getStringList("affix.style")));
        this.end = this.buildComponentFrom(stylesheet.getString("end.text"), stylesheet.getString("end.color"), new HashSet<String>(stylesheet.getStringList("end.style")));
        return this;
    }

    public Component build(boolean condition) {
        if (!condition || this.hideLabel) {
            return Component.empty();
        }
        this.component = this.buildComponentFrom(this.text, this.colors, this.decorations);
        return this.container.append(this.prefix).append(this.component).append(this.suffix).append(this.end);
    }

    private Component decorateComponent(Component component, Set<String> decors) {
        HashSet<TextDecoration> textDecorations = new HashSet<TextDecoration>();
        for (String decoration : decors) {
            textDecorations.add(TextDecoration.NAMES.value(decoration));
        }
        return (Component)component.decorations(textDecorations, true);
    }

    private Component colorComponent(Component component, String color) {
        if (color == null) {
            return component;
        }
        return component.color(this.parseTextColor(color));
    }

    private Component gradientComponent(String text, String colors) {
        if (text == null) {
            return Component.empty();
        }
        if (customGradients.containsKey(colors)) {
            colors = customGradients.get(colors);
        }
        return MiniMessage.miniMessage().deserialize("<gradient:" + colors + ">" + text + "</gradient>");
    }

    private Component buildComponentFrom(String text, String color, Set<String> styles) {
        Component component = text == null ? Component.empty() : Component.text(text);
        component = component.color(NamedTextColor.WHITE);
        if (color != null) {
            component = this.isGradient(color) ? this.gradientComponent(text, color) : this.colorComponent(component, color.replace(":", ""));
        }
        component = (Component)component.decorations(decorationsCache, false);
        if (styles != null) {
            component = this.decorateComponent(component, styles);
        }
        return component;
    }

    private boolean isGradient(String colors) {
        return customGradients.containsKey(colors) || colors.contains(":");
    }

    private TextColor parseTextColor(String color) {
        if ((color = color.toLowerCase()).startsWith("#") && color.length() == 7) {
            return TextColor.fromHexString(color);
        }
        NamedTextColor namedColor = NamedTextColor.NAMES.value(color);
        if (namedColor != null) {
            return namedColor;
        }
        if (customColors.containsKey(color)) {
            return customColors.get(color);
        }
        if (color.equalsIgnoreCase("squid")) {
            Random random = new Random();
            int r = random.nextInt(256);
            int g = random.nextInt(256);
            int b = random.nextInt(256);
            return TextColor.color(r, g, b);
        }
        return NamedTextColor.WHITE;
    }

    private static void initializeStaticData() {
        Komponent.initializeCustomColors();
        Komponent.initializeCustomGradients();
        Komponent.initializeDecorations();
    }

    private static void initializeCustomColors() {
        String[][] colors;
        for (String[] color : colors = new String[][]{{"grey", "#C6C6C6"}, {"quartz", "#E3D4D1"}, {"iron", "#CECACA"}, {"netherite", "#443A3B"}, {"redstone", "#971607"}, {"aurum", "#DEB12D"}, {"emerald", "#47A036"}, {"diamond", "#2CBAA8"}, {"lapis", "#21497B"}, {"amethyst", "#9A5CC6"}, {"resin", "#EB7114"}, {"cga", "#AA5500"}, {"obsidian", "#3F0A45"}, {"powerful", "#E5247E"}}) {
            customColors.put(color[0], Komponent.getTextColor(color[1]));
        }
    }

    private static void initializeCustomGradients() {
        String[][] gradients;
        for (String[] gradient : gradients = new String[][]{{"rainbow", "#E43838:#E4C638:#2DB62D:#325199:#722C98"}, {"unique", "#F77d00:#F35400"}, {"softy", "#C1A7E2:#A77BCA"}, {"silko", "#13FA26:#13FAC2"}}) {
            customGradients.put(gradient[0], gradient[1]);
        }
    }

    private static void initializeDecorations() {
        String[] decors;
        for (String decoration : decors = new String[]{"bold", "italic", "underlined", "strikethrough", "obfuscated"}) {
            decorationsCache.add(TextDecoration.NAMES.value(decoration));
        }
    }

    private static TextColor getTextColor(String hex) {
        if (!colorCache.containsKey(hex)) {
            colorCache.put(hex, TextColor.fromHexString(hex));
        }
        return colorCache.get(hex);
    }

    static {
        Komponent.initializeStaticData();
    }
}

