/*
 * Decompiled with CFR 0.152.
 */
package me.kokko.tradingcards;

import java.util.logging.Logger;
import me.kokko.tradingcards.CardEvents;
import me.kokko.tradingcards.CardPack;
import me.kokko.tradingcards.CardsInventory;
import me.kokko.tradingcards.CommandManager;
import me.kokko.tradingcards.ConfigManager;
import me.kokko.tradingcards.TradingCard;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.PluginCommand;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public final class PluginTradingCards
extends JavaPlugin {
    public static volatile PluginTradingCards instance;
    private static volatile int debug;
    private static Logger logger;
    private static final int SAVE_DELAY = 3600;
    private static final int SAVE_PERIOD = 12000;

    public void onEnable() {
        instance = this;
        logger = this.getLogger();
        ConfigManager.initialize(this);
        this.resetDebugLevel();
        PluginTradingCards.info(3, "<PluginTradingCards> (setupMainCommand) Default config loaded: " + ConfigManager.getConfig("config").getString("load-confirm", "Roger"));
        this.setupMainCommand();
        this.getServer().getPluginManager().registerEvents((Listener)new CardEvents(), (Plugin)this);
        TradingCard.indexLoad();
        CardPack.listLoad(ConfigManager.getConfig("packs"));
        CardsInventory.loadMap();
        this.scheduleConfigSaving();
        PluginTradingCards.info(0, "TradingCards enabled!");
    }

    public void onDisable() {
        instance = null;
        CardsInventory.saveMap();
        PluginTradingCards.info(0, "TradingCards disabled!");
    }

    public static void info(int level, String message) {
        if (level > debug) {
            return;
        }
        switch (level) {
            case 1: {
                logger.severe(message);
                break;
            }
            case 2: {
                logger.warning(message);
                break;
            }
            default: {
                logger.info(message);
            }
        }
    }

    public static long getTimeSeed() {
        return (System.currentTimeMillis() ^ System.nanoTime()) & Long.MAX_VALUE;
    }

    public void resetDebugLevel() {
        debug = ConfigManager.getConfig("config").getInt("debug", 0);
    }

    public static PluginTradingCards getInstance() {
        return instance;
    }

    private void setupMainCommand() {
        PluginCommand mainCommand = this.getCommand("trading-cards");
        if (mainCommand == null) {
            return;
        }
        mainCommand.setExecutor((CommandExecutor)new CommandManager());
        PluginTradingCards.info(3, "<PluginTradingCards> (setupMainCommand) Main command '/trading-cards'|'/tc' loaded");
    }

    private void scheduleConfigSaving() {
        Bukkit.getScheduler().runTaskTimerAsynchronously((Plugin)this, CardsInventory::saveMap, 3600L, 12000L);
        PluginTradingCards.info(3, "ConfigSavingTask Class loaded and running every 12000 ticks");
    }

    static {
        debug = 0;
    }
}

