/*
 * Decompiled with CFR 0.152.
 */
package me.kokko.tradingcards;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import me.kokko.tradingcards.ConfigManager;
import me.kokko.tradingcards.PluginTradingCards;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;

public class TradingCard {
    public static final Set<String> namespaces = new HashSet<String>();
    public static final Set<String> series = new HashSet<String>();
    public static final Set<String> rarities = new HashSet<String>();
    public static final Set<String> cards = new HashSet<String>();
    public static final Map<String, Map<String, Map<String, List<String>>>> index = new HashMap<String, Map<String, Map<String, List<String>>>>();

    public static void indexLoad() {
        File cardsFile = new File(PluginTradingCards.getInstance().getDataFolder(), "cards.yml");
        long cardsLastModified = cardsFile.lastModified();
        FileConfiguration data = ConfigManager.getConfig("data");
        FileConfiguration cards = ConfigManager.getConfig("cards");
        long storedLastModified = data.getLong("cards.timestamp", 0L);
        if (cardsLastModified == storedLastModified) {
            TradingCard.fromCache(data);
        } else {
            data.set("cards.timestamp", (Object)cardsLastModified);
            TradingCard.fromConfig(cards);
            TradingCard.dataSaveConfig();
        }
    }

    private static void fromCache(FileConfiguration data) {
        ConfigurationSection cardsIndex = data.getConfigurationSection("cards.index");
        if (cardsIndex == null) {
            cardsIndex = data.createSection("cards.index");
        }
        for (String g : cardsIndex.getKeys(false)) {
            ConfigurationSection gameSection = cardsIndex.getConfigurationSection(g = g.toLowerCase());
            if (gameSection == null) continue;
            namespaces.add(g);
            for (String s : gameSection.getKeys(false)) {
                ConfigurationSection seriesSection = gameSection.getConfigurationSection(s = s.toLowerCase());
                if (seriesSection == null) continue;
                series.add(s);
                for (String r : seriesSection.getKeys(false)) {
                    r = r.toLowerCase();
                    List raritySection = seriesSection.getStringList(r);
                    rarities.add(r);
                    for (String c : raritySection) {
                        cards.add(c.toLowerCase());
                    }
                    TradingCard.addCardSetToIndex(g, s, r, raritySection);
                }
            }
        }
    }

    private static void fromConfig(FileConfiguration cardsConfig) {
        ConfigurationSection cards = cardsConfig.getConfigurationSection("card");
        if (cards == null) {
            return;
        }
        for (String card : cards.getKeys(false)) {
            ConfigurationSection cardData;
            if (TradingCard.cards.contains(card = card.toLowerCase()) || (cardData = cards.getConfigurationSection(card)) == null || !cardData.getBoolean("active", true)) continue;
            TradingCard.cards.add(card);
            String game = cardData.getString("namespace");
            String series = cardData.getString("series");
            if (game == null || series == null) continue;
            game = game.toLowerCase();
            namespaces.add(game);
            series = series.toLowerCase();
            TradingCard.series.add(series);
            String rarity = cardData.getString("rarity", "sans-any-rarity-any").toLowerCase();
            if (!rarities.contains(rarity) && !rarity.equals("sans-any-rarity-any")) {
                rarities.add(rarity);
            }
            TradingCard.addCardToIndex(game, series, rarity, card);
        }
    }

    private static void addCardSetToIndex(String game, String series, String rarity, List<String> cards) {
        index.computeIfAbsent(game, k -> new HashMap()).computeIfAbsent(series, k -> new HashMap()).put(rarity, cards);
    }

    private static void addCardToIndex(String game, String series, String rarity, String card) {
        index.computeIfAbsent(game, k -> new HashMap()).computeIfAbsent(series, k -> new HashMap()).computeIfAbsent(rarity, k -> new ArrayList()).add(card);
    }

    private static void dataSaveConfig() {
        ConfigManager.getConfig("data").set("cards.index", index);
        ConfigManager.saveConfig("data");
    }
}

